/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.unittestsupport.jaxb;

import com.google.common.io.Resources;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

class JaxbUtil2 {
    private JaxbUtil2() {
    }

    public static <T> T fromXml(Reader reader, Class<T> dtoClass) {
        Unmarshaller un = null;
        try {
            un = JaxbUtil2.getJaxbContext(dtoClass).createUnmarshaller();
            return (T)un.unmarshal(reader);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromXml(Class<?> contextClass, String resourceName, Charset charset, Class<T> dtoClass) throws IOException {
        URL url = Resources.getResource(contextClass, (String)resourceName);
        String s = Resources.toString((URL)url, (Charset)charset);
        return JaxbUtil2.fromXml(new StringReader(s), dtoClass);
    }

    public static <T> String toXml(T dto) {
        CharArrayWriter caw = new CharArrayWriter();
        JaxbUtil2.toXml(dto, caw);
        return caw.toString();
    }

    public static <T> void toXml(T dto, Writer writer) {
        Marshaller m = null;
        try {
            Class<?> aClass = dto.getClass();
            m = JaxbUtil2.getJaxbContext(aClass).createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(dto, writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private static JAXBContext getJaxbContext(Class<?> dtoClass) {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{dtoClass});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

