/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.unittestsupport.jmocking;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.jmock.api.Imposteriser;
import org.jmock.api.Invocation;
import org.jmock.api.Invokable;
import org.jmock.lib.JavaReflectionImposteriser;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class JavassistImposteriser
implements Imposteriser {
    public static final Imposteriser INSTANCE = new JavassistImposteriser();
    private final Imposteriser reflectionImposteriser = new JavaReflectionImposteriser();
    private final Objenesis objenesis = new ObjenesisStd();

    private JavassistImposteriser() {
    }

    public boolean canImposterise(Class<?> mockedType) {
        if (mockedType.isInterface()) {
            return this.reflectionImposteriser.canImposterise(mockedType);
        }
        return !mockedType.isPrimitive() && !Modifier.isFinal(mockedType.getModifiers()) && !JavassistImposteriser.toStringMethodIsFinal(mockedType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T imposterise(Invokable mockObject, Class<T> mockedType, Class<?> ... ancilliaryTypes) {
        if (!this.canImposterise(mockedType)) {
            throw new IllegalArgumentException(mockedType.getName() + " cannot be imposterized (either a primitive, or a final type or has final toString method)");
        }
        if (mockedType.isInterface()) {
            return (T)this.reflectionImposteriser.imposterise(mockObject, mockedType, (Class[])ancilliaryTypes);
        }
        try {
            JavassistImposteriser.setConstructorsAccessible(mockedType, true);
            Class<?> proxyClass = this.proxyClass(mockedType, ancilliaryTypes);
            Object proxy = this.proxy(proxyClass, mockObject);
            T t = mockedType.cast(proxy);
            return t;
        }
        finally {
            JavassistImposteriser.setConstructorsAccessible(mockedType, false);
        }
    }

    private static boolean toStringMethodIsFinal(Class<?> type) {
        try {
            Method toString = type.getMethod("toString", new Class[0]);
            return Modifier.isFinal(toString.getModifiers());
        }
        catch (SecurityException e) {
            throw new IllegalStateException("not allowed to reflect on toString method", e);
        }
        catch (NoSuchMethodException e) {
            throw new Error("no public toString method found", e);
        }
    }

    private static void setConstructorsAccessible(Class<?> mockedType, boolean accessible) {
        for (Constructor<?> constructor : mockedType.getDeclaredConstructors()) {
            constructor.setAccessible(accessible);
        }
    }

    private Class<?> proxyClass(Class<?> mockedType, Class<?> ... ancilliaryTypes) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setFilter(new MethodFilter(){

            public boolean isHandled(Method m) {
                return !m.getName().equals("finalize") || m.isBridge();
            }
        });
        proxyFactory.setSuperclass(mockedType);
        proxyFactory.setInterfaces((Class[])ancilliaryTypes);
        return proxyFactory.createClass();
    }

    private Object proxy(Class<?> proxyClass, final Invokable mockObject) {
        ProxyObject proxyObject = (ProxyObject)this.objenesis.newInstance(proxyClass);
        proxyObject.setHandler(new MethodHandler(){

            public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
                return mockObject.invoke(new Invocation(self, thisMethod, args));
            }
        });
        return proxyObject;
    }

    private static Class<?>[] combine(Class<?> first, Class<?> ... rest) {
        Class[] all = new Class[rest.length + 1];
        all[0] = first;
        System.arraycopy(rest, 0, all, 1, rest.length);
        return all;
    }
}

