/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.unittestsupport.soap;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.unittestsupport.soap.SoapEndpoint;
import org.apache.isis.core.unittestsupport.soap.SoapEndpointSpec;

class PublishedEndpoints {
    private int port = 54345;
    private Map<Class<?>, SoapEndpoint> soapEndpointByType = Maps.newLinkedHashMap();

    PublishedEndpoints() {
    }

    void publishEndpointIfRequired(List<SoapEndpointSpec> soapEndpointSpecs) {
        for (SoapEndpointSpec soapEndpointSpec : soapEndpointSpecs) {
            Class<?> endpointClass = soapEndpointSpec.getEndpointClass();
            SoapEndpoint soapEndpoint = this.soapEndpointByType.get(endpointClass);
            if (soapEndpoint != null) continue;
            soapEndpoint = new SoapEndpoint(soapEndpointSpec);
            this.soapEndpointByType.put(endpointClass, soapEndpoint);
            this.port = soapEndpoint.publish(this.port);
        }
    }

    String getEndpointAddress(Class<?> endpointClass) {
        return this.soapEndpointByType.get(endpointClass).getSpec().getEndpointAddress();
    }

    <T> T getEndpointImplementor(Class<T> endpointClass) {
        return (T)this.soapEndpointByType.get(endpointClass).getImplementor();
    }
}

