/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.unittestsupport.soap;

import javax.xml.ws.Endpoint;
import org.apache.isis.core.unittestsupport.soap.SoapEndpointSpec;

class SoapEndpoint {
    private final SoapEndpointSpec spec;
    private Object implementor;

    SoapEndpointSpec getSpec() {
        return this.spec;
    }

    SoapEndpoint(SoapEndpointSpec spec) {
        this.spec = spec;
    }

    public Object getImplementor() {
        return this.implementor;
    }

    int publish(int port) {
        if (this.implementor == null) {
            this.implementor = this.getSpec().getEndpointImplementorFactory().get();
            String endpointAddress = this.getSpec().getEndpointAddress();
            if (endpointAddress == null) {
                endpointAddress = String.format("http://localhost:%d/%s", port++, this.getSpec().getEndpointClass().getName().replace(".", "/"));
                this.getSpec().setEndpointAddress(endpointAddress);
            }
            Endpoint.publish((String)endpointAddress, (Object)this.getImplementor());
        }
        return port;
    }
}

