/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.unittestsupport.soap;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.isis.core.unittestsupport.soap.PublishedEndpoints;
import org.apache.isis.core.unittestsupport.soap.SoapEndpointSpec;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SoapEndpointPublishingRule
implements TestRule {
    static final int INITIAL_PORT = 54345;
    private static PublishedEndpoints publishedEndpoints = new PublishedEndpoints();
    private final List<SoapEndpointSpec> soapEndpointSpecs = Lists.newArrayList();

    public SoapEndpointPublishingRule(Class<?> endpointClass, String endpointAddress) {
        this(new SoapEndpointSpec(endpointClass, endpointAddress));
    }

    public SoapEndpointPublishingRule(Class<?> ... endpointClasses) {
        this(Arrays.asList(endpointClasses));
    }

    public SoapEndpointPublishingRule(List<Class<?>> endpointClasses) {
        this(Iterables.transform(endpointClasses, SoapEndpointSpec.asSoapEndpointSpec()));
    }

    public SoapEndpointPublishingRule(SoapEndpointSpec ... soapEndpointSpecs) {
        this((Iterable<SoapEndpointSpec>)Arrays.asList(soapEndpointSpecs));
    }

    public SoapEndpointPublishingRule(Iterable<SoapEndpointSpec> soapEndpointSpecs) {
        Iterables.addAll(this.soapEndpointSpecs, soapEndpointSpecs);
    }

    public Statement apply(Statement base, Description description) {
        publishedEndpoints.publishEndpointIfRequired(this.soapEndpointSpecs);
        return base;
    }

    public String getEndpointAddress(Class<?> endpointClass) {
        return publishedEndpoints.getEndpointAddress(endpointClass);
    }

    public <T> T getEndpointImplementor(Class<T> endpointClass) {
        return publishedEndpoints.getEndpointImplementor(endpointClass);
    }
}

