/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.wrapper.handlers;

import java.util.Collection;
import java.util.List;
import org.apache.isis.core.commons.lang.ObjectExtensions;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.wrapper.handlers.AbstractCollectionInvocationHandler;
import org.apache.isis.core.wrapper.handlers.DomainObjectInvocationHandler;

class CollectionInvocationHandler<T, R>
extends AbstractCollectionInvocationHandler<T, R> {
    public CollectionInvocationHandler(R collectionToProxy, String collectionName, DomainObjectInvocationHandler<T> handler, OneToManyAssociation otma) {
        super(collectionToProxy, collectionName, handler, otma);
        try {
            this.intercept(ObjectExtensions.getMethod(collectionToProxy, (String)"contains", (Class[])new Class[]{Object.class}));
            this.intercept(ObjectExtensions.getMethod(collectionToProxy, (String)"size"));
            this.intercept(ObjectExtensions.getMethod(collectionToProxy, (String)"isEmpty"));
            if (collectionToProxy instanceof List) {
                this.intercept(ObjectExtensions.getMethod(collectionToProxy, (String)"get", (Class[])new Class[]{Integer.TYPE}));
            }
            this.veto(ObjectExtensions.getMethod(collectionToProxy, (String)"add", (Class[])new Class[]{Object.class}));
            this.veto(ObjectExtensions.getMethod(collectionToProxy, (String)"remove", (Class[])new Class[]{Object.class}));
            this.veto(ObjectExtensions.getMethod(collectionToProxy, (String)"addAll", (Class[])new Class[]{Collection.class}));
            this.veto(ObjectExtensions.getMethod(collectionToProxy, (String)"removeAll", (Class[])new Class[]{Collection.class}));
            this.veto(ObjectExtensions.getMethod(collectionToProxy, (String)"retainAll", (Class[])new Class[]{Collection.class}));
            this.veto(ObjectExtensions.getMethod(collectionToProxy, (String)"clear"));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("A Collection method could not be found: " + e.getMessage());
        }
    }
}

