/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.wrapper.handlers;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.events.CollectionAccessEvent;
import org.apache.isis.applib.events.InteractionEvent;
import org.apache.isis.applib.events.ObjectTitleEvent;
import org.apache.isis.applib.events.PropertyAccessEvent;
import org.apache.isis.applib.events.UsabilityEvent;
import org.apache.isis.applib.events.ValidityEvent;
import org.apache.isis.applib.events.VisibilityEvent;
import org.apache.isis.applib.services.wrapper.DisabledException;
import org.apache.isis.applib.services.wrapper.HiddenException;
import org.apache.isis.applib.services.wrapper.InteractionException;
import org.apache.isis.applib.services.wrapper.InvalidException;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.applib.services.wrapper.WrapperObject;
import org.apache.isis.applib.services.wrapper.WrappingObject;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectPersistor;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.interactions.ObjectTitleContext;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.specimpl.ContributeeMember;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionContributee;
import org.apache.isis.core.metamodel.specloader.specimpl.dflt.ObjectSpecificationDefault;
import org.apache.isis.core.wrapper.handlers.DelegatingInvocationHandlerDefault;
import org.apache.isis.core.wrapper.handlers.ProxyContextHandler;
import org.datanucleus.enhancement.Persistable;

public class DomainObjectInvocationHandler<T>
extends DelegatingInvocationHandlerDefault<T> {
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final SpecificationLoader specificationLoader;
    private final AdapterManager adapterManager;
    private final ObjectPersistor objectPersistor;
    private final ProxyContextHandler proxy;
    private final WrapperFactory.ExecutionMode executionMode;
    protected Method titleMethod;
    protected Method __isis_saveMethod;
    @Deprecated
    protected Method saveMethod;
    protected Method __isis_wrappedMethod;
    @Deprecated
    protected Method wrappedMethod;
    protected Method __isis_executionMode;
    protected final Set<String> dnPersistableMethods = Sets.newHashSet();
    private final Where where = Where.ANYWHERE;

    public DomainObjectInvocationHandler(T delegate, WrapperFactory wrapperFactory, WrapperFactory.ExecutionMode mode, AuthenticationSessionProvider authenticationSessionProvider, SpecificationLoader specificationLoader, AdapterManager adapterManager, ObjectPersistor objectPersistor, ProxyContextHandler proxy) {
        super(delegate, wrapperFactory, mode);
        this.proxy = proxy;
        this.authenticationSessionProvider = authenticationSessionProvider;
        this.specificationLoader = specificationLoader;
        this.adapterManager = adapterManager;
        this.objectPersistor = objectPersistor;
        this.executionMode = mode;
        try {
            this.titleMethod = delegate.getClass().getMethod("title", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.__isis_saveMethod = WrapperObject.class.getMethod("__isis_save", new Class[0]);
            this.__isis_wrappedMethod = WrapperObject.class.getMethod("__isis_wrapped", new Class[0]);
            this.__isis_executionMode = WrapperObject.class.getMethod("__isis_executionMode", new Class[0]);
            this.saveMethod = WrapperObject.class.getMethod("save", new Class[0]);
            this.wrappedMethod = WrapperObject.class.getMethod("wrapped", new Class[0]);
            this.dnPersistableMethods.addAll(Lists.newArrayList((Iterable)Iterables.transform(Arrays.asList(Persistable.class.getDeclaredMethods()), (Function)new Function<Method, String>(){

                public String apply(Method input) {
                    return input.getName();
                }
            })));
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException("Could not locate reserved declared methods in the WrappingObject and WrappedObject interfaces", nsme);
        }
    }

    @Override
    public Object invoke(Object proxyObject, Method method, Object[] args) throws Throwable {
        if (this.isObjectMethod(method)) {
            return this.delegate(method, args);
        }
        if (this.isJdoMethod(method)) {
            return this.delegate(method, args);
        }
        if (DomainObjectInvocationHandler.isInjectMethod(method)) {
            return this.delegate(method, args);
        }
        ObjectAdapter targetAdapter = this.adapterFor(this.getDelegate());
        if (this.isTitleMethod(method)) {
            return this.handleTitleMethod(targetAdapter);
        }
        ObjectSpecification targetNoSpec = targetAdapter.getSpecification();
        if (this.isSaveMethod(method)) {
            return this.handleSaveMethod(targetAdapter, targetNoSpec);
        }
        if (this.isWrappedMethod(method)) {
            return this.getDelegate();
        }
        if (this.isExecutionModeMethod(method)) {
            return this.executionMode;
        }
        ObjectMember objectMember = this.locateAndCheckMember(method);
        ContributeeMember contributeeMember = this.determineIfContributed(args, objectMember);
        String memberName = objectMember.getName();
        ImperativeFacet.Intent intent = ImperativeFacet.Util.getIntent((ObjectMember)objectMember, (Method)method);
        if (intent == ImperativeFacet.Intent.CHECK_IF_HIDDEN || intent == ImperativeFacet.Intent.CHECK_IF_DISABLED) {
            throw new UnsupportedOperationException(String.format("Cannot invoke supporting method '%s'", memberName));
        }
        String methodName = method.getName();
        if (intent == ImperativeFacet.Intent.DEFAULTS || intent == ImperativeFacet.Intent.CHOICES_OR_AUTOCOMPLETE) {
            return method.invoke(this.getDelegate(), args);
        }
        if (objectMember.isOneToOneAssociation()) {
            if (intent == ImperativeFacet.Intent.CHECK_IF_VALID || intent == ImperativeFacet.Intent.MODIFY_PROPERTY_SUPPORTING) {
                throw new UnsupportedOperationException(String.format("Cannot invoke supporting method for '%s'; use only property accessor/mutator", memberName));
            }
            OneToOneAssociation otoa = (OneToOneAssociation)objectMember;
            if (intent == ImperativeFacet.Intent.ACCESSOR) {
                return this.handleGetterMethodOnProperty(targetAdapter, args, otoa);
            }
            if (intent == ImperativeFacet.Intent.MODIFY_PROPERTY || intent == ImperativeFacet.Intent.INITIALIZATION) {
                return this.handleSetterMethodOnProperty(targetAdapter, args, otoa);
            }
        }
        if (objectMember.isOneToManyAssociation()) {
            if (intent == ImperativeFacet.Intent.CHECK_IF_VALID) {
                throw new UnsupportedOperationException(String.format("Cannot invoke supporting method '%s'; use only collection accessor/mutator", memberName));
            }
            OneToManyAssociation otma = (OneToManyAssociation)objectMember;
            if (intent == ImperativeFacet.Intent.ACCESSOR) {
                return this.handleGetterMethodOnCollection(targetAdapter, args, otma, method, memberName);
            }
            if (intent == ImperativeFacet.Intent.MODIFY_COLLECTION_ADD) {
                return this.handleCollectionAddToMethod(targetAdapter, args, otma);
            }
            if (intent == ImperativeFacet.Intent.MODIFY_COLLECTION_REMOVE) {
                return this.handleCollectionRemoveFromMethod(targetAdapter, args, otma);
            }
        }
        if (objectMember instanceof ObjectAction) {
            if (intent == ImperativeFacet.Intent.CHECK_IF_VALID) {
                throw new UnsupportedOperationException(String.format("Cannot invoke supporting method '%s'; use only the 'invoke' method", memberName));
            }
            ObjectAction noa = (ObjectAction)objectMember;
            return this.handleActionMethod(targetAdapter, args, noa, contributeeMember);
        }
        throw new UnsupportedOperationException(String.format("Unknown member type '%s'", objectMember));
    }

    private ContributeeMember determineIfContributed(Object[] args, ObjectMember objectMember) {
        if (!(objectMember instanceof ObjectAction)) {
            return null;
        }
        ObjectAction objectAction = (ObjectAction)objectMember;
        for (int i = 0; i < args.length; ++i) {
            ContributeeMember contributeeMember;
            Object arg = args[i];
            if (arg == null) continue;
            ObjectSpecificationDefault objectSpec = this.getJavaSpecification(arg.getClass());
            if (args.length == 1) {
                List associations = objectSpec.getAssociations(Contributed.INCLUDED);
                for (ObjectAssociation association : associations) {
                    if (!(association instanceof ContributeeMember) || !(contributeeMember = (ContributeeMember)association).isContributedBy(objectAction)) continue;
                    return contributeeMember;
                }
            }
            List actions = objectSpec.getObjectActions(Contributed.INCLUDED);
            for (ObjectAction action : actions) {
                if (!(action instanceof ContributeeMember) || !(contributeeMember = (ContributeeMember)action).isContributedBy(objectAction)) continue;
                return contributeeMember;
            }
        }
        return null;
    }

    private boolean isJdoMethod(Method method) {
        return DomainObjectInvocationHandler.methodStartsWith(method, "jdo") || this.dnPersistableMethods.contains(method.getName());
    }

    private static boolean isInjectMethod(Method method) {
        return DomainObjectInvocationHandler.methodStartsWith(method, "inject");
    }

    private static boolean methodStartsWith(Method method, String prefix) {
        return method.getName().startsWith(prefix);
    }

    private Object handleTitleMethod(ObjectAdapter targetAdapter) throws IllegalAccessException, InvocationTargetException {
        this.resolveIfRequired(targetAdapter);
        ObjectSpecification targetNoSpec = targetAdapter.getSpecification();
        ObjectTitleContext titleContext = targetNoSpec.createTitleInteractionContext(this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, targetAdapter);
        ObjectTitleEvent titleEvent = titleContext.createInteractionEvent();
        this.notifyListeners((InteractionEvent)titleEvent);
        return titleEvent.getTitle();
    }

    private Object handleSaveMethod(ObjectAdapter targetAdapter, ObjectSpecification targetNoSpec) {
        if (this.getExecutionMode().shouldEnforceRules()) {
            InteractionResult interactionResult = targetNoSpec.isValidResult(targetAdapter);
            this.notifyListenersAndVetoIfRequired(interactionResult);
        }
        if (this.getExecutionMode().shouldExecute() && targetAdapter.isTransient()) {
            this.getObjectPersistor().makePersistent(targetAdapter);
        }
        return null;
    }

    private Object handleGetterMethodOnProperty(ObjectAdapter targetAdapter, Object[] args, OneToOneAssociation otoa) {
        if (args.length != 0) {
            throw new IllegalArgumentException("Invoking a 'get' should have no arguments");
        }
        if (this.getExecutionMode().shouldEnforceRules()) {
            this.checkVisibility(targetAdapter, (ObjectMember)otoa);
        }
        this.resolveIfRequired(targetAdapter);
        ObjectAdapter currentReferencedAdapter = otoa.get(targetAdapter);
        Object currentReferencedObj = ObjectAdapter.Util.unwrap((ObjectAdapter)currentReferencedAdapter);
        PropertyAccessEvent ev = new PropertyAccessEvent(this.getDelegate(), otoa.getIdentifier(), currentReferencedObj);
        this.notifyListeners((InteractionEvent)ev);
        return currentReferencedObj;
    }

    private Object handleSetterMethodOnProperty(ObjectAdapter targetAdapter, Object[] args, OneToOneAssociation otoa) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Invoking a setter should only have a single argument");
        }
        Object argumentObj = this.underlying(args[0]);
        if (this.getExecutionMode().shouldEnforceRules()) {
            this.checkVisibility(targetAdapter, (ObjectMember)otoa);
            this.checkUsability(targetAdapter, (ObjectMember)otoa);
        }
        ObjectAdapter argumentAdapter = argumentObj != null ? this.adapterFor(argumentObj) : null;
        this.resolveIfRequired(targetAdapter);
        if (this.getExecutionMode().shouldEnforceRules()) {
            InteractionResult interactionResult = otoa.isAssociationValid(targetAdapter, argumentAdapter).getInteractionResult();
            this.notifyListenersAndVetoIfRequired(interactionResult);
        }
        if (this.getExecutionMode().shouldExecute()) {
            otoa.set(targetAdapter, argumentAdapter);
        }
        this.objectChangedIfRequired(targetAdapter);
        return null;
    }

    private Object handleGetterMethodOnCollection(ObjectAdapter targetAdapter, Object[] args, OneToManyAssociation otma, Method method, String memberName) {
        if (args.length != 0) {
            throw new IllegalArgumentException("Invoking a 'get' should have no arguments");
        }
        if (this.getExecutionMode().shouldEnforceRules()) {
            this.checkVisibility(targetAdapter, (ObjectMember)otma);
        }
        this.resolveIfRequired(targetAdapter);
        ObjectAdapter currentReferencedAdapter = otma.get(targetAdapter);
        Object currentReferencedObj = ObjectAdapter.Util.unwrap((ObjectAdapter)currentReferencedAdapter);
        CollectionAccessEvent ev = new CollectionAccessEvent(this.getDelegate(), otma.getIdentifier());
        if (currentReferencedObj instanceof Collection) {
            Collection<?> collectionViewObject = this.lookupViewObject(method, memberName, (Collection)currentReferencedObj, otma);
            this.notifyListeners((InteractionEvent)ev);
            return collectionViewObject;
        }
        if (currentReferencedObj instanceof Map) {
            Map<?, ?> mapViewObject = this.lookupViewObject(method, memberName, (Map)currentReferencedObj, otma);
            this.notifyListeners((InteractionEvent)ev);
            return mapViewObject;
        }
        throw new IllegalArgumentException(String.format("Collection type '%s' not supported by framework", currentReferencedObj.getClass().getName()));
    }

    private Collection<?> lookupViewObject(Method method, String memberName, Collection<?> collectionToLookup, OneToManyAssociation otma) {
        return collectionToLookup instanceof WrapperObject ? collectionToLookup : this.proxy.proxy(collectionToLookup, memberName, this, otma);
    }

    private Map<?, ?> lookupViewObject(Method method, String memberName, Map<?, ?> mapToLookup, OneToManyAssociation otma) {
        return mapToLookup instanceof WrapperObject ? mapToLookup : this.proxy.proxy(mapToLookup, memberName, this, otma);
    }

    private Object handleCollectionAddToMethod(ObjectAdapter targetAdapter, Object[] args, OneToManyAssociation otma) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Invoking a addTo should only have a single argument");
        }
        if (this.getExecutionMode().shouldEnforceRules()) {
            this.checkVisibility(targetAdapter, (ObjectMember)otma);
            this.checkUsability(targetAdapter, (ObjectMember)otma);
        }
        this.resolveIfRequired(targetAdapter);
        Object argumentObj = this.underlying(args[0]);
        if (argumentObj == null) {
            throw new IllegalArgumentException("Must provide a non-null object to add");
        }
        ObjectAdapter argumentNO = this.adapterFor(argumentObj);
        if (this.getExecutionMode().shouldEnforceRules()) {
            InteractionResult interactionResult = otma.isValidToAdd(targetAdapter, argumentNO).getInteractionResult();
            this.notifyListenersAndVetoIfRequired(interactionResult);
        }
        if (this.getExecutionMode().shouldExecute()) {
            otma.addElement(targetAdapter, argumentNO);
        }
        this.objectChangedIfRequired(targetAdapter);
        return null;
    }

    private Object handleCollectionRemoveFromMethod(ObjectAdapter targetAdapter, Object[] args, OneToManyAssociation otma) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Invoking a removeFrom should only have a single argument");
        }
        if (this.getExecutionMode().shouldEnforceRules()) {
            this.checkVisibility(targetAdapter, (ObjectMember)otma);
            this.checkUsability(targetAdapter, (ObjectMember)otma);
        }
        this.resolveIfRequired(targetAdapter);
        Object argumentObj = this.underlying(args[0]);
        if (argumentObj == null) {
            throw new IllegalArgumentException("Must provide a non-null object to remove");
        }
        ObjectAdapter argumentAdapter = this.adapterFor(argumentObj);
        if (this.getExecutionMode().shouldEnforceRules()) {
            InteractionResult interactionResult = otma.isValidToRemove(targetAdapter, argumentAdapter).getInteractionResult();
            this.notifyListenersAndVetoIfRequired(interactionResult);
        }
        if (this.getExecutionMode().shouldExecute()) {
            otma.removeElement(targetAdapter, argumentAdapter);
        }
        this.objectChangedIfRequired(targetAdapter);
        return null;
    }

    private Object handleActionMethod(ObjectAdapter targetAdapter, Object[] args, ObjectAction objectAction, ContributeeMember contributeeMember) {
        Object[] contributeeArgs;
        ObjectAdapter contributeeAdapter;
        if (contributeeMember != null) {
            int contributeeParamPosition = contributeeMember.getContributeeParamPosition();
            Object contributee = args[contributeeParamPosition];
            contributeeAdapter = this.adapterFor(contributee);
            ArrayList argCopy = Lists.newArrayList((Object[])args);
            argCopy.remove(contributeeParamPosition);
            contributeeArgs = argCopy.toArray();
        } else {
            contributeeAdapter = null;
            contributeeArgs = null;
        }
        if (this.getExecutionMode().shouldEnforceRules()) {
            if (contributeeMember != null) {
                this.checkVisibility(contributeeAdapter, (ObjectMember)contributeeMember);
                this.checkUsability(contributeeAdapter, (ObjectMember)contributeeMember);
            } else {
                this.checkVisibility(targetAdapter, (ObjectMember)objectAction);
                this.checkUsability(targetAdapter, (ObjectMember)objectAction);
            }
        }
        ObjectAdapter[] argAdapters = this.asObjectAdaptersUnderlying(args);
        if (this.getExecutionMode().shouldEnforceRules()) {
            if (contributeeMember != null) {
                if (contributeeMember instanceof ObjectActionContributee) {
                    ObjectActionContributee objectActionContributee = (ObjectActionContributee)contributeeMember;
                    ObjectAdapter[] contributeeArgAdapters = this.asObjectAdaptersUnderlying(contributeeArgs);
                    this.checkValidity(contributeeAdapter, (ObjectAction)objectActionContributee, contributeeArgAdapters);
                }
            } else {
                this.checkValidity(targetAdapter, objectAction, argAdapters);
            }
        }
        if (this.getExecutionMode().shouldExecute()) {
            ObjectAdapter actionReturnNO = objectAction.execute(targetAdapter, argAdapters);
            return ObjectAdapter.Util.unwrap((ObjectAdapter)actionReturnNO);
        }
        this.objectChangedIfRequired(targetAdapter);
        return null;
    }

    private void checkValidity(ObjectAdapter targetAdapter, ObjectAction objectAction, ObjectAdapter[] argAdapters) {
        InteractionResult interactionResult = objectAction.isProposedArgumentSetValid(targetAdapter, argAdapters).getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
    }

    private ObjectAdapter[] asObjectAdaptersUnderlying(Object[] args) {
        ObjectAdapter[] argAdapters = new ObjectAdapter[args.length];
        int i = 0;
        for (Object arg : args) {
            argAdapters[i++] = this.adapterFor(this.underlying(arg));
        }
        return argAdapters;
    }

    private ObjectAdapter adapterFor(Object obj) {
        return obj != null ? this.getAdapterManager().adapterFor(obj) : null;
    }

    private Object underlying(Object arg) {
        if (arg instanceof WrappingObject) {
            WrappingObject argViewObject = (WrappingObject)arg;
            return argViewObject.__isis_wrapped();
        }
        return arg;
    }

    private void checkVisibility(ObjectAdapter targetObjectAdapter, ObjectMember objectMember) {
        Consent visibleConsent = objectMember.isVisible(this.getAuthenticationSession(), targetObjectAdapter, this.where);
        InteractionResult interactionResult = visibleConsent.getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
    }

    private void checkUsability(ObjectAdapter targetObjectAdapter, ObjectMember objectMember) {
        InteractionResult interactionResult = objectMember.isUsable(this.getAuthenticationSession(), targetObjectAdapter, this.where).getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
    }

    private void notifyListenersAndVetoIfRequired(InteractionResult interactionResult) {
        InteractionEvent interactionEvent = interactionResult.getInteractionEvent();
        this.notifyListeners(interactionEvent);
        if (interactionEvent.isVeto()) {
            throw this.toException(interactionEvent);
        }
    }

    private String decode(ObjectMember objectMember) {
        if (objectMember instanceof OneToOneAssociation) {
            return "a property";
        }
        if (objectMember instanceof OneToManyAssociation) {
            return "a collection";
        }
        if (objectMember instanceof ObjectAction) {
            return "an action";
        }
        return "an UNKNOWN member type";
    }

    private InteractionException toException(InteractionEvent interactionEvent) {
        if (!interactionEvent.isVeto()) {
            throw new IllegalArgumentException("Provided interactionEvent must be a veto");
        }
        if (interactionEvent instanceof ValidityEvent) {
            ValidityEvent validityEvent = (ValidityEvent)interactionEvent;
            return new InvalidException((InteractionEvent)validityEvent);
        }
        if (interactionEvent instanceof VisibilityEvent) {
            VisibilityEvent visibilityEvent = (VisibilityEvent)interactionEvent;
            return new HiddenException((InteractionEvent)visibilityEvent);
        }
        if (interactionEvent instanceof UsabilityEvent) {
            UsabilityEvent usabilityEvent = (UsabilityEvent)interactionEvent;
            return new DisabledException((InteractionEvent)usabilityEvent);
        }
        throw new IllegalArgumentException("Provided interactionEvent must be a VisibilityEvent, UsabilityEvent or a ValidityEvent");
    }

    private ObjectMember locateAndCheckMember(Method method) {
        ObjectSpecificationDefault objectSpecificationDefault = this.getJavaSpecificationOfOwningClass(method);
        ObjectMember member = objectSpecificationDefault.getMember(method);
        if (member == null) {
            String methodName = method.getName();
            throw new UnsupportedOperationException("Method '" + methodName + "' being invoked does not correspond to any of the object's fields or actions.");
        }
        return member;
    }

    protected boolean isTitleMethod(Method method) {
        return method.equals(this.titleMethod);
    }

    protected boolean isSaveMethod(Method method) {
        return method.equals(this.saveMethod) || method.equals(this.__isis_saveMethod);
    }

    protected boolean isWrappedMethod(Method method) {
        return method.equals(this.wrappedMethod) || method.equals(this.__isis_wrappedMethod);
    }

    protected boolean isExecutionModeMethod(Method method) {
        return method.equals(this.__isis_executionMode);
    }

    private ObjectSpecificationDefault getJavaSpecificationOfOwningClass(Method method) {
        return this.getJavaSpecification(method.getDeclaringClass());
    }

    private ObjectSpecificationDefault getJavaSpecification(Class<?> clazz) {
        ObjectSpecification nos = this.getSpecification(clazz);
        if (!(nos instanceof ObjectSpecificationDefault)) {
            throw new UnsupportedOperationException("Only Java is supported (specification is '" + nos.getClass().getCanonicalName() + "')");
        }
        return (ObjectSpecificationDefault)nos;
    }

    private ObjectSpecification getSpecification(Class<?> type) {
        ObjectSpecification nos = this.getSpecificationLoader().loadSpecification(type);
        return nos;
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    public AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.getAuthenticationSessionProvider().getAuthenticationSession();
    }

    protected AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    protected ObjectPersistor getObjectPersistor() {
        return this.objectPersistor;
    }
}

