/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.wrapper.handlers;

import java.util.Collection;
import java.util.Map;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.adapter.ObjectPersistor;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.wrapper.handlers.CollectionInvocationHandler;
import org.apache.isis.core.wrapper.handlers.DomainObjectInvocationHandler;
import org.apache.isis.core.wrapper.handlers.MapInvocationHandler;
import org.apache.isis.core.wrapper.proxy.ProxyInstantiator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class ProxyContextHandler {
    private final ProxyInstantiator proxyInstantiator;

    public ProxyContextHandler(ProxyInstantiator proxyInstantiator) {
        this.proxyInstantiator = proxyInstantiator;
    }

    public <T> T proxy(T domainObject, WrapperFactory wrapperFactory, WrapperFactory.ExecutionMode mode, AuthenticationSessionProvider authenticationSessionProvider, SpecificationLoader specificationLookup, AdapterManager adapterManager, ObjectPersistor objectPersistor) {
        Ensure.ensureThatArg((Object)wrapperFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)authenticationSessionProvider, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)specificationLookup, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)adapterManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)objectPersistor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        DomainObjectInvocationHandler<T> invocationHandler = new DomainObjectInvocationHandler<T>(domainObject, wrapperFactory, mode, authenticationSessionProvider, specificationLookup, adapterManager, objectPersistor, this);
        return this.proxyInstantiator.instantiateProxy(invocationHandler);
    }

    public <T, E> Collection<E> proxy(Collection<E> collectionToProxy, String collectionName, DomainObjectInvocationHandler<T> handler, OneToManyAssociation otma) {
        CollectionInvocationHandler<T, Collection<E>> collectionInvocationHandler = new CollectionInvocationHandler<T, Collection<E>>(collectionToProxy, collectionName, handler, otma);
        collectionInvocationHandler.setResolveObjectChangedEnabled(handler.isResolveObjectChangedEnabled());
        return (Collection)this.proxyInstantiator.instantiateProxy(collectionInvocationHandler);
    }

    public <T, P, Q> Map<P, Q> proxy(Map<P, Q> collectionToProxy, String collectionName, DomainObjectInvocationHandler<T> handler, OneToManyAssociation otma) {
        MapInvocationHandler<T, Map<P, Q>> mapInvocationHandler = new MapInvocationHandler<T, Map<P, Q>>(collectionToProxy, collectionName, handler, otma);
        mapInvocationHandler.setResolveObjectChangedEnabled(handler.isResolveObjectChangedEnabled());
        return (Map)this.proxyInstantiator.instantiateProxy(mapInvocationHandler);
    }
}

