/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.textline;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.mina.common.BufferDataException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.textline.LineDelimiter;

public class TextLineDecoder
implements ProtocolDecoder {
    private static final String CONTEXT = TextLineDecoder.class.getName() + ".context";
    private final Charset charset;
    private final LineDelimiter delimiter;
    private ByteBuffer delimBuf;
    private int maxLineLength = 1024;

    public TextLineDecoder() {
        this(Charset.defaultCharset(), LineDelimiter.AUTO);
    }

    public TextLineDecoder(Charset charset) {
        this(charset, LineDelimiter.AUTO);
    }

    public TextLineDecoder(Charset charset, LineDelimiter delimiter) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter");
        }
        this.charset = charset;
        this.delimiter = delimiter;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        if (maxLineLength <= 0) {
            throw new IllegalArgumentException("maxLineLength: " + maxLineLength);
        }
        this.maxLineLength = maxLineLength;
    }

    public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        Context ctx = this.getContext(session);
        if (LineDelimiter.AUTO.equals(this.delimiter)) {
            this.decodeAuto(ctx, in, out);
        } else {
            this.decodeNormal(ctx, in, out);
        }
    }

    private Context getContext(IoSession session) {
        Context ctx = (Context)session.getAttribute(CONTEXT);
        if (ctx == null) {
            ctx = new Context();
            session.setAttribute(CONTEXT, ctx);
        }
        return ctx;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }

    public void dispose(IoSession session) throws Exception {
        Context ctx = (Context)session.getAttribute(CONTEXT);
        if (ctx != null) {
            ctx.getBuffer().release();
            session.removeAttribute(CONTEXT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeAuto(Context ctx, ByteBuffer in, ProtocolDecoderOutput out) throws CharacterCodingException {
        int matchCount = ctx.getMatchCount();
        int oldPos = in.position();
        int oldLimit = in.limit();
        while (in.hasRemaining()) {
            byte b = in.get();
            boolean matched = false;
            switch (b) {
                case 13: {
                    ++matchCount;
                    break;
                }
                case 10: {
                    ++matchCount;
                    matched = true;
                    break;
                }
                default: {
                    matchCount = 0;
                }
            }
            if (!matched) continue;
            int pos = in.position();
            in.limit(pos);
            in.position(oldPos);
            ctx.append(in);
            in.limit(oldLimit);
            in.position(pos);
            if (ctx.getOverflowPosition() == 0) {
                ByteBuffer buf = ctx.getBuffer();
                buf.flip();
                buf.limit(buf.limit() - matchCount);
                try {
                    out.write(buf.getString(ctx.getDecoder()));
                }
                finally {
                    buf.clear();
                }
            } else {
                int overflowPosition = ctx.getOverflowPosition();
                ctx.reset();
                throw new BufferDataException("Line is too long: " + overflowPosition);
            }
            oldPos = pos;
            matchCount = 0;
        }
        in.position(oldPos);
        ctx.append(in);
        ctx.setMatchCount(matchCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeNormal(Context ctx, ByteBuffer in, ProtocolDecoderOutput out) throws CharacterCodingException {
        int matchCount = ctx.getMatchCount();
        if (this.delimBuf == null) {
            ByteBuffer tmp = ByteBuffer.allocate(2).setAutoExpand(true);
            tmp.putString(this.delimiter.getValue(), this.charset.newEncoder());
            tmp.flip();
            this.delimBuf = tmp;
        }
        int oldPos = in.position();
        int oldLimit = in.limit();
        while (in.hasRemaining()) {
            byte b = in.get();
            if (this.delimBuf.get(matchCount) == b) {
                if (++matchCount != this.delimBuf.limit()) continue;
                int pos = in.position();
                in.limit(pos);
                in.position(oldPos);
                ctx.append(in);
                in.limit(oldLimit);
                in.position(pos);
                if (ctx.getOverflowPosition() == 0) {
                    ByteBuffer buf = ctx.getBuffer();
                    buf.flip();
                    buf.limit(buf.limit() - matchCount);
                    try {
                        out.write(buf.getString(ctx.getDecoder()));
                    }
                    finally {
                        buf.clear();
                    }
                } else {
                    int overflowPosition = ctx.getOverflowPosition();
                    ctx.reset();
                    throw new BufferDataException("Line is too long: " + overflowPosition);
                }
                oldPos = pos;
                matchCount = 0;
                continue;
            }
            in.position(Math.max(0, in.position() - matchCount));
            matchCount = 0;
        }
        in.position(oldPos);
        ctx.append(in);
        ctx.setMatchCount(matchCount);
    }

    private class Context {
        private final CharsetDecoder decoder;
        private final ByteBuffer buf;
        private int matchCount = 0;
        private int overflowPosition = 0;

        private Context() {
            this.decoder = TextLineDecoder.this.charset.newDecoder();
            this.buf = ByteBuffer.allocate(80).setAutoExpand(true);
        }

        public CharsetDecoder getDecoder() {
            return this.decoder;
        }

        public ByteBuffer getBuffer() {
            return this.buf;
        }

        public int getOverflowPosition() {
            return this.overflowPosition;
        }

        public int getMatchCount() {
            return this.matchCount;
        }

        public void setMatchCount(int matchCount) {
            this.matchCount = matchCount;
        }

        public void reset() {
            this.overflowPosition = 0;
            this.matchCount = 0;
            this.decoder.reset();
        }

        public void append(ByteBuffer in) {
            if (this.overflowPosition != 0) {
                this.discard(in);
            } else if (this.buf.position() > TextLineDecoder.this.maxLineLength - in.remaining()) {
                this.overflowPosition = this.buf.position();
                this.buf.clear();
                this.discard(in);
            } else {
                this.getBuffer().put(in);
            }
        }

        private void discard(ByteBuffer in) {
            this.overflowPosition = Integer.MAX_VALUE - in.remaining() < this.overflowPosition ? Integer.MAX_VALUE : (this.overflowPosition += in.remaining());
            in.position(in.limit());
        }
    }
}

