/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.referencing;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.PropertyType;
import org.apache.sis.internal.jaxb.referencing.CC_GeneralOperationParameter;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public final class CC_OperationMethod
extends PropertyType<CC_OperationMethod, OperationMethod> {
    public CC_OperationMethod() {
    }

    protected Class<OperationMethod> getBoundType() {
        return OperationMethod.class;
    }

    private CC_OperationMethod(OperationMethod operationMethod) {
        super((Object)operationMethod);
    }

    protected CC_OperationMethod wrap(OperationMethod operationMethod) {
        return new CC_OperationMethod(operationMethod);
    }

    @XmlElement(name="OperationMethod")
    public DefaultOperationMethod getElement() {
        return DefaultOperationMethod.castOrCopy((OperationMethod)this.metadata);
    }

    public void setElement(DefaultOperationMethod defaultOperationMethod) {
        if (!CC_GeneralOperationParameter.isValid((GeneralParameterDescriptor)defaultOperationMethod.getParameters())) {
            throw new IllegalArgumentException(Errors.format((short)64, (Object)"parameters"));
        }
        this.metadata = defaultOperationMethod;
    }

    public static GeneralParameterValue[] filterImplicit(GeneralParameterValue[] generalParameterValueArray) {
        int n = 0;
        for (GeneralParameterValue generalParameterValue : generalParameterValueArray) {
            if (CC_OperationMethod.isImplicitParameter(generalParameterValue.getDescriptor())) continue;
            generalParameterValueArray[n++] = generalParameterValue;
        }
        return (GeneralParameterValue[])ArraysExt.resize((Object[])generalParameterValueArray, (int)n);
    }

    public static GeneralParameterDescriptor[] filterImplicit(GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        int n = 0;
        for (GeneralParameterDescriptor generalParameterDescriptor : generalParameterDescriptorArray) {
            if (CC_OperationMethod.isImplicitParameter(generalParameterDescriptor)) continue;
            generalParameterDescriptorArray[n++] = generalParameterDescriptor;
        }
        return (GeneralParameterDescriptor[])ArraysExt.resize((Object[])generalParameterDescriptorArray, (int)n);
    }

    static boolean isImplicitParameter(GeneralParameterDescriptor generalParameterDescriptor) {
        return generalParameterDescriptor == MapProjection.SEMI_MAJOR || generalParameterDescriptor == MapProjection.SEMI_MINOR;
    }

    public static ParameterDescriptorGroup group(Identifier identifier, GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = (DefaultCoordinateOperationFactory)((Object)DefaultFactories.forBuildin(CoordinateOperationFactory.class, DefaultCoordinateOperationFactory.class));
        OperationMethod operationMethod = null;
        if (defaultCoordinateOperationFactory != null) {
            try {
                operationMethod = defaultCoordinateOperationFactory.getOperationMethod(identifier.getCode());
            }
            catch (FactoryException factoryException) {
                Context.warningOccured((Context)Context.current(), DefaultOperationMethod.class, (String)"setDescriptors", (Exception)((Object)factoryException), (boolean)true);
            }
        }
        Map<String, Identifier> map = Collections.singletonMap("name", identifier);
        if (operationMethod != null) {
            ParameterDescriptorGroup parameterDescriptorGroup = operationMethod.getParameters();
            return CC_GeneralOperationParameter.merge(DefaultOperationMethod.class, map, IdentifiedObjects.getProperties((IdentifiedObject)parameterDescriptorGroup, new String[0]), 1, 1, generalParameterDescriptorArray, parameterDescriptorGroup, true);
        }
        return new DefaultParameterDescriptorGroup(map, 1, 1, generalParameterDescriptorArray);
    }

    public static void store(GeneralParameterValue[] generalParameterValueArray, Collection<GeneralParameterValue> collection, Map<GeneralParameterDescriptor, GeneralParameterDescriptor> map) {
        for (Object object : generalParameterValueArray) {
            GeneralParameterDescriptor generalParameterDescriptor = map.get(object.getDescriptor());
            if (generalParameterDescriptor != null) {
                Object object2;
                Cloneable cloneable;
                ParameterValue parameterValue;
                if (object instanceof ParameterValue) {
                    parameterValue = (ParameterValue)object;
                    cloneable = new DefaultParameterValue((ParameterDescriptor)generalParameterDescriptor);
                    object2 = parameterValue.getValue();
                    Unit unit = parameterValue.getUnit();
                    if (unit == null) {
                        cloneable.setValue(object2);
                    } else if (object2 instanceof double[]) {
                        cloneable.setValue((double[])object2, unit);
                    } else {
                        cloneable.setValue(((Number)object2).doubleValue(), unit);
                    }
                    object = cloneable;
                } else if (object instanceof ParameterValueGroup) {
                    parameterValue = (ParameterValueGroup)object;
                    cloneable = new DefaultParameterValueGroup((ParameterDescriptorGroup)generalParameterDescriptor);
                    object2 = parameterValue.values();
                    CC_OperationMethod.store(object2.toArray(new GeneralParameterValue[object2.size()]), cloneable.values(), map);
                    object = cloneable;
                }
            }
            collection.add((GeneralParameterValue)object);
        }
    }
}

