/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import org.apache.sis.internal.referencing.provider.AbstractLambert;
import org.apache.sis.internal.referencing.provider.LambertConformal1SP;
import org.apache.sis.internal.referencing.provider.Mercator2SP;
import org.apache.sis.internal.referencing.provider.RegionalMercator;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;

public final class LambertConformal2SP
extends AbstractLambert {
    private static final long serialVersionUID = 3240860802816724947L;
    public static final String IDENTIFIER = "9802";
    public static final ParameterDescriptor<Double> LATITUDE_OF_FALSE_ORIGIN;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_FALSE_ORIGIN;
    public static final ParameterDescriptor<Double> STANDARD_PARALLEL_1;
    public static final ParameterDescriptor<Double> STANDARD_PARALLEL_2;
    public static final ParameterDescriptor<Double> EASTING_AT_FALSE_ORIGIN;
    public static final ParameterDescriptor<Double> NORTHING_AT_FALSE_ORIGIN;
    static final ParameterDescriptorGroup PARAMETERS;

    public LambertConformal2SP() {
        super(PARAMETERS);
    }

    static {
        EASTING_AT_FALSE_ORIGIN = RegionalMercator.EASTING_AT_FALSE_ORIGIN;
        NORTHING_AT_FALSE_ORIGIN = RegionalMercator.NORTHING_AT_FALSE_ORIGIN;
        ParameterBuilder parameterBuilder = LambertConformal2SP.builder();
        LATITUDE_OF_FALSE_ORIGIN = LambertConformal2SP.createLatitude((ParameterBuilder)parameterBuilder.addNamesAndIdentifiers((IdentifiedObject)RegionalMercator.LATITUDE_OF_FALSE_ORIGIN), true);
        LONGITUDE_OF_FALSE_ORIGIN = LambertConformal2SP.createLongitude((ParameterBuilder)((ParameterBuilder)LambertConformal2SP.exceptEPSG(LambertConformal1SP.LONGITUDE_OF_ORIGIN, (ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8822")).addName("Longitude of false origin")).rename((Citation)Citations.NETCDF, "longitude_of_central_meridian")).rename((Citation)Citations.GEOTIFF, "FalseOriginLong"));
        STANDARD_PARALLEL_1 = LambertConformal2SP.createMandatoryLatitude((ParameterBuilder)parameterBuilder.addNamesAndIdentifiers((IdentifiedObject)Mercator2SP.STANDARD_PARALLEL));
        STANDARD_PARALLEL_2 = LambertConformal2SP.createMandatoryLatitude((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8824")).addName("Latitude of 2nd standard parallel")).addName((Citation)Citations.OGC, "standard_parallel_2")).addName((Citation)Citations.ESRI, "Standard_Parallel_2")).addName((Citation)Citations.GEOTIFF, "StdParallel2")).addName((Citation)Citations.PROJ4, "lat_2"));
        ParameterDescriptor<Double> parameterDescriptor = LambertConformal2SP.createScale((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addNamesAndIdentifiers((IdentifiedObject)Mercator2SP.SCALE_FACTOR)).setRemarks((CharSequence)LambertConformal2SP.notFormalParameter("Lambert Conic Conformal (1SP)"))).setRequired(false).setDeprecated(true));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier(IDENTIFIER)).addName("Lambert Conic Conformal (2SP)")).addName((Citation)Citations.OGC, "Lambert_Conformal_Conic_2SP")).addName((Citation)Citations.ESRI, "Lambert_Conformal_Conic")).addName((Citation)Citations.NETCDF, "LambertConformal")).addName((Citation)Citations.GEOTIFF, "CT_LambertConfConic_2SP")).addName((Citation)Citations.GEOTIFF, "CT_LambertConfConic")).addName((Citation)Citations.PROJ4, "lcc")).addIdentifier((Citation)Citations.GEOTIFF, "8")).addIdentifier((Citation)Citations.MAP_INFO, "3")).addIdentifier((Citation)Citations.S57, "6")).createGroupForMapProjection(LATITUDE_OF_FALSE_ORIGIN, LONGITUDE_OF_FALSE_ORIGIN, STANDARD_PARALLEL_1, STANDARD_PARALLEL_2, parameterDescriptor, EASTING_AT_FALSE_ORIGIN, NORTHING_AT_FALSE_ORIGIN);
    }
}

