/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Transformation;

public final class LongitudeRotation
extends AbstractProvider {
    private static final long serialVersionUID = -2104496465933824935L;
    static final String NAME = "Longitude offset";
    private static final ParameterDescriptor<Double> OFFSET;
    private static final ParameterDescriptorGroup PARAMETERS;

    public LongitudeRotation() {
        super(2, 2, PARAMETERS);
    }

    public Class<Transformation> getOperationType() {
        return Transformation.class;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        double d = Parameters.castOrWrap(parameterValueGroup).doubleValue(OFFSET);
        return new AffineTransform2D(1.0, 0.0, 0.0, 1.0, d, 0.0);
    }

    static {
        ParameterBuilder parameterBuilder = LongitudeRotation.builder();
        OFFSET = LongitudeRotation.createLongitude((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8602")).addName(NAME));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("9601")).addName("Longitude rotation")).createGroup(new GeneralParameterDescriptor[]{OFFSET});
    }
}

