/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.PropertyType;
import org.apache.sis.internal.jaxb.referencing.CC_OperationParameter;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.AbstractParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;

@XmlType(name="OperationParameterType")
@XmlRootElement(name="OperationParameter")
public class DefaultParameterDescriptor<T>
extends AbstractParameterDescriptor
implements ParameterDescriptor<T> {
    private static final long serialVersionUID = -1978932430298071693L;
    private final Class<T> valueClass;
    private final Set<T> validValues;
    private final Range<?> valueDomain;
    private final T defaultValue;

    public DefaultParameterDescriptor(Map<String, ?> map, int n, int n2, Class<T> clazz, Range<?> range, T[] TArray, T t) {
        super(map, n, n2);
        Class<Object> clazz2;
        ArgumentChecks.ensureNonNull((String)"valueClass", clazz);
        ArgumentChecks.ensureCanCast((String)"defaultValue", clazz, t);
        if (range != null) {
            clazz2 = clazz.getComponentType();
            clazz2 = clazz2 != null ? Numbers.primitiveToWrapper(clazz2) : clazz;
            T[] TArray2 = range.getElementType();
            if (TArray2 != clazz2) {
                throw new IllegalArgumentException(Errors.getResources(map).getString((short)28, (Object)"valueDomain", (Object)("Range<" + Classes.getShortName(TArray2) + '>')));
            }
            if (range.isEmpty()) {
                throw new IllegalArgumentException(Errors.getResources(map).getString((short)41, (Object)range.getMinValue(), (Object)range.getMaxValue()));
            }
        }
        this.valueClass = clazz;
        this.valueDomain = range;
        this.defaultValue = Numerics.cached(t);
        if (TArray != null) {
            clazz2 = CollectionsExt.createSetForType(clazz, (int)TArray.length);
            for (Object object : TArray) {
                if (object == null) continue;
                Verifier verifier = Verifier.ensureValidValue(clazz, null, range, object = Numerics.cached(object));
                if (verifier != null) {
                    throw new IllegalArgumentException(verifier.message(map, super.getName().getCode(), object));
                }
                clazz2.add(object);
            }
            this.validValues = CollectionsExt.unmodifiableOrCopy((Set)((Object)clazz2));
        } else {
            this.validValues = null;
        }
        if (t != null && (clazz2 = Verifier.ensureValidValue(clazz, this.validValues, range, t)) != null) {
            throw new IllegalArgumentException(((Verifier)((Object)clazz2)).message(map, super.getName().getCode(), t));
        }
    }

    protected DefaultParameterDescriptor(ParameterDescriptor<T> parameterDescriptor) {
        super((GeneralParameterDescriptor)parameterDescriptor);
        this.valueClass = parameterDescriptor.getValueClass();
        this.validValues = parameterDescriptor.getValidValues();
        this.defaultValue = parameterDescriptor.getDefaultValue();
        this.valueDomain = Parameters.getValueDomain(parameterDescriptor);
    }

    public static <T> DefaultParameterDescriptor<T> castOrCopy(ParameterDescriptor<T> parameterDescriptor) {
        return parameterDescriptor == null || parameterDescriptor instanceof DefaultParameterDescriptor ? (DefaultParameterDescriptor<T>)parameterDescriptor : new DefaultParameterDescriptor<T>(parameterDescriptor);
    }

    public Class<? extends ParameterDescriptor<T>> getInterface() {
        return ParameterDescriptor.class;
    }

    public final Class<T> getValueClass() {
        return this.valueClass;
    }

    public Set<T> getValidValues() {
        return this.validValues;
    }

    public final Range<?> getValueDomain() {
        return this.valueDomain;
    }

    public Comparable<T> getMinimumValue() {
        return this.valueDomain != null && this.valueDomain.getElementType() == this.valueClass ? this.valueDomain.getMinValue() : null;
    }

    public Comparable<T> getMaximumValue() {
        return this.valueDomain != null && this.valueDomain.getElementType() == this.valueClass ? this.valueDomain.getMaxValue() : null;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Unit<?> getUnit() {
        return this.valueDomain instanceof MeasurementRange ? ((MeasurementRange)this.valueDomain).unit() : null;
    }

    public ParameterValue<T> createValue() {
        return new DefaultParameterValue(this);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                default: {
                    ParameterDescriptor parameterDescriptor = (ParameterDescriptor)object;
                    return this.getValueClass() == parameterDescriptor.getValueClass() && Objects.deepEquals(this.getDefaultValue(), (Object)parameterDescriptor.getDefaultValue()) && Objects.equals(this.getUnit(), (Object)parameterDescriptor.getUnit()) && (this.isHeuristicMatchForName(parameterDescriptor.getName().getCode()) || IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)parameterDescriptor, this.getName().getCode()));
                }
                case BY_CONTRACT: {
                    ParameterDescriptor parameterDescriptor = (ParameterDescriptor)object;
                    return this.getMinimumOccurs() == parameterDescriptor.getMinimumOccurs() && this.getMaximumOccurs() == parameterDescriptor.getMaximumOccurs() && this.getValueClass() == parameterDescriptor.getValueClass() && Objects.equals(this.getValidValues(), (Object)parameterDescriptor.getValidValues()) && Objects.equals(this.getMinimumValue(), (Object)parameterDescriptor.getMinimumValue()) && Objects.equals(this.getMaximumValue(), (Object)parameterDescriptor.getMaximumValue()) && Objects.deepEquals(this.getDefaultValue(), (Object)parameterDescriptor.getDefaultValue()) && Objects.equals(this.getUnit(), (Object)parameterDescriptor.getUnit());
                }
                case STRICT: 
            }
            DefaultParameterDescriptor defaultParameterDescriptor = (DefaultParameterDescriptor)object;
            return this.valueClass == defaultParameterDescriptor.valueClass && Objects.equals(this.validValues, defaultParameterDescriptor.validValues) && Objects.equals(this.valueDomain, defaultParameterDescriptor.valueDomain) && Objects.deepEquals(this.defaultValue, defaultParameterDescriptor.defaultValue);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return (long)Arrays.deepHashCode(new Object[]{this.valueClass, this.valueDomain, this.defaultValue}) + super.computeHashCode();
    }

    private DefaultParameterDescriptor() {
        PropertyType propertyType = Context.getWrapper((Context)Context.current());
        if (propertyType instanceof CC_OperationParameter) {
            CC_OperationParameter cC_OperationParameter = (CC_OperationParameter)propertyType;
            this.valueClass = cC_OperationParameter.valueClass;
            this.valueDomain = cC_OperationParameter.valueDomain;
        } else {
            this.valueClass = null;
            this.valueDomain = null;
        }
        this.validValues = null;
        this.defaultValue = null;
    }
}

