/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import javax.measure.unit.Unit;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.MapProjectionDescriptor;
import org.apache.sis.referencing.Builder;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;

public class ParameterBuilder
extends Builder<ParameterBuilder> {
    private boolean required;

    public ParameterBuilder() {
    }

    public ParameterBuilder(GeneralParameterDescriptor generalParameterDescriptor) {
        super((IdentifiedObject)generalParameterDescriptor);
        if (generalParameterDescriptor != null) {
            this.required = generalParameterDescriptor.getMinimumOccurs() != 0;
        }
    }

    public ParameterBuilder setRequired(boolean bl) {
        this.required = bl;
        return this;
    }

    private static Double valueOf(double d) {
        return Double.isNaN(d) ? null : Double.valueOf(d);
    }

    public <T> ParameterDescriptor<T> create(Class<T> clazz, T t) {
        return this.create(clazz, null, null, t);
    }

    public ParameterDescriptor<Double> create(double d, Unit<?> unit) {
        MeasurementRange measurementRange = unit != null ? MeasurementRange.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)false, unit) : null;
        return this.create((Class)Double.class, (Range<?>)measurementRange, null, (Object)ParameterBuilder.valueOf(d));
    }

    public ParameterDescriptor<Double> createStrictlyPositive(double d, Unit<?> unit) {
        Object object = unit != null ? MeasurementRange.createGreaterThan((double)0.0, unit) : NumberRange.create((double)0.0, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)false);
        return this.create((Class)Double.class, (Range<?>)object, null, (Object)ParameterBuilder.valueOf(d));
    }

    public ParameterDescriptor<Double> createBounded(double d, double d2, double d3, Unit<?> unit) {
        Object object = unit != null ? MeasurementRange.create((double)d, (boolean)true, (double)d2, (boolean)true, unit) : (d != Double.NEGATIVE_INFINITY || d2 != Double.POSITIVE_INFINITY ? NumberRange.create((double)d, (boolean)true, (double)d2, (boolean)true) : null);
        return this.create((Class)Double.class, (Range<?>)object, null, (Object)ParameterBuilder.valueOf(d3));
    }

    public ParameterDescriptor<Integer> createBounded(int n, int n2, int n3) {
        return this.create((Class)Integer.class, (Range<?>)NumberRange.create((int)n, (boolean)true, (int)n2, (boolean)true), null, n3);
    }

    public <T extends Comparable<? super T>> ParameterDescriptor<T> createBounded(Class<T> clazz, T t, T t2, T t3) {
        ArgumentChecks.ensureNonNull((String)"valueClass", clazz);
        Object object = t == null && t2 == null ? null : (Number.class.isAssignableFrom(clazz) ? new NumberRange(clazz, (Number)((Object)t), true, (Number)((Object)t2), true) : new Range(clazz, t, true, t2, true));
        return this.create(clazz, (Range<?>)object, null, t3);
    }

    public <T extends Comparable<? super T>> ParameterDescriptor<T> createBounded(Range<T> range, T t) {
        ArgumentChecks.ensureNonNull((String)"valueDomain", range);
        return this.create(range.getElementType(), range, null, t);
    }

    public <T> ParameterDescriptor<T> createEnumerated(Class<T> clazz, T[] TArray, T t) {
        ArgumentChecks.ensureNonNull((String)"valueClass", clazz);
        return this.create(clazz, null, TArray, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ParameterDescriptor<T> create(Class<T> clazz, Range<?> range, T[] TArray, T t) {
        DefaultParameterDescriptor<T> defaultParameterDescriptor;
        this.onCreate(false);
        try {
            defaultParameterDescriptor = new DefaultParameterDescriptor<T>(this.properties, this.required ? 1 : 0, 1, clazz, range, TArray, t);
        }
        finally {
            this.onCreate(true);
        }
        return defaultParameterDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterDescriptorGroup createGroup(int n, int n2, GeneralParameterDescriptor ... generalParameterDescriptorArray) {
        DefaultParameterDescriptorGroup defaultParameterDescriptorGroup;
        this.onCreate(false);
        try {
            defaultParameterDescriptorGroup = new DefaultParameterDescriptorGroup(this.properties, n, n2, generalParameterDescriptorArray);
        }
        finally {
            this.onCreate(true);
        }
        return defaultParameterDescriptorGroup;
    }

    public ParameterDescriptorGroup createGroup(GeneralParameterDescriptor ... generalParameterDescriptorArray) {
        return this.createGroup(this.required ? 1 : 0, 1, generalParameterDescriptorArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterDescriptorGroup createGroupForMapProjection(ParameterDescriptor<?> ... parameterDescriptorArray) {
        MapProjectionDescriptor mapProjectionDescriptor;
        this.onCreate(false);
        try {
            mapProjectionDescriptor = new MapProjectionDescriptor(this.properties, parameterDescriptorArray);
        }
        finally {
            this.onCreate(true);
        }
        return mapProjectionDescriptor;
    }
}

