/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.DefinitionURI;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultCompoundCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public final class CRS
extends Static {
    private CRS() {
    }

    public static CoordinateReferenceSystem forCode(String string) throws NoSuchAuthorityCodeException, FactoryException {
        String string2;
        String string3;
        String string4;
        ArgumentChecks.ensureNonNull((String)"code", (Object)string);
        DefinitionURI definitionURI = DefinitionURI.parse((String)string);
        if (definitionURI != null) {
            string4 = definitionURI.type;
            if (string4 != null && !string4.equalsIgnoreCase("crs")) {
                throw new NoSuchIdentifierException(Errors.format((short)118, (Object)string4), string4);
            }
            string3 = definitionURI.authority;
            string2 = definitionURI.code;
        } else {
            int n = string.indexOf(58);
            string3 = CharSequences.trimWhitespaces((String)string.substring(0, Math.max(0, n)));
            string2 = CharSequences.trimWhitespaces((String)string.substring(n + 1));
        }
        if (string3 == null || string3.isEmpty()) {
            throw new NoSuchIdentifierException(Errors.format((short)135, (Object)string), string);
        }
        string4 = (CRSAuthorityFactory)DefaultFactories.forClass(CRSAuthorityFactory.class);
        if (string4 != null) {
            try {
                return string4.createCoordinateReferenceSystem(string2);
            }
            catch (FactoryException factoryException) {
                CoordinateReferenceSystem coordinateReferenceSystem = CommonCRS.forCode(string3, string2, factoryException);
                Logging.unexpectedException((Logger)Logging.getLogger((String)"org.apache.sis.referencing.factory"), CRS.class, (String)"forCode", (Throwable)factoryException);
                return coordinateReferenceSystem;
            }
        }
        return CommonCRS.forCode(string3, string2, null);
    }

    public static CoordinateReferenceSystem fromWKT(String string) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"text", (Object)string);
        return ((CRSFactory)DefaultFactories.forBuildin(CRSFactory.class)).createFromWKT(string);
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem coordinateReferenceSystem) {
        return coordinateReferenceSystem != null ? Extents.getGeographicBoundingBox((Extent)coordinateReferenceSystem.getDomainOfValidity()) : null;
    }

    public static boolean isHorizontalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof GeographicCRS || coordinateReferenceSystem instanceof ProjectedCRS || coordinateReferenceSystem instanceof EngineeringCRS) {
            return coordinateReferenceSystem.getCoordinateSystem().getDimension() == 2;
        }
        return false;
    }

    public static SingleCRS getHorizontalComponent(CoordinateReferenceSystem coordinateReferenceSystem) {
        EllipsoidalCS ellipsoidalCS;
        int n;
        if (CRS.isHorizontalCRS(coordinateReferenceSystem)) {
            return (SingleCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof GeographicCRS && (n = AxisDirections.indexOfColinear((CoordinateSystem)(ellipsoidalCS = ((GeographicCRS)coordinateReferenceSystem).getCoordinateSystem()), (AxisDirection)AxisDirection.UP)) >= 0) {
            CoordinateSystemAxis coordinateSystemAxis = ellipsoidalCS.getAxis(n > 0 ? 0 : 1);
            CoordinateSystemAxis coordinateSystemAxis2 = ellipsoidalCS.getAxis(n > 1 ? 1 : 2);
            ellipsoidalCS = CommonCRS.DEFAULT.geographic().getCoordinateSystem();
            if (!Utilities.equalsIgnoreMetadata((Object)ellipsoidalCS.getAxis(0), (Object)coordinateSystemAxis) || !Utilities.equalsIgnoreMetadata((Object)ellipsoidalCS.getAxis(1), (Object)coordinateSystemAxis2)) {
                ellipsoidalCS = new DefaultEllipsoidalCS((Map<String, ?>)Collections.singletonMap("name", "Ellipsoidal 2D"), coordinateSystemAxis, coordinateSystemAxis2);
            }
            return new DefaultGeographicCRS(IdentifiedObjects.getProperties((IdentifiedObject)coordinateReferenceSystem, new String[0]), ((GeographicCRS)coordinateReferenceSystem).getDatum(), ellipsoidalCS);
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            ellipsoidalCS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : ellipsoidalCS.getComponents()) {
                SingleCRS singleCRS = CRS.getHorizontalComponent(coordinateReferenceSystem2);
                if (singleCRS == null) continue;
                return singleCRS;
            }
        }
        return null;
    }

    public static VerticalCRS getVerticalComponent(CoordinateReferenceSystem coordinateReferenceSystem, boolean bl) {
        Object object;
        boolean bl2;
        CompoundCRS compoundCRS;
        if (coordinateReferenceSystem instanceof VerticalCRS) {
            return (VerticalCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            bl2 = false;
            do {
                for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                    object = CRS.getVerticalComponent(coordinateReferenceSystem2, bl2);
                    if (object == null) continue;
                    return object;
                }
            } while ((bl2 = !bl2) == bl);
        }
        if (bl && coordinateReferenceSystem instanceof GeographicCRS && (bl2 = AxisDirections.indexOfColinear((CoordinateSystem)(compoundCRS = coordinateReferenceSystem.getCoordinateSystem()), (AxisDirection)AxisDirection.UP)) >= false) {
            CoordinateReferenceSystem coordinateReferenceSystem2;
            CoordinateSystemAxis coordinateSystemAxis = compoundCRS.getAxis(bl2 ? 1 : 0);
            coordinateReferenceSystem2 = CommonCRS.Vertical.ELLIPSOIDAL.crs();
            if (!coordinateReferenceSystem2.getCoordinateSystem().getAxis(0).equals(coordinateSystemAxis)) {
                object = IdentifiedObjects.getProperties((IdentifiedObject)coordinateReferenceSystem2, new String[0]);
                coordinateReferenceSystem2 = new DefaultVerticalCRS((Map<String, ?>)object, coordinateReferenceSystem2.getDatum(), new DefaultVerticalCS((Map<String, ?>)object, coordinateSystemAxis));
            }
            return coordinateReferenceSystem2;
        }
        return null;
    }

    public static TemporalCRS getTemporalComponent(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof TemporalCRS) {
            return (TemporalCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            CompoundCRS compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                TemporalCRS temporalCRS = CRS.getTemporalComponent(coordinateReferenceSystem2);
                if (temporalCRS == null) continue;
                return temporalCRS;
            }
        }
        return null;
    }

    public static List<SingleCRS> getSingleComponents(CoordinateReferenceSystem coordinateReferenceSystem) {
        List<SingleCRS> list;
        if (coordinateReferenceSystem == null) {
            list = Collections.emptyList();
        } else if (coordinateReferenceSystem instanceof CompoundCRS) {
            if (coordinateReferenceSystem instanceof DefaultCompoundCRS) {
                list = ((DefaultCompoundCRS)coordinateReferenceSystem).getSingleComponents();
            } else {
                List list2 = ((CompoundCRS)coordinateReferenceSystem).getComponents();
                list = new ArrayList<SingleCRS>(list2.size());
                ReferencingUtilities.getSingleComponents(list2, list);
            }
        } else {
            list = Collections.singletonList((SingleCRS)coordinateReferenceSystem);
        }
        return list;
    }

    public static CoordinateReferenceSystem getComponentAt(CoordinateReferenceSystem coordinateReferenceSystem, int n, int n2) {
        int n3 = ReferencingUtilities.getDimension(coordinateReferenceSystem);
        ArgumentChecks.ensureValidIndexRange((int)n3, (int)n, (int)n2);
        block0: while (n != 0 || n2 != n3) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                List list = ((CompoundCRS)coordinateReferenceSystem).getComponents();
                int n4 = list.size();
                for (int i = 0; i < n4; ++i) {
                    coordinateReferenceSystem = (CoordinateReferenceSystem)list.get(i);
                    n3 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
                    if (n < n3) continue block0;
                    n -= n3;
                    n2 -= n3;
                }
            }
            return null;
        }
        return coordinateReferenceSystem;
    }

    public static double getGreenwichLongitude(GeodeticCRS geodeticCRS) {
        ArgumentChecks.ensureNonNull((String)"crs", (Object)geodeticCRS);
        return ReferencingUtilities.getGreenwichLongitude(geodeticCRS.getDatum().getPrimeMeridian(), (Unit<Angle>)NonSI.DEGREE_ANGLE);
    }
}

