/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AxisFilter;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public enum AxesConvention implements AxisFilter
{
    NORMALIZED{

        @Override
        public boolean accept(CoordinateSystemAxis coordinateSystemAxis) {
            return true;
        }

        @Override
        public Unit<?> getUnitReplacement(Unit<?> baseUnit) {
            if (Units.isLinear(baseUnit)) {
                baseUnit = SI.METRE;
            } else if (Units.isAngular((Unit)baseUnit)) {
                baseUnit = NonSI.DEGREE_ANGLE;
            } else if (Units.isTemporal((Unit)baseUnit)) {
                baseUnit = NonSI.DAY;
            }
            return baseUnit;
        }

        @Override
        public AxisDirection getDirectionReplacement(AxisDirection axisDirection) {
            return AxisDirections.isIntercardinal((AxisDirection)axisDirection) ? axisDirection : AxisDirections.absolute((AxisDirection)axisDirection);
        }
    }
    ,
    CONVENTIONALLY_ORIENTED{

        @Override
        public boolean accept(CoordinateSystemAxis coordinateSystemAxis) {
            return true;
        }

        @Override
        public Unit<?> getUnitReplacement(Unit<?> unit) {
            return unit;
        }

        @Override
        public AxisDirection getDirectionReplacement(AxisDirection axisDirection) {
            return AxisDirections.isIntercardinal((AxisDirection)axisDirection) ? axisDirection : AxisDirections.absolute((AxisDirection)axisDirection);
        }
    }
    ,
    RIGHT_HANDED{

        @Override
        public boolean accept(CoordinateSystemAxis coordinateSystemAxis) {
            return true;
        }

        @Override
        public Unit<?> getUnitReplacement(Unit<?> unit) {
            return unit;
        }

        @Override
        public AxisDirection getDirectionReplacement(AxisDirection axisDirection) {
            return axisDirection;
        }
    }
    ,
    POSITIVE_RANGE{

        @Override
        public boolean accept(CoordinateSystemAxis coordinateSystemAxis) {
            return true;
        }

        @Override
        public Unit<?> getUnitReplacement(Unit<?> unit) {
            return unit;
        }

        @Override
        public AxisDirection getDirectionReplacement(AxisDirection axisDirection) {
            return axisDirection;
        }
    };

}

