/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Arrays;
import javax.measure.converter.ConversionException;
import javax.measure.converter.LinearConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.ElevationAngle;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.DirectionAlongMeridian;
import org.apache.sis.referencing.cs.Normalizer;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Matrix;

public final class CoordinateSystems
extends Static {
    private CoordinateSystems() {
    }

    public static AxisDirection parseAxisDirection(String string) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        string = CharSequences.trimWhitespaces((String)string);
        AxisDirection axisDirection = AxisDirections.valueOf((String)string);
        if (axisDirection != null) {
            return axisDirection;
        }
        DirectionAlongMeridian directionAlongMeridian = DirectionAlongMeridian.parse(string);
        if (directionAlongMeridian != null) {
            axisDirection = directionAlongMeridian.getDirection();
            assert (axisDirection == AxisDirections.valueOf((String)directionAlongMeridian.toString()));
            return axisDirection;
        }
        throw new IllegalArgumentException(Errors.format((short)112, (Object)string));
    }

    public static AxisDirection directionAlongMeridian(AxisDirection axisDirection, double d) {
        return new DirectionAlongMeridian(axisDirection, d).getDirection();
    }

    public static Angle angle(AxisDirection axisDirection, AxisDirection axisDirection2) {
        DirectionAlongMeridian directionAlongMeridian;
        ArgumentChecks.ensureNonNull((String)"source", (Object)axisDirection);
        ArgumentChecks.ensureNonNull((String)"target", (Object)axisDirection2);
        int n = AxisDirections.angleForCompass((AxisDirection)axisDirection, (AxisDirection)axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return new Angle((double)n * 22.5);
        }
        n = AxisDirections.angleForGeocentric((AxisDirection)axisDirection, (AxisDirection)axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return new Angle((double)(n * 90));
        }
        n = AxisDirections.angleForDisplay((AxisDirection)axisDirection, (AxisDirection)axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return new Angle((double)(n * 90));
        }
        DirectionAlongMeridian directionAlongMeridian2 = AxisDirections.isUserDefined((AxisDirection)axisDirection) ? DirectionAlongMeridian.parse(axisDirection) : null;
        DirectionAlongMeridian directionAlongMeridian3 = directionAlongMeridian = AxisDirections.isUserDefined((AxisDirection)axisDirection2) ? DirectionAlongMeridian.parse(axisDirection2) : null;
        if (directionAlongMeridian2 != null && directionAlongMeridian != null) {
            return new Angle(directionAlongMeridian2.angle(directionAlongMeridian));
        }
        boolean bl = AxisDirections.isVertical((AxisDirection)axisDirection);
        boolean bl2 = AxisDirections.isVertical((AxisDirection)axisDirection2);
        if (bl2) {
            if (bl) {
                return new Angle(axisDirection.equals((Object)axisDirection2) ? 0.0 : (axisDirection2.equals((Object)AxisDirection.UP) ? 180.0 : -180.0));
            }
            if (AxisDirections.isCompass((AxisDirection)axisDirection) || directionAlongMeridian2 != null) {
                return axisDirection2.equals((Object)AxisDirection.UP) ? ElevationAngle.ZENITH : ElevationAngle.NADIR;
            }
        } else if (bl && (AxisDirections.isCompass((AxisDirection)axisDirection2) || directionAlongMeridian != null)) {
            return axisDirection.equals((Object)AxisDirection.UP) ? ElevationAngle.NADIR : ElevationAngle.ZENITH;
        }
        return null;
    }

    private static AxisDirection[] getAxisDirections(CoordinateSystem coordinateSystem) {
        AxisDirection[] axisDirectionArray = new AxisDirection[coordinateSystem.getDimension()];
        for (int i = 0; i < axisDirectionArray.length; ++i) {
            axisDirectionArray[i] = coordinateSystem.getAxis(i).getDirection();
        }
        return axisDirectionArray;
    }

    public static Matrix swapAndScaleAxes(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) throws IllegalArgumentException, ConversionException {
        ArgumentChecks.ensureNonNull((String)"sourceCS", (Object)coordinateSystem);
        ArgumentChecks.ensureNonNull((String)"targetCS", (Object)coordinateSystem2);
        if (!Classes.implementSameInterfaces(coordinateSystem.getClass(), coordinateSystem2.getClass(), CoordinateSystem.class)) {
            throw new IllegalArgumentException(Errors.format((short)44));
        }
        Object[] objectArray = CoordinateSystems.getAxisDirections(coordinateSystem);
        Object[] objectArray2 = CoordinateSystems.getAxisDirections(coordinateSystem2);
        MatrixSIS matrixSIS = Matrices.createTransform((AxisDirection[])objectArray, (AxisDirection[])objectArray2);
        assert (Arrays.equals(objectArray, objectArray2) == matrixSIS.isIdentity()) : matrixSIS;
        int n = matrixSIS.getNumCol() - 1;
        int n2 = matrixSIS.getNumRow() - 1;
        for (int i = 0; i < n2; ++i) {
            Unit unit = coordinateSystem2.getAxis(i).getUnit();
            for (int j = 0; j < n; ++j) {
                Unit unit2;
                double d = matrixSIS.getElement(i, j);
                if (d == 0.0 || Objects.equals((Object)(unit2 = coordinateSystem.getAxis(j).getUnit()), (Object)unit)) continue;
                UnitConverter unitConverter = unit2.getConverterToAny(unit);
                if (!(unitConverter instanceof LinearConverter)) {
                    throw new ConversionException(Errors.format((short)83, (Object)unit2, (Object)unit));
                }
                double d2 = unitConverter.convert(0.0);
                double d3 = Units.derivative((UnitConverter)unitConverter, (double)0.0);
                matrixSIS.setElement(i, j, d * d3);
                matrixSIS.setElement(i, n, matrixSIS.getElement(i, n) + d * d2);
            }
        }
        return matrixSIS;
    }

    public static CoordinateSystem replaceAxes(CoordinateSystem coordinateSystem, AxisFilter axisFilter) {
        ArgumentChecks.ensureNonNull((String)"filter", (Object)axisFilter);
        if (coordinateSystem != null) {
            AbstractCS abstractCS;
            if (axisFilter instanceof AxesConvention) {
                if (coordinateSystem instanceof AbstractCS) {
                    return ((AbstractCS)coordinateSystem).forConvention((AxesConvention)axisFilter);
                }
                abstractCS = Normalizer.forConvention(coordinateSystem, (AxesConvention)axisFilter);
            } else {
                abstractCS = Normalizer.normalize(coordinateSystem, axisFilter, false);
            }
            if (abstractCS != null) {
                return abstractCS;
            }
        }
        return coordinateSystem;
    }
}

