/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Date;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.datum.GeodeticDatum;

public class TimeDependentBWP
extends BursaWolfParameters {
    private static final long serialVersionUID = -4628799278259080258L;
    public double dtX;
    public double dtY;
    public double dtZ;
    public double drX;
    public double drY;
    public double drZ;
    public double ddS;
    private final long timeReference;

    public TimeDependentBWP(GeodeticDatum geodeticDatum, Extent extent, Date date) {
        super(geodeticDatum, extent);
        ArgumentChecks.ensureNonNull((String)"timeReference", (Object)date);
        this.timeReference = date.getTime();
    }

    @Override
    void verify() {
        super.verify();
        ArgumentChecks.ensureFinite((String)"dtX", (double)this.dtX);
        ArgumentChecks.ensureFinite((String)"dtY", (double)this.dtY);
        ArgumentChecks.ensureFinite((String)"dtZ", (double)this.dtZ);
        ArgumentChecks.ensureFinite((String)"drX", (double)this.drX);
        ArgumentChecks.ensureFinite((String)"drY", (double)this.drY);
        ArgumentChecks.ensureFinite((String)"drZ", (double)this.drZ);
    }

    public Date getTimeReference() {
        return new Date(this.timeReference);
    }

    @Override
    final DoubleDouble period(Date date) {
        long l;
        if (date != null && (l = date.getTime() - this.timeReference) != 0L) {
            DoubleDouble doubleDouble = DoubleDouble.verbatim((double)l);
            doubleDouble.divide(3.15576E13, 0.0);
            return doubleDouble;
        }
        return null;
    }

    @Override
    final DoubleDouble param(int n, DoubleDouble doubleDouble) {
        DoubleDouble doubleDouble2 = super.param(n, doubleDouble);
        if (doubleDouble != null) {
            double d;
            double d2 = doubleDouble.value;
            double d3 = doubleDouble.error;
            switch (n) {
                case 0: {
                    d = this.dtX;
                    break;
                }
                case 1: {
                    d = this.dtY;
                    break;
                }
                case 2: {
                    d = this.dtZ;
                    break;
                }
                case 3: {
                    d = this.drX;
                    break;
                }
                case 4: {
                    d = this.drY;
                    break;
                }
                case 5: {
                    d = this.drZ;
                    break;
                }
                case 6: {
                    d = this.ddS;
                    doubleDouble.multiply(1000.0, 0.0);
                    break;
                }
                default: {
                    throw new AssertionError(n);
                }
            }
            doubleDouble.multiply(d);
            doubleDouble2.add(doubleDouble);
            doubleDouble.value = d2;
            doubleDouble.error = d3;
        }
        return doubleDouble2;
    }

    @Override
    public double[] getValues() {
        return new double[]{this.tX, this.tY, this.tZ, this.rX, this.rY, this.rZ, this.dS, this.dtX, this.dtY, this.dtZ, this.drX, this.drY, this.drZ, this.ddS};
    }

    @Override
    public void setValues(double ... dArray) {
        if (dArray.length >= 8) {
            switch (dArray.length) {
                default: {
                    this.ddS = dArray[13];
                }
                case 13: {
                    this.drZ = dArray[12];
                }
                case 12: {
                    this.drY = dArray[11];
                }
                case 11: {
                    this.drX = dArray[10];
                }
                case 10: {
                    this.dtZ = dArray[9];
                }
                case 9: {
                    this.dtY = dArray[8];
                }
                case 8: 
            }
            this.dtX = dArray[7];
        }
        super.setValues(dArray);
    }

    @Override
    public boolean isIdentity() {
        return super.isIdentity() && this.dtX == 0.0 && this.dtY == 0.0 && this.dtZ == 0.0;
    }

    @Override
    public boolean isTranslation() {
        return super.isTranslation() && this.drX == 0.0 && this.drY == 0.0 && this.drZ == 0.0;
    }

    @Override
    public void reverseRotation() {
        super.reverseRotation();
        this.drX = -this.drX;
        this.drY = -this.drY;
        this.drZ = -this.drZ;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.timeReference == ((TimeDependentBWP)object).timeReference;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Numerics.hashCode((long)this.timeReference);
    }
}

