/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.ExponentialTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.referencing.operation.transform.LogarithmicTransform1D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Characters;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;

public class TransferFunction
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 185931909755748004L;
    private TransferFunctionType type = TransferFunctionType.LINEAR;
    private double base = 10.0;
    private double scale = 1.0;
    private double offset;
    private MathTransform1D transform;

    public TransferFunctionType getType() {
        return this.type;
    }

    public void setType(TransferFunctionType transferFunctionType) {
        ArgumentChecks.ensureNonNull((String)"type", (Object)transferFunctionType);
        this.type = transferFunctionType;
        this.transform = null;
    }

    public double getBase() {
        return TransferFunctionType.LINEAR.equals((Object)this.type) ? 1.0 : this.base;
    }

    public void setBase(double d) {
        ArgumentChecks.ensureStrictlyPositive((String)"base", (double)d);
        this.base = d;
        this.transform = null;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
        this.transform = null;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double d) {
        this.offset = d;
        this.transform = null;
    }

    public MathTransform1D getTransform() {
        if (this.transform == null) {
            if (TransferFunctionType.LINEAR.equals((Object)this.type)) {
                this.transform = LinearTransform1D.create(this.scale, this.offset);
            } else if (TransferFunctionType.EXPONENTIAL.equals((Object)this.type)) {
                this.transform = ExponentialTransform1D.create(this.base, this.scale);
                if (this.offset != 0.0) {
                    this.transform = (MathTransform1D)ConcatenatedTransform.create((MathTransform)this.transform, LinearTransform1D.create(0.0, this.offset));
                }
            } else if (TransferFunctionType.LOGARITHMIC.equals((Object)this.type)) {
                this.transform = this.scale == 1.0 ? LogarithmicTransform1D.create(this.base, this.offset) : (MathTransform1D)ConcatenatedTransform.create((MathTransform)LogarithmicTransform1D.create(this.base, 0.0), LinearTransform1D.create(this.scale, this.offset));
            } else {
                throw new IllegalStateException(Errors.format((short)118, (Object)this.type));
            }
        }
        return this.transform;
    }

    public void setTransform(MathTransform1D mathTransform1D) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull((String)"function", (Object)mathTransform1D);
        if (mathTransform1D instanceof LinearTransform) {
            this.setLinearTerms((LinearTransform)mathTransform1D);
            this.type = TransferFunctionType.LINEAR;
        } else if (mathTransform1D instanceof ExponentialTransform1D) {
            ExponentialTransform1D exponentialTransform1D = (ExponentialTransform1D)mathTransform1D;
            this.type = TransferFunctionType.EXPONENTIAL;
            this.base = exponentialTransform1D.base;
            this.scale = exponentialTransform1D.scale;
            this.offset = 0.0;
        } else if (mathTransform1D instanceof LogarithmicTransform1D) {
            LogarithmicTransform1D logarithmicTransform1D = (LogarithmicTransform1D)mathTransform1D;
            this.type = TransferFunctionType.LOGARITHMIC;
            this.base = logarithmicTransform1D.base();
            this.offset = logarithmicTransform1D.offset();
            this.scale = 1.0;
        } else {
            LogarithmicTransform1D.Base10 base10 = LogarithmicTransform1D.Base10.INSTANCE;
            MathTransform1D mathTransform1D2 = MathTransforms.concatenate(mathTransform1D, base10);
            if (mathTransform1D2 instanceof LinearTransform) {
                this.setLinearTerms((LinearTransform)mathTransform1D2);
                this.type = TransferFunctionType.EXPONENTIAL;
                this.base = 10.0;
            } else {
                mathTransform1D2 = MathTransforms.concatenate(base10.inverse(), mathTransform1D);
                if (mathTransform1D2 instanceof LinearTransform) {
                    this.setLinearTerms((LinearTransform)mathTransform1D2);
                    this.type = TransferFunctionType.LOGARITHMIC;
                    this.base = 10.0;
                } else {
                    throw new IllegalArgumentException(Errors.format((short)118, mathTransform1D.getClass()));
                }
            }
        }
        this.transform = mathTransform1D;
    }

    private void setLinearTerms(LinearTransform linearTransform) throws IllegalArgumentException {
        Matrix matrix = linearTransform.getMatrix();
        int n = matrix.getNumRow();
        int n2 = matrix.getNumCol();
        if (n != 2 || n2 != 2) {
            Integer n3 = 2;
            throw new IllegalArgumentException(Errors.format((short)60, (Object)n3, (Object)n3, (Object)n, (Object)n2));
        }
        this.scale = matrix.getElement(0, 0);
        this.offset = matrix.getElement(0, 1);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("y = ");
        if (this.scale != 1.0) {
            if (this.scale == -1.0) {
                stringBuilder.append('\u2212');
            } else {
                StringBuilders.trimFractionalPart((StringBuilder)stringBuilder.append(this.scale).append('\u22c5'));
            }
        }
        if (TransferFunctionType.LINEAR.equals((Object)this.type)) {
            stringBuilder.append('x');
        } else if (TransferFunctionType.EXPONENTIAL.equals((Object)this.type)) {
            if (this.base == Math.E) {
                stringBuilder.append('e');
            } else {
                StringBuilders.trimFractionalPart((StringBuilder)stringBuilder.append(this.base));
            }
            stringBuilder.append('\u02e3');
        } else if (TransferFunctionType.LOGARITHMIC.equals((Object)this.type)) {
            if (this.base == Math.E) {
                stringBuilder.append("ln");
            } else {
                stringBuilder.append('\u33d2');
                if (this.base != 10.0) {
                    int n = (int)this.base;
                    if ((double)n == this.base && n >= 0 && n <= 9) {
                        stringBuilder.append(Characters.toSubScript((char)((char)(n - 48))));
                    } else {
                        StringBuilders.trimFractionalPart((StringBuilder)stringBuilder.append(this.base));
                    }
                }
            }
            stringBuilder.append('\u24b3');
        } else {
            stringBuilder.append('?');
        }
        if (this.offset != 0.0) {
            StringBuilders.trimFractionalPart((StringBuilder)stringBuilder.append(' ').append(this.offset < 0.0 ? (char)'\u2212' : '+').append(' ').append(Math.abs(this.offset)));
        }
        return stringBuilder.toString();
    }
}

