/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sshd.client.UserAuth;
import org.apache.sshd.client.UserInteraction;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.DefaultAuthFuture;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.CloseableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientUserAuthServiceNew
implements Service {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AuthFuture authFuture;
    protected final ClientSessionImpl session;
    private List<Object> identities;
    private String service;
    List<NamedFactory<UserAuth>> authFactories;
    List<String> clientMethods;
    List<String> serverMethods;
    UserAuth userAuth;
    int currentMethod;

    public ClientUserAuthServiceNew(Session s) {
        if (!(s instanceof ClientSessionImpl)) {
            throw new IllegalStateException("Client side service used on server side");
        }
        this.session = (ClientSessionImpl)s;
        this.authFuture = new DefaultAuthFuture(this.session.getLock());
        this.authFactories = this.session.getFactoryManager().getUserAuthFactories();
        this.clientMethods = new ArrayList<String>();
        String prefs = this.session.getFactoryManager().getProperties().get("preferred-auths");
        if (prefs != null) {
            for (String pref : prefs.split(",")) {
                if (NamedFactory.Utils.get(this.authFactories, pref) == null) continue;
                this.clientMethods.add(pref);
            }
        } else {
            for (NamedFactory<UserAuth> factory : this.authFactories) {
                this.clientMethods.add(factory.getName());
            }
        }
    }

    @Override
    public ClientSessionImpl getSession() {
        return this.session;
    }

    @Override
    public void start() {
    }

    public AuthFuture auth(List<Object> identities, String service) throws IOException {
        this.log.debug("Start authentication");
        this.identities = new ArrayList<Object>(identities);
        this.service = service;
        this.log.debug("Send SSH_MSG_USERAUTH_REQUEST for none");
        Buffer buffer = this.session.createBuffer((byte)50);
        buffer.putString(this.session.getUsername());
        buffer.putString(service);
        buffer.putString("none");
        this.session.writePacket(buffer);
        return this.authFuture;
    }

    @Override
    public void process(byte cmd, Buffer buffer) throws Exception {
        if (this.authFuture.isSuccess()) {
            throw new IllegalStateException("UserAuth message delivered to authenticated client");
        }
        if (this.authFuture.isDone()) {
            this.log.debug("Ignoring random message");
        } else if (cmd == 53) {
            String welcome = buffer.getString();
            String lang = buffer.getString();
            this.log.debug("Welcome banner: {}", (Object)welcome);
            UserInteraction ui = this.session.getFactoryManager().getUserInteraction();
            if (ui != null) {
                ui.welcome(welcome);
            }
        } else {
            buffer.rpos(buffer.rpos() - 1);
            this.processUserAuth(buffer);
        }
    }

    private void processUserAuth(Buffer buffer) throws Exception {
        byte cmd = buffer.getByte();
        if (cmd == 52) {
            this.log.info("Received SSH_MSG_USERAUTH_SUCCESS");
            this.log.debug("Succeeded with {}", (Object)this.userAuth);
            if (this.userAuth != null) {
                this.userAuth.destroy();
                this.userAuth = null;
            }
            this.session.setAuthenticated();
            this.session.switchToNextService();
            this.authFuture.setAuthed(true);
            return;
        }
        if (cmd == 51) {
            this.log.info("Received SSH_MSG_USERAUTH_FAILURE");
            String mths = buffer.getString();
            boolean partial = buffer.getBoolean();
            if (partial || this.serverMethods == null) {
                this.serverMethods = Arrays.asList(mths.split(","));
                if (this.log.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder("Authentications that can continue: ");
                    for (int i = 0; i < this.serverMethods.size(); ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(this.serverMethods.get(i));
                    }
                    this.log.debug(sb.toString());
                }
                if (this.userAuth != null) {
                    this.userAuth.destroy();
                    this.userAuth = null;
                }
            }
            this.tryNext();
            return;
        }
        if (this.userAuth == null) {
            throw new IllegalStateException("Received unknown packet");
        }
        buffer.rpos(buffer.rpos() - 1);
        if (!this.userAuth.process(buffer)) {
            this.tryNext();
        }
    }

    private void tryNext() throws Exception {
        while (true) {
            if (this.userAuth == null) {
                this.currentMethod = 0;
            } else if (!this.userAuth.process(null)) {
                this.userAuth.destroy();
                ++this.currentMethod;
            } else {
                return;
            }
            while (this.currentMethod < this.clientMethods.size() && !this.serverMethods.contains(this.clientMethods.get(this.currentMethod))) {
                ++this.currentMethod;
            }
            if (this.currentMethod >= this.clientMethods.size()) {
                this.authFuture.setAuthed(false);
                return;
            }
            String method = this.clientMethods.get(this.currentMethod);
            this.userAuth = (UserAuth)NamedFactory.Utils.create(this.authFactories, method);
            assert (this.userAuth != null);
            this.userAuth.init(this.session, this.service, this.identities);
        }
    }

    @Override
    public CloseFuture close(boolean immediately) {
        this.log.debug("Closing authentication service");
        if (!this.authFuture.isDone()) {
            this.authFuture.setException(new SshException("Session is closed"));
        }
        return CloseableUtils.closed();
    }
}

