/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.Cipher;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Compression;
import org.apache.sshd.common.Digest;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.Mac;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Random;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SessionListener;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.BufferUtils;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.Readable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSession
extends CloseableUtils.AbstractInnerCloseable
implements Session {
    public static final String SESSION = "org.apache.sshd.session";
    protected static final int KEX_STATE_INIT = 1;
    protected static final int KEX_STATE_RUN = 2;
    protected static final int KEX_STATE_KEYS = 3;
    protected static final int KEX_STATE_DONE = 4;
    protected final boolean isServer;
    protected final FactoryManager factoryManager;
    protected final IoSession ioSession;
    protected final Random random;
    protected boolean authed;
    protected String username;
    protected final List<SessionListener> listeners = new CopyOnWriteArrayList<SessionListener>();
    protected byte[] sessionId;
    protected String serverVersion;
    protected String clientVersion;
    protected String[] serverProposal;
    protected String[] clientProposal;
    protected String[] negotiated;
    protected byte[] I_C;
    protected byte[] I_S;
    protected KeyExchange kex;
    protected final AtomicInteger kexState = new AtomicInteger();
    protected DefaultSshFuture reexchangeFuture;
    protected Cipher outCipher;
    protected Cipher inCipher;
    protected int outCipherSize = 8;
    protected int inCipherSize = 8;
    protected Mac outMac;
    protected Mac inMac;
    protected byte[] inMacResult;
    protected Compression outCompression;
    protected Compression inCompression;
    protected long seqi;
    protected long seqo;
    protected Buffer decoderBuffer = new Buffer();
    protected Buffer uncompressBuffer;
    protected int decoderState;
    protected int decoderLength;
    protected final Object encodeLock = new Object();
    protected final Object decodeLock = new Object();
    protected final Object requestLock = new Object();
    protected final AtomicReference<Buffer> requestResult = new AtomicReference();
    protected final Map<Session.AttributeKey<?>, Object> attributes = new ConcurrentHashMap();
    protected volatile long inPackets;
    protected volatile long outPackets;
    protected volatile long inBytes;
    protected volatile long outBytes;
    protected volatile long lastKeyTime;
    protected final Queue<PendingWriteFuture> pendingPackets = new LinkedList<PendingWriteFuture>();
    protected Service currentService;

    public AbstractSession(boolean isServer, FactoryManager factoryManager, IoSession ioSession) {
        this.isServer = isServer;
        this.factoryManager = factoryManager;
        this.ioSession = ioSession;
        this.random = factoryManager.getRandomFactory().create();
    }

    public static AbstractSession getSession(IoSession ioSession) {
        return AbstractSession.getSession(ioSession, false);
    }

    public static AbstractSession getSession(IoSession ioSession, boolean allowNull) {
        AbstractSession session = (AbstractSession)ioSession.getAttribute(SESSION);
        if (!allowNull && session == null) {
            throw new IllegalStateException("No session available");
        }
        return session;
    }

    public static void attachSession(IoSession ioSession, AbstractSession session) {
        ioSession.setAttribute(SESSION, session);
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public String getClientVersion() {
        return this.clientVersion;
    }

    public KeyExchange getKex() {
        return this.kex;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public IoSession getIoSession() {
        return this.ioSession;
    }

    @Override
    public FactoryManager getFactoryManager() {
        return this.factoryManager;
    }

    public boolean isAuthenticated() {
        return this.authed;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setAuthenticated() throws IOException {
        this.authed = true;
        this.sendEvent(SessionListener.Event.Authenticated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(Readable buffer) throws Exception {
        Object object = this.decodeLock;
        synchronized (object) {
            this.decoderBuffer.putBuffer(buffer);
            if (this.clientVersion == null || this.serverVersion == null) {
                if (this.readIdentification(this.decoderBuffer)) {
                    this.decoderBuffer.compact();
                } else {
                    return;
                }
            }
            this.decode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(Buffer buffer) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.doHandleMessage(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHandleMessage(Buffer buffer) throws Exception {
        byte cmd = buffer.getByte();
        switch (cmd) {
            case 1: {
                int code = buffer.getInt();
                String msg = buffer.getString();
                this.log.debug("Received SSH_MSG_DISCONNECT (reason={}, msg={})", (Object)code, (Object)msg);
                this.close(true);
                break;
            }
            case 2: {
                this.log.debug("Received SSH_MSG_IGNORE");
                break;
            }
            case 3: {
                int code = buffer.getInt();
                this.log.debug("Received SSH_MSG_UNIMPLEMENTED #{}", (Object)code);
                break;
            }
            case 4: {
                boolean display = buffer.getBoolean();
                String msg = buffer.getString();
                this.log.debug("Received SSH_MSG_DEBUG (display={}) '{}'", (Object)display, (Object)msg);
                break;
            }
            case 5: {
                String service = buffer.getString();
                this.log.debug("Received SSH_MSG_SERVICE_REQUEST '{}'", (Object)service);
                if (this.kexState.get() != 4) {
                    throw new IllegalStateException("Received command " + cmd + " before key exchange is finished");
                }
                try {
                    this.startService(service);
                }
                catch (Exception e) {
                    this.log.debug("Service " + service + " rejected", (Throwable)e);
                    this.disconnect(7, "Bad service request: " + service);
                    break;
                }
                this.log.debug("Accepted service {}", (Object)service);
                Buffer response = this.createBuffer((byte)6);
                response.putString(service);
                this.writePacket(response);
                break;
            }
            case 6: {
                this.log.debug("Received SSH_MSG_SERVICE_ACCEPT");
                if (this.kexState.get() != 4) {
                    throw new IllegalStateException("Received command " + cmd + " before key exchange is finished");
                }
                this.serviceAccept();
                break;
            }
            case 20: {
                this.log.debug("Received SSH_MSG_KEXINIT");
                this.receiveKexInit(buffer);
                if (this.kexState.compareAndSet(4, 2)) {
                    this.sendKexInit();
                } else if (!this.kexState.compareAndSet(1, 2)) {
                    throw new IllegalStateException("Received SSH_MSG_KEXINIT while key exchange is running");
                }
                this.negotiate();
                this.kex = (KeyExchange)NamedFactory.Utils.create(this.factoryManager.getKeyExchangeFactories(), this.negotiated[0]);
                this.kex.init(this, this.serverVersion.getBytes(), this.clientVersion.getBytes(), this.I_S, this.I_C);
                break;
            }
            case 21: {
                this.log.debug("Received SSH_MSG_NEWKEYS");
                if (this.kexState.get() != 3) {
                    throw new IllegalStateException("Received command " + cmd + " before key exchange is finished");
                }
                this.receiveNewKeys();
                if (this.reexchangeFuture != null) {
                    this.reexchangeFuture.setValue(true);
                }
                this.sendEvent(SessionListener.Event.KeyEstablished);
                Object object = this.pendingPackets;
                synchronized (object) {
                    if (!this.pendingPackets.isEmpty()) {
                        this.log.info("Dequeing pending packets");
                        Object object2 = this.encodeLock;
                        synchronized (object2) {
                            PendingWriteFuture future;
                            while ((future = this.pendingPackets.poll()) != null) {
                                this.doWritePacket(future.getBuffer()).addListener(future);
                            }
                        }
                    }
                    this.kexState.set(4);
                }
                object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                    break;
                }
            }
            default: {
                if (cmd >= 30 && cmd <= 49) {
                    if (this.kexState.get() != 2) {
                        throw new IllegalStateException("Received kex command " + cmd + " while not in key exchange");
                    }
                    buffer.rpos(buffer.rpos() - 1);
                    if (!this.kex.next(buffer)) break;
                    this.checkKeys();
                    this.sendNewKeys();
                    this.kexState.set(3);
                    break;
                }
                if (this.currentService != null) {
                    this.currentService.process(cmd, buffer);
                    this.resetIdleTimeout();
                    break;
                }
                throw new IllegalStateException("Unsupported command " + cmd);
            }
        }
        this.checkRekey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(Throwable t) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state.get() != 0) {
                return;
            }
        }
        this.log.warn("Exception caught", t);
        try {
            int code;
            if (t instanceof SshException && (code = ((SshException)t).getDisconnectCode()) > 0) {
                this.disconnect(code, t.getMessage());
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.close(true);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return CloseableUtils.sequential(this.lock, CloseableUtils.parallel(this.lock, (Closeable[])this.getServices()), this.ioSession);
    }

    @Override
    protected void postClose() {
        super.postClose();
        ArrayList<SessionListener> l = new ArrayList<SessionListener>(this.listeners);
        for (SessionListener sl : l) {
            sl.sessionClosed(this);
        }
    }

    protected Service[] getServices() {
        Service[] serviceArray;
        if (this.currentService != null) {
            Service[] serviceArray2 = new Service[1];
            serviceArray = serviceArray2;
            serviceArray2[0] = this.currentService;
        } else {
            serviceArray = new Service[]{};
        }
        return serviceArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoWriteFuture writePacket(Buffer buffer) throws IOException {
        byte cmd;
        if (this.kexState.get() != 4 && (cmd = buffer.array()[buffer.rpos()]) > 49) {
            Queue<PendingWriteFuture> queue = this.pendingPackets;
            synchronized (queue) {
                if (this.kexState.get() != 4) {
                    if (this.pendingPackets.isEmpty()) {
                        this.log.info("Start flagging packets as pending until key exchange is done");
                    }
                    PendingWriteFuture future = new PendingWriteFuture(buffer);
                    this.pendingPackets.add(future);
                    return future;
                }
            }
        }
        try {
            IoWriteFuture ioWriteFuture = this.doWritePacket(buffer);
            return ioWriteFuture;
        }
        finally {
            this.resetIdleTimeout();
            this.checkRekey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IoWriteFuture doWritePacket(Buffer buffer) throws IOException {
        Object object = this.encodeLock;
        synchronized (object) {
            this.encode(buffer);
            return this.ioSession.write(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer request(Buffer buffer) throws IOException {
        Object object = this.requestLock;
        synchronized (object) {
            try {
                AtomicReference<Buffer> atomicReference = this.requestResult;
                synchronized (atomicReference) {
                    this.writePacket(buffer);
                    this.requestResult.wait();
                    return this.requestResult.get();
                }
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
        }
    }

    @Override
    public Buffer createBuffer(byte cmd) {
        return this.createBuffer(cmd, 0);
    }

    @Override
    public Buffer createBuffer(byte cmd, int len) {
        Buffer buffer;
        if (len <= 0) {
            buffer = new Buffer();
        } else {
            int bsize = this.outCipherSize;
            int pad = -(len += 5) & bsize - 1;
            if (pad < bsize) {
                pad += bsize;
            }
            len = len + pad - 4;
            if (this.outMac != null) {
                len += this.outMac.getBlockSize();
            }
            buffer = new Buffer(new byte[Math.max(len, 256)], false);
        }
        buffer.rpos(5);
        buffer.wpos(5);
        buffer.putByte(cmd);
        return buffer;
    }

    private void encode(Buffer buffer) throws IOException {
        try {
            if (buffer.rpos() < 5) {
                this.log.warn("Performance cost: when sending a packet, ensure that 5 bytes are available in front of the buffer");
                Buffer nb = new Buffer();
                nb.wpos(5);
                nb.putBuffer(buffer);
                buffer = nb;
            }
            int len = buffer.available();
            int off = buffer.rpos() - 5;
            if (this.log.isTraceEnabled()) {
                this.log.trace("Sending packet #{}: {}", (Object)this.seqo, (Object)buffer.printHex());
            }
            if (this.outCompression != null && (this.authed || !this.outCompression.isDelayed())) {
                this.outCompression.compress(buffer);
                len = buffer.available();
            }
            int bsize = this.outCipherSize;
            int oldLen = len;
            int pad = -(len += 5) & bsize - 1;
            if (pad < bsize) {
                pad += bsize;
            }
            len = len + pad - 4;
            buffer.wpos(off);
            buffer.putInt(len);
            buffer.putByte((byte)pad);
            buffer.wpos(off + oldLen + 5 + pad);
            this.random.fill(buffer.array(), buffer.wpos() - pad, pad);
            if (this.outMac != null) {
                int macSize = this.outMac.getBlockSize();
                int l = buffer.wpos();
                buffer.wpos(l + macSize);
                this.outMac.updateUInt(this.seqo);
                this.outMac.update(buffer.array(), off, l);
                this.outMac.doFinal(buffer.array(), l);
            }
            if (this.outCipher != null) {
                this.outCipher.update(buffer.array(), off, len + 4);
            }
            this.seqo = this.seqo + 1L & 0xFFFFFFFFL;
            ++this.outPackets;
            this.outBytes += (long)len;
            buffer.rpos(off);
        }
        catch (SshException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    protected void decode() throws Exception {
        while (true) {
            Buffer buf;
            int macSize;
            if (this.decoderState == 0) {
                assert (this.decoderBuffer.rpos() == 0);
                if (this.decoderBuffer.available() <= this.inCipherSize) break;
                if (this.inCipher != null) {
                    this.inCipher.update(this.decoderBuffer.array(), 0, this.inCipherSize);
                }
                this.decoderLength = this.decoderBuffer.getInt();
                if (this.decoderLength < 5 || this.decoderLength > 262144) {
                    this.log.info("Error decoding packet (invalid length) {}", (Object)this.decoderBuffer.printHex());
                    throw new SshException(2, "Invalid packet length: " + this.decoderLength);
                }
                this.decoderState = 1;
                continue;
            }
            if (this.decoderState != 1) continue;
            assert (this.decoderBuffer.rpos() == 4);
            int n = macSize = this.inMac != null ? this.inMac.getBlockSize() : 0;
            if (this.decoderBuffer.available() < this.decoderLength + macSize) break;
            byte[] data = this.decoderBuffer.array();
            if (this.inCipher != null) {
                this.inCipher.update(data, this.inCipherSize, this.decoderLength + 4 - this.inCipherSize);
            }
            if (this.inMac != null) {
                this.inMac.updateUInt(this.seqi);
                this.inMac.update(data, 0, this.decoderLength + 4);
                this.inMac.doFinal(this.inMacResult, 0);
                if (!BufferUtils.equals(this.inMacResult, 0, data, this.decoderLength + 4, macSize)) {
                    throw new SshException(5, "MAC Error");
                }
            }
            this.seqi = this.seqi + 1L & 0xFFFFFFFFL;
            byte pad = this.decoderBuffer.getByte();
            int wpos = this.decoderBuffer.wpos();
            if (this.inCompression != null && (this.authed || !this.inCompression.isDelayed())) {
                if (this.uncompressBuffer == null) {
                    this.uncompressBuffer = new Buffer();
                } else {
                    this.uncompressBuffer.clear();
                }
                this.decoderBuffer.wpos(this.decoderBuffer.rpos() + this.decoderLength - 1 - pad);
                this.inCompression.uncompress(this.decoderBuffer, this.uncompressBuffer);
                buf = this.uncompressBuffer;
            } else {
                this.decoderBuffer.wpos(this.decoderLength + 4 - pad);
                buf = this.decoderBuffer;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received packet #{}: {}", (Object)this.seqi, (Object)buf.printHex());
            }
            ++this.inPackets;
            this.inBytes += (long)buf.available();
            this.handleMessage(buf);
            this.decoderBuffer.rpos(this.decoderLength + 4 + macSize);
            this.decoderBuffer.wpos(wpos);
            this.decoderBuffer.compact();
            this.decoderState = 0;
        }
    }

    protected void sendIdentification(String ident) {
        byte[] data = (ident + "\r\n").getBytes();
        this.ioSession.write(new Buffer(data));
    }

    protected abstract boolean readIdentification(Buffer var1) throws IOException;

    protected String doReadIdentification(Buffer buffer) {
        byte[] data = new byte[256];
        do {
            int rpos = buffer.rpos();
            int pos = 0;
            boolean needLf = false;
            while (true) {
                if (buffer.available() == 0) {
                    buffer.rpos(rpos);
                    return null;
                }
                byte b = buffer.getByte();
                if (b == 13) {
                    needLf = true;
                    continue;
                }
                if (b == 10) break;
                if (needLf) {
                    throw new IllegalStateException("Incorrect identification: bad line ending");
                }
                if (pos >= data.length) {
                    throw new IllegalStateException("Incorrect identification: line too long");
                }
                data[pos++] = b;
            }
            String str = new String(data, 0, pos);
            if (!str.startsWith("SSH-")) continue;
            return str;
        } while (buffer.rpos() <= 16384);
        throw new IllegalStateException("Incorrect identification: too many header lines");
    }

    protected String[] createProposal(String hostKeyTypes) {
        return new String[]{NamedFactory.Utils.getNames(this.factoryManager.getKeyExchangeFactories()), hostKeyTypes, NamedFactory.Utils.getNames(this.factoryManager.getCipherFactories()), NamedFactory.Utils.getNames(this.factoryManager.getCipherFactories()), NamedFactory.Utils.getNames(this.factoryManager.getMacFactories()), NamedFactory.Utils.getNames(this.factoryManager.getMacFactories()), NamedFactory.Utils.getNames(this.factoryManager.getCompressionFactories()), NamedFactory.Utils.getNames(this.factoryManager.getCompressionFactories()), "", ""};
    }

    protected byte[] sendKexInit(String[] proposal) throws IOException {
        this.log.debug("Send SSH_MSG_KEXINIT");
        Buffer buffer = this.createBuffer((byte)20);
        int p = buffer.wpos();
        buffer.wpos(p + 16);
        this.random.fill(buffer.array(), p, 16);
        for (String s : proposal) {
            buffer.putString(s);
        }
        buffer.putByte((byte)0);
        buffer.putInt(0L);
        byte[] data = buffer.getCompactData();
        this.writePacket(buffer);
        return data;
    }

    protected byte[] receiveKexInit(Buffer buffer, String[] proposal) {
        int size = 22;
        byte[] d = buffer.array();
        byte[] data = new byte[buffer.available() + 1];
        data[0] = 20;
        System.arraycopy(d, buffer.rpos(), data, 1, data.length - 1);
        buffer.rpos(buffer.rpos() + 16);
        for (int i = 0; i < proposal.length; ++i) {
            size += 4;
            proposal[i] = buffer.getString();
            size += proposal[i].length();
        }
        buffer.getByte();
        buffer.getInt();
        byte[] dataShrinked = new byte[size];
        System.arraycopy(data, 0, dataShrinked, 0, size);
        return dataShrinked;
    }

    protected void sendNewKeys() throws IOException {
        this.log.debug("Send SSH_MSG_NEWKEYS");
        Buffer buffer = this.createBuffer((byte)21);
        this.writePacket(buffer);
    }

    protected void receiveNewKeys() throws Exception {
        int j;
        byte[] K = this.kex.getK();
        byte[] H = this.kex.getH();
        Digest hash = this.kex.getHash();
        if (this.sessionId == null) {
            this.sessionId = new byte[H.length];
            System.arraycopy(H, 0, this.sessionId, 0, H.length);
        }
        Buffer buffer = new Buffer();
        buffer.putMPInt(K);
        buffer.putRawBytes(H);
        buffer.putByte((byte)65);
        buffer.putRawBytes(this.sessionId);
        int pos = buffer.available();
        byte[] buf = buffer.array();
        hash.update(buf, 0, pos);
        byte[] IVc2s = hash.digest();
        int n = j = pos - this.sessionId.length - 1;
        buf[n] = (byte)(buf[n] + 1);
        hash.update(buf, 0, pos);
        byte[] IVs2c = hash.digest();
        int n2 = j;
        buf[n2] = (byte)(buf[n2] + 1);
        hash.update(buf, 0, pos);
        byte[] Ec2s = hash.digest();
        int n3 = j;
        buf[n3] = (byte)(buf[n3] + 1);
        hash.update(buf, 0, pos);
        byte[] Es2c = hash.digest();
        int n4 = j;
        buf[n4] = (byte)(buf[n4] + 1);
        hash.update(buf, 0, pos);
        byte[] MACc2s = hash.digest();
        int n5 = j;
        buf[n5] = (byte)(buf[n5] + 1);
        hash.update(buf, 0, pos);
        byte[] MACs2c = hash.digest();
        Cipher s2ccipher = (Cipher)NamedFactory.Utils.create(this.factoryManager.getCipherFactories(), this.negotiated[3]);
        Es2c = this.resizeKey(Es2c, s2ccipher.getBlockSize(), hash, K, H);
        s2ccipher.init(this.isServer ? Cipher.Mode.Encrypt : Cipher.Mode.Decrypt, Es2c, IVs2c);
        Mac s2cmac = (Mac)NamedFactory.Utils.create(this.factoryManager.getMacFactories(), this.negotiated[5]);
        MACs2c = this.resizeKey(MACs2c, s2cmac.getBlockSize(), hash, K, H);
        s2cmac.init(MACs2c);
        Cipher c2scipher = (Cipher)NamedFactory.Utils.create(this.factoryManager.getCipherFactories(), this.negotiated[2]);
        Ec2s = this.resizeKey(Ec2s, c2scipher.getBlockSize(), hash, K, H);
        c2scipher.init(this.isServer ? Cipher.Mode.Decrypt : Cipher.Mode.Encrypt, Ec2s, IVc2s);
        Mac c2smac = (Mac)NamedFactory.Utils.create(this.factoryManager.getMacFactories(), this.negotiated[4]);
        MACc2s = this.resizeKey(MACc2s, c2smac.getBlockSize(), hash, K, H);
        c2smac.init(MACc2s);
        Compression s2ccomp = (Compression)NamedFactory.Utils.create(this.factoryManager.getCompressionFactories(), this.negotiated[7]);
        Compression c2scomp = (Compression)NamedFactory.Utils.create(this.factoryManager.getCompressionFactories(), this.negotiated[6]);
        if (this.isServer) {
            this.outCipher = s2ccipher;
            this.outMac = s2cmac;
            this.outCompression = s2ccomp;
            this.inCipher = c2scipher;
            this.inMac = c2smac;
            this.inCompression = c2scomp;
        } else {
            this.outCipher = c2scipher;
            this.outMac = c2smac;
            this.outCompression = c2scomp;
            this.inCipher = s2ccipher;
            this.inMac = s2cmac;
            this.inCompression = s2ccomp;
        }
        this.outCipherSize = this.outCipher.getIVSize();
        if (this.outCompression != null) {
            this.outCompression.init(Compression.Type.Deflater, -1);
        }
        this.inCipherSize = this.inCipher.getIVSize();
        this.inMacResult = new byte[this.inMac.getBlockSize()];
        if (this.inCompression != null) {
            this.inCompression.init(Compression.Type.Inflater, -1);
        }
        this.inBytes = 0L;
        this.outBytes = 0L;
        this.inPackets = 0L;
        this.outPackets = 0L;
        this.lastKeyTime = System.currentTimeMillis();
    }

    private byte[] resizeKey(byte[] E, int blockSize, Digest hash, byte[] K, byte[] H) throws Exception {
        while (blockSize > E.length) {
            Buffer buffer = new Buffer();
            buffer.putMPInt(K);
            buffer.putRawBytes(H);
            buffer.putRawBytes(E);
            hash.update(buffer.array(), 0, buffer.available());
            byte[] foo = hash.digest();
            byte[] bar = new byte[E.length + foo.length];
            System.arraycopy(E, 0, bar, 0, E.length);
            System.arraycopy(foo, 0, bar, E.length, foo.length);
            E = bar;
        }
        return E;
    }

    public void disconnect(int reason, String msg) throws IOException {
        this.log.info("Disconnecting: {}", (Object)msg);
        Buffer buffer = this.createBuffer((byte)1);
        buffer.putInt(reason);
        buffer.putString(msg);
        buffer.putString("");
        this.writePacket(buffer).addListener(new SshFutureListener<IoWriteFuture>(){

            @Override
            public void operationComplete(IoWriteFuture future) {
                AbstractSession.this.close(true);
            }
        });
    }

    protected void notImplemented() throws IOException {
        Buffer buffer = this.createBuffer((byte)3);
        buffer.putInt(this.seqi - 1L);
        this.writePacket(buffer);
    }

    protected void negotiate() {
        String[] guess = new String[10];
        for (int i = 0; i < 10; ++i) {
            String[] c = this.clientProposal[i].split(",");
            String[] s = this.serverProposal[i].split(",");
            for (String ci : c) {
                for (String si : s) {
                    if (!ci.equals(si)) continue;
                    guess[i] = ci;
                    break;
                }
                if (guess[i] != null) break;
            }
            if (guess[i] != null || i == 8 || i == 9) continue;
            String[] items = new String[]{"kex algorithms", "server host key algorithms", "encryption algorithms (client to server)", "encryption algorithms (server to client)", "mac algorithms (client to server)", "mac algorithms (server to client)", "compression algorithms (client to server)", "compression algorithms (server to client)"};
            throw new IllegalStateException("Unable to negotiate key exchange for " + items[i] + " (client: " + this.clientProposal[i] + " / server: " + this.serverProposal[i] + ")");
        }
        this.negotiated = guess;
        this.log.info("Kex: server->client {} {} {}", new Object[]{this.negotiated[3], this.negotiated[5], this.negotiated[7]});
        this.log.info("Kex: client->server {} {} {}", new Object[]{this.negotiated[2], this.negotiated[4], this.negotiated[6]});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestSuccess(Buffer buffer) throws Exception {
        AtomicReference<Buffer> atomicReference = this.requestResult;
        synchronized (atomicReference) {
            this.requestResult.set(new Buffer(buffer.getCompactData()));
            this.requestResult.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestFailure(Buffer buffer) throws Exception {
        AtomicReference<Buffer> atomicReference = this.requestResult;
        synchronized (atomicReference) {
            this.requestResult.set(null);
            this.requestResult.notify();
        }
    }

    @Override
    public int getIntProperty(String name, int defaultValue) {
        try {
            String v = this.factoryManager.getProperties().get(name);
            if (v != null) {
                return Integer.parseInt(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public long getLongProperty(String name, long defaultValue) {
        try {
            String v = this.factoryManager.getProperties().get(name);
            if (v != null) {
                return Long.parseLong(v);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return defaultValue;
    }

    @Override
    public <T> T getAttribute(Session.AttributeKey<T> key) {
        return (T)this.attributes.get(key);
    }

    @Override
    public <T, E extends T> T setAttribute(Session.AttributeKey<T> key, E value) {
        return (T)this.attributes.put(key, value);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public Object getLock() {
        return this.lock;
    }

    @Override
    public void addListener(SessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(SessionListener listener) {
        this.listeners.remove(listener);
    }

    protected void sendEvent(SessionListener.Event event) throws IOException {
        for (SessionListener sl : this.listeners) {
            sl.sessionEvent(this, event);
        }
    }

    @Override
    public SshFuture reExchangeKeys() throws IOException {
        if (this.kexState.compareAndSet(4, 1)) {
            this.log.info("Initiating key re-exchange");
            this.sendKexInit();
            this.reexchangeFuture = new DefaultSshFuture(null);
        }
        return this.reexchangeFuture;
    }

    protected void checkRekey() throws IOException {
    }

    protected abstract void sendKexInit() throws IOException;

    protected abstract void checkKeys() throws IOException;

    protected abstract void receiveKexInit(Buffer var1) throws IOException;

    protected void serviceAccept() throws IOException {
    }

    public abstract void startService(String var1) throws Exception;

    public abstract void resetIdleTimeout();

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getUsername() + "@" + this.getIoSession().getRemoteAddress() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PendingWriteFuture
    extends DefaultSshFuture<IoWriteFuture>
    implements IoWriteFuture,
    SshFutureListener<IoWriteFuture> {
        private final Buffer buffer;

        protected PendingWriteFuture(Buffer buffer) {
            super(null);
            this.buffer = buffer;
        }

        public Buffer getBuffer() {
            return this.buffer;
        }

        @Override
        public boolean isWritten() {
            return this.getValue() instanceof Boolean;
        }

        @Override
        public Throwable getException() {
            Object v = this.getValue();
            return v instanceof Throwable ? (Throwable)v : null;
        }

        @Override
        public void setWritten() {
            this.setValue(Boolean.TRUE);
        }

        @Override
        public void setException(Throwable cause) {
            if (cause == null) {
                throw new IllegalArgumentException();
            }
            this.setValue(cause);
        }

        @Override
        public void operationComplete(IoWriteFuture future) {
            if (future.isWritten()) {
                this.setWritten();
            } else {
                future.setException(future.getException());
            }
        }
    }
}

