/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka;

import com.google.common.base.Objects;
import java.io.Serializable;

public class Broker
implements Serializable,
Comparable<Broker> {
    public final String host;
    public final int port;

    public Broker(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public Broker(String host) {
        this(host, 9092);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.host, this.port});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Broker other = (Broker)obj;
        return Objects.equal((Object)this.host, (Object)other.host) && Objects.equal((Object)this.port, (Object)other.port);
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public static Broker fromString(String host) {
        Broker hp;
        String[] spec = host.split(":");
        if (spec.length == 1) {
            hp = new Broker(spec[0]);
        } else if (spec.length == 2) {
            hp = new Broker(spec[0], Integer.parseInt(spec[1]));
        } else {
            throw new IllegalArgumentException("Invalid host specification: " + host);
        }
        return hp;
    }

    @Override
    public int compareTo(Broker o) {
        if (this.host.equals(o.host)) {
            return this.port - o.port;
        }
        return this.host.compareTo(o.host);
    }
}

