/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.processor;

import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.crypto.AlgorithmSuite;
import org.apache.wss4j.common.crypto.AlgorithmSuiteValidator;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.SAMLTokenPrincipalImpl;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.Validator;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLTokenProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLTokenProcessor.class);
    private XMLSignatureFactory signatureFactory;

    public SAMLTokenProcessor() {
        try {
            this.signatureFactory = XMLSignatureFactory.getInstance("DOM", "ApacheXMLDSig");
        }
        catch (NoSuchProviderException ex) {
            this.signatureFactory = XMLSignatureFactory.getInstance("DOM");
        }
    }

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        String id;
        Element foundElement;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found SAML Assertion element");
        }
        Validator validator = data.getValidator(new QName(elem.getNamespaceURI(), elem.getLocalName()));
        Credential credential = this.handleSAMLToken(elem, data, validator, wsDocInfo);
        SamlAssertionWrapper samlAssertion = credential.getSamlAssertion();
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML Assertion issuer " + samlAssertion.getIssuerString());
            LOG.debug(DOM2Writer.nodeToString((Node)elem));
        }
        if (elem.equals(foundElement = wsDocInfo.getTokenElement(id = samlAssertion.getId()))) {
            WSSecurityEngineResult result = wsDocInfo.getResult(id);
            return Collections.singletonList(result);
        }
        if (foundElement != null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "duplicateError", new Object[0]);
        }
        wsDocInfo.addTokenElement(elem);
        WSSecurityEngineResult result = null;
        result = samlAssertion.isSigned() ? new WSSecurityEngineResult(16, samlAssertion) : new WSSecurityEngineResult(8, samlAssertion);
        result.put("id", samlAssertion.getId());
        if (validator != null) {
            result.put("validated-token", Boolean.TRUE);
            if (credential.getTransformedToken() != null) {
                result.put("transformed-token", credential.getTransformedToken());
                if (credential.getPrincipal() != null) {
                    result.put("principal", credential.getPrincipal());
                } else {
                    SAMLTokenPrincipalImpl samlPrincipal = new SAMLTokenPrincipalImpl(credential.getTransformedToken());
                    result.put("principal", samlPrincipal);
                }
            } else if (credential.getPrincipal() != null) {
                result.put("principal", credential.getPrincipal());
            } else {
                result.put("principal", new SAMLTokenPrincipalImpl(samlAssertion));
            }
            result.put("subject", credential.getSubject());
        }
        wsDocInfo.addResult(result);
        return Collections.singletonList(result);
    }

    public Credential handleSAMLToken(Element token, RequestData data, Validator validator, WSDocInfo docInfo) throws WSSecurityException {
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(token);
        if (samlAssertion.isSigned()) {
            AlgorithmSuite algorithmSuite = data.getSamlAlgorithmSuite();
            Signature sig = samlAssertion.getSignature();
            KeyInfo keyInfo = sig.getKeyInfo();
            if (keyInfo == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key"});
            }
            SAMLKeyInfo samlKeyInfo = SAMLUtil.getCredentialFromKeyInfo((Element)keyInfo.getDOM(), (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(data, docInfo), (Crypto)data.getSigVerCrypto());
            if (algorithmSuite != null) {
                XMLSignature xmlSignature;
                AlgorithmSuiteValidator algorithmSuiteValidator = new AlgorithmSuiteValidator(algorithmSuite);
                PublicKey key = null;
                if (samlKeyInfo.getCerts() != null && samlKeyInfo.getCerts()[0] != null) {
                    key = samlKeyInfo.getCerts()[0].getPublicKey();
                } else if (samlKeyInfo.getPublicKey() != null) {
                    key = samlKeyInfo.getPublicKey();
                } else {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key"});
                }
                DOMValidateContext context = new DOMValidateContext(key, (Node)sig.getDOM());
                context.setProperty("org.apache.jcp.xml.dsig.secureValidation", Boolean.TRUE);
                context.setProperty("org.jcp.xml.dsig.secureValidation", Boolean.TRUE);
                try {
                    xmlSignature = this.signatureFactory.unmarshalXMLSignature(context);
                }
                catch (MarshalException ex) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "invalidSAMLsecurity", (Exception)ex, new Object[]{"cannot get certificate or key"});
                }
                algorithmSuiteValidator.checkSignatureAlgorithms(xmlSignature);
                algorithmSuiteValidator.checkAsymmetricKeyLength(key);
            }
            samlAssertion.verifySignature(samlKeyInfo);
        }
        samlAssertion.parseSubject((SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(data, docInfo), data.getSigVerCrypto(), data.getCallbackHandler());
        Credential credential = new Credential();
        credential.setSamlAssertion(samlAssertion);
        if (validator != null) {
            return validator.validate(credential, data);
        }
        return credential;
    }
}

