/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler;

import org.aspectj.ajdt.internal.compiler.CommonPrinter;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeFieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;

class ITDFieldPrinter
extends CommonPrinter {
    private InterTypeFieldDeclaration fieldDeclaration;

    ITDFieldPrinter(InterTypeFieldDeclaration fieldDeclaration, MethodScope methodscope) {
        super(methodscope);
        this.output = new StringBuilder();
        this.fieldDeclaration = fieldDeclaration;
    }

    public String print() {
        return this.print(2);
    }

    public String print(int tab) {
        this.output = new StringBuilder();
        if (this.fieldDeclaration.javadoc != null) {
            // empty if block
        }
        this.printIndent(tab);
        if (this.fieldDeclaration.annotations != null) {
            this.printAnnotations(this.fieldDeclaration.annotations);
        }
        this.printModifiers(this.fieldDeclaration.declaredModifiers);
        TypeParameter[] typeParams = this.fieldDeclaration.typeParameters();
        if (typeParams != null) {
            this.output.append('<');
            int max = typeParams.length - 1;
            for (int j = 0; j < max; ++j) {
                this.printTypeParameter(typeParams[j]);
                this.output.append(", ");
            }
            this.printTypeParameter(typeParams[max]);
            this.output.append('>');
        }
        this.printReturnType(0).append(this.fieldDeclaration.getDeclaredSelector());
        if (this.fieldDeclaration.initialization != null) {
            this.output.append(" = ");
            this.printExpression(this.fieldDeclaration.initialization);
        }
        this.output.append(';');
        return this.output.toString();
    }

    public StringBuilder printReturnType(int indent) {
        if (this.fieldDeclaration.returnType == null) {
            return this.output;
        }
        return this.printExpression(this.fieldDeclaration.returnType).append(' ');
    }
}

