/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCompound;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;

public class StatementSimple
extends Statement {
    String sqlState;
    HsqlNameManager.HsqlName label;
    ColumnSchema[] variables;
    int[] variableIndexes;

    StatementSimple(int n, HsqlNameManager.HsqlName hsqlName) {
        super(n, 2007);
        this.references = new OrderedHashSet();
        this.isTransactionStatement = false;
        this.label = hsqlName;
    }

    StatementSimple(int n, String string) {
        super(n, 2007);
        this.references = new OrderedHashSet();
        this.isTransactionStatement = false;
        this.sqlState = string;
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 92: {
                stringBuffer.append("SIGNAL");
                break;
            }
            case 91: {
                stringBuffer.append("RESIGNAL");
                break;
            }
            case 102: {
                stringBuffer.append("ITERATE").append(' ').append(this.label);
                break;
            }
            case 89: {
                stringBuffer.append("LEAVE").append(' ').append(this.label);
            }
        }
        return stringBuffer.toString();
    }

    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("STATEMENT");
        return stringBuffer.toString();
    }

    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    Result getResult(Session session) {
        switch (this.type) {
            case 91: 
            case 92: {
                HsqlException hsqlException = Error.error("sql routine error", this.sqlState, -1);
                return Result.newErrorResult(hsqlException);
            }
            case 89: 
            case 102: {
                return Result.newPSMResult(this.type, this.label.name, null);
            }
        }
        throw Error.runtimeError(201, "");
    }

    public void resolve(Session session) {
        boolean bl = false;
        block0 : switch (this.type) {
            case 91: 
            case 92: {
                bl = true;
                break;
            }
            case 102: {
                StatementCompound statementCompound = this.parent;
                while (statementCompound != null) {
                    if (statementCompound.isLoop) {
                        if (this.label == null) {
                            bl = true;
                            break block0;
                        }
                        if (statementCompound.label != null && this.label.name.equals(statementCompound.label.name)) {
                            bl = true;
                            break block0;
                        }
                    }
                    statementCompound = statementCompound.parent;
                }
                break;
            }
            case 89: {
                bl = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "");
            }
        }
        if (!bl) {
            throw Error.error(5602);
        }
    }

    public String describe(Session session) {
        return "";
    }

    public boolean isCatalogChange() {
        return false;
    }
}

