/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.BlobInputStream;
import org.hsqldb.jdbc.Util;
import org.hsqldb.types.BlobDataID;

public class JDBCBlobClient
implements Blob {
    BlobDataID blob;
    SessionInterface session;
    boolean isClosed;

    public synchronized long length() throws SQLException {
        try {
            return this.blob.length(this.session);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized byte[] getBytes(long l, int n) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l - 1L, n)) {
            throw Util.outOfRangeArgument();
        }
        try {
            return this.blob.getBytes(this.session, l - 1L, n);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized InputStream getBinaryStream() throws SQLException {
        return new BlobInputStream(this, 0L, this.length(), this.session.getStreamBlockSize());
    }

    public synchronized long position(byte[] byArray, long l) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l, 0L)) {
            throw Util.outOfRangeArgument();
        }
        try {
            return this.blob.position(this.session, byArray, l - 1L);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized long position(Blob blob, long l) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Integer.MAX_VALUE, 0L, blob.length())) {
            throw Util.outOfRangeArgument();
        }
        byte[] byArray = blob.getBytes(1L, (int)blob.length());
        return this.position(byArray, l);
    }

    public synchronized int setBytes(long l, byte[] byArray) throws SQLException {
        throw Util.notSupported();
    }

    public synchronized int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        throw Util.notSupported();
    }

    public synchronized OutputStream setBinaryStream(long l) throws SQLException {
        throw Util.notSupported();
    }

    public synchronized void truncate(long l) throws SQLException {
        try {
            this.blob.truncate(this.session, l);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized void free() throws SQLException {
        this.isClosed = true;
    }

    public synchronized InputStream getBinaryStream(long l, long l2) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l - 1L, l2)) {
            throw Util.outOfRangeArgument();
        }
        return new BlobInputStream(this, l - 1L, l2, this.session.getStreamBlockSize());
    }

    JDBCBlobClient(SessionInterface sessionInterface, BlobDataID blobDataID) {
        this.session = sessionInterface;
        this.blob = blobDataID;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw Util.sqlException(1251);
        }
    }

    static boolean isInLimits(long l, long l2, long l3) {
        return l2 >= 0L && l3 >= 0L && l2 + l3 <= l;
    }
}

