/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Component;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class GridSwing
extends AbstractTableModel {
    JTable jtable = null;
    Object[] headers = new Object[0];
    Vector rows = new Vector();

    public String getColumnName(int n) {
        return this.headers[n].toString();
    }

    public Class getColumnClass(int n) {
        Object object;
        if (this.rows.size() > 0 && (object = this.getValueAt(0, n)) != null) {
            if (object instanceof Timestamp || object instanceof Time) {
                return Object.class;
            }
            return object.getClass();
        }
        return super.getColumnClass(n);
    }

    public int getColumnCount() {
        return this.headers.length;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object[] getHead() {
        return this.headers;
    }

    public Vector getData() {
        return this.rows;
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.rows.size()) {
            return null;
        }
        Object[] objectArray = (Object[])this.rows.elementAt(n);
        if (n2 >= objectArray.length) {
            return null;
        }
        return objectArray[n2];
    }

    public void setHead(Object[] objectArray) {
        this.headers = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.headers[i] = objectArray[i];
        }
    }

    public void addRow(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = objectArray[i];
            if (objectArray2[i] != null) continue;
        }
        this.rows.addElement(objectArray2);
    }

    public void clear() {
        this.rows.removeAllElements();
    }

    public void setJTable(JTable jTable) {
        this.jtable = jTable;
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        super.fireTableChanged(tableModelEvent);
        GridSwing.autoSizeTableColumns(this.jtable);
    }

    public static void autoSizeTableColumns(JTable jTable) {
        TableModel tableModel = jTable.getModel();
        TableColumn tableColumn = null;
        Component component = null;
        int n = 0;
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, 0);
            n = component.getPreferredSize().width + 10;
            n2 = Integer.MIN_VALUE;
            for (int j = 0; j < Math.min(tableModel.getRowCount(), 30); ++j) {
                TableCellRenderer tableCellRenderer2 = jTable.getCellRenderer(j, i);
                component = tableCellRenderer2.getTableCellRendererComponent(jTable, tableModel.getValueAt(j, i), false, false, j, i);
                n3 = component.getPreferredSize().width;
                if (n3 < n2) continue;
                n2 = n3;
            }
            tableColumn.setPreferredWidth(Math.max(n, n2) + 10);
        }
    }
}

