/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.authentication;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.authentication.SimplePrincipal;
import org.jasig.cas.client.proxy.ProxyRetriever;
import org.jasig.cas.client.util.CommonUtils;

public class AttributePrincipalImpl
extends SimplePrincipal
implements AttributePrincipal {
    private static final Log LOG = LogFactory.getLog((Class)AttributePrincipalImpl.class);
    private static final long serialVersionUID = -1443182634624927187L;
    private final Map attributes;
    private final String proxyGrantingTicket;
    private final ProxyRetriever proxyRetriever;

    public AttributePrincipalImpl(String name) {
        this(name, Collections.EMPTY_MAP);
    }

    public AttributePrincipalImpl(String name, Map attributes) {
        this(name, attributes, null, null);
    }

    public AttributePrincipalImpl(String name, String proxyGrantingTicket, ProxyRetriever proxyRetriever) {
        this(name, Collections.EMPTY_MAP, proxyGrantingTicket, proxyRetriever);
    }

    public AttributePrincipalImpl(String name, Map attributes, String proxyGrantingTicket, ProxyRetriever proxyRetriever) {
        super(name);
        this.attributes = attributes;
        this.proxyGrantingTicket = proxyGrantingTicket;
        this.proxyRetriever = proxyRetriever;
        CommonUtils.assertNotNull(this.attributes, "attributes cannot be null.");
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String getProxyTicketFor(String service) {
        if (this.proxyGrantingTicket != null) {
            return this.proxyRetriever.getProxyTicketIdFor(this.proxyGrantingTicket, service);
        }
        LOG.debug((Object)"No ProxyGrantingTicket was supplied, so no Proxy Ticket can be retrieved.");
        return null;
    }
}

