/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.jaas;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.authentication.SimpleGroup;
import org.jasig.cas.client.authentication.SimplePrincipal;
import org.jasig.cas.client.jaas.AssertionPrincipal;
import org.jasig.cas.client.jaas.TicketCredential;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidator;

public class CasLoginModule
implements LoginModule {
    public static final String LOGIN_NAME = "javax.security.auth.login.name";
    public static final String DEFAULT_PRINCIPAL_GROUP_NAME = "CallerPrincipal";
    public static final String DEFAULT_ROLE_GROUP_NAME = "Roles";
    public static final int DEFAULT_CACHE_TIMEOUT = 480;
    protected static final Map ASSERTION_CACHE = new HashMap();
    protected static Executor cacheCleanerExecutor = Executors.newSingleThreadExecutor();
    protected final Log log = LogFactory.getLog(this.getClass());
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected TicketValidator ticketValidator;
    protected String service;
    protected Assertion assertion;
    protected TicketCredential ticket;
    protected Map sharedState;
    protected String[] defaultRoles;
    protected Set roleAttributeNames = new HashSet();
    protected String principalGroupName = "CallerPrincipal";
    protected String roleGroupName = "Roles";
    protected boolean cacheAssertions;
    protected int cacheTimeout;

    public void initialize(Subject subject, CallbackHandler handler, Map state, Map options) {
        this.assertion = null;
        this.callbackHandler = handler;
        this.subject = subject;
        this.sharedState = state;
        String ticketValidatorClass = null;
        Iterator iter = options.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            this.log.trace((Object)("Processing option " + key));
            if ("service".equals(key)) {
                this.service = (String)options.get(key);
                this.log.debug((Object)("Set service=" + this.service));
                continue;
            }
            if ("ticketValidatorClass".equals(key)) {
                ticketValidatorClass = (String)options.get(key);
                this.log.debug((Object)("Set ticketValidatorClass=" + ticketValidatorClass));
                continue;
            }
            if ("defaultRoles".equals(key)) {
                String roles = (String)options.get(key);
                this.log.trace((Object)("Got defaultRoles value " + roles));
                this.defaultRoles = roles.split(",\\s*");
                this.log.debug((Object)("Set defaultRoles=" + Arrays.asList(this.defaultRoles)));
                continue;
            }
            if ("roleAttributeNames".equals(key)) {
                String attrNames = (String)options.get(key);
                this.log.trace((Object)("Got roleAttributeNames value " + attrNames));
                String[] attributes = attrNames.split(",\\s*");
                this.roleAttributeNames.addAll(Arrays.asList(attributes));
                this.log.debug((Object)("Set roleAttributeNames=" + this.roleAttributeNames));
                continue;
            }
            if ("principalGroupName".equals(key)) {
                this.principalGroupName = (String)options.get(key);
                this.log.debug((Object)("Set principalGroupName=" + this.principalGroupName));
                continue;
            }
            if ("roleGroupName".equals(key)) {
                this.roleGroupName = (String)options.get(key);
                this.log.debug((Object)("Set roleGroupName=" + this.roleGroupName));
                continue;
            }
            if ("cacheAssertions".equals(key)) {
                this.cacheAssertions = Boolean.parseBoolean((String)options.get(key));
                this.log.debug((Object)("Set cacheAssertions=" + this.cacheAssertions));
                continue;
            }
            if (!"cacheTimeout".equals(key)) continue;
            this.cacheTimeout = Integer.parseInt((String)options.get(key));
            this.log.debug((Object)("Set cacheTimeout=" + this.cacheTimeout));
        }
        if (this.cacheAssertions) {
            cacheCleanerExecutor.execute(new CacheCleaner());
        }
        CommonUtils.assertNotNull(ticketValidatorClass, "ticketValidatorClass is required.");
        this.ticketValidator = this.createTicketValidator(ticketValidatorClass, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        this.log.debug((Object)"Performing login.");
        NameCallback serviceCallback = new NameCallback("service");
        PasswordCallback ticketCallback = new PasswordCallback("ticket", false);
        try {
            this.callbackHandler.handle(new Callback[]{ticketCallback, serviceCallback});
        }
        catch (IOException e) {
            this.log.info((Object)("Login failed due to IO exception in callback handler: " + e));
            throw (LoginException)new LoginException("IO exception in callback handler: " + e).initCause(e);
        }
        catch (UnsupportedCallbackException e) {
            this.log.info((Object)("Login failed due to unsupported callback: " + e));
            throw (LoginException)new LoginException("Callback handler does not support PasswordCallback and TextInputCallback.").initCause(e);
        }
        if (ticketCallback.getPassword() != null) {
            String service;
            this.ticket = new TicketCredential(new String(ticketCallback.getPassword()));
            String string = service = CommonUtils.isNotBlank(serviceCallback.getName()) ? serviceCallback.getName() : this.service;
            if (this.cacheAssertions) {
                Map map = ASSERTION_CACHE;
                synchronized (map) {
                    if (ASSERTION_CACHE.get(this.ticket) != null) {
                        this.log.debug((Object)"Assertion found in cache.");
                        this.assertion = (Assertion)ASSERTION_CACHE.get(this.ticket);
                    }
                }
            }
            if (this.assertion == null) {
                this.log.debug((Object)"CAS assertion is null; ticket validation required.");
                if (CommonUtils.isBlank(service)) {
                    this.log.info((Object)"Login failed because required CAS service parameter not provided.");
                    throw new LoginException("Neither login module nor callback handler provided required service parameter.");
                }
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Attempting ticket validation with service=" + service + " and ticket=" + this.ticket));
                    }
                    this.assertion = this.ticketValidator.validate(this.ticket.getTicket(), service);
                }
                catch (Exception e) {
                    this.log.info((Object)("Login failed due to CAS ticket validation failure: " + e));
                    throw (LoginException)new LoginException("CAS ticket validation failed: " + e).initCause(e);
                }
            }
        } else {
            this.log.info((Object)"Login failed because callback handler did not provide CAS ticket.");
            throw new LoginException("Callback handler did not provide CAS ticket.");
        }
        this.log.info((Object)"Login succeeded.");
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.ticket != null) {
            this.ticket = null;
        }
        if (this.assertion != null) {
            this.assertion = null;
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.assertion != null) {
            if (this.ticket == null) {
                throw new LoginException("Ticket credential not found.");
            }
            this.subject.getPrivateCredentials().add(this.ticket);
            AssertionPrincipal casPrincipal = new AssertionPrincipal(this.assertion.getPrincipal().getName(), this.assertion);
            this.subject.getPrincipals().add(casPrincipal);
            SimpleGroup principalGroup = new SimpleGroup(this.principalGroupName);
            principalGroup.addMember(casPrincipal);
            this.subject.getPrincipals().add(principalGroup);
            SimpleGroup roleGroup = new SimpleGroup(this.roleGroupName);
            for (int i = 0; i < this.defaultRoles.length; ++i) {
                roleGroup.addMember(new SimplePrincipal(this.defaultRoles[i]));
            }
            Map attributes = this.assertion.getPrincipal().getAttributes();
            Iterator nameIterator = attributes.keySet().iterator();
            while (nameIterator.hasNext()) {
                Object key = nameIterator.next();
                if (!this.roleAttributeNames.contains(key)) continue;
                Object value = attributes.get(key);
                if (value instanceof Collection) {
                    Iterator valueIterator = ((Collection)value).iterator();
                    while (valueIterator.hasNext()) {
                        roleGroup.addMember(new SimplePrincipal(valueIterator.next().toString()));
                    }
                    continue;
                }
                roleGroup.addMember(new SimplePrincipal(value.toString()));
            }
            this.subject.getPrincipals().add(roleGroup);
            this.sharedState.put(LOGIN_NAME, casPrincipal.getName());
            if (this.log.isDebugEnabled() && this.log.isDebugEnabled()) {
                this.log.debug((Object)("Created JAAS subject with principals: " + this.subject.getPrincipals()));
            }
            if (this.cacheAssertions) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Caching assertion for principal " + this.assertion.getPrincipal()));
                }
                ASSERTION_CACHE.put(this.ticket, this.assertion);
            }
        } else if (this.ticket != null) {
            this.ticket = null;
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.log.debug((Object)"Performing logout.");
        this.removePrincipalsOfType(AssertionPrincipal.class);
        this.removePrincipalsOfType(SimplePrincipal.class);
        this.removePrincipalsOfType(SimpleGroup.class);
        this.removeCredentialsOfType(TicketCredential.class);
        this.log.info((Object)"Logout succeeded.");
        return true;
    }

    private TicketValidator createTicketValidator(String className, Map propertyMap) {
        CommonUtils.assertTrue(propertyMap.containsKey("casServerUrlPrefix"), "Required property casServerUrlPrefix not found.");
        Class validatorClass = ReflectUtils.loadClass(className);
        TicketValidator validator = (TicketValidator)ReflectUtils.newInstance(validatorClass, new Object[]{propertyMap.get("casServerUrlPrefix")});
        try {
            BeanInfo info = Introspector.getBeanInfo(validatorClass);
            Iterator iter = propertyMap.keySet().iterator();
            while (iter.hasNext()) {
                String property = (String)iter.next();
                if ("casServerUrlPrefix".equals(property)) continue;
                this.log.debug((Object)("Attempting to set TicketValidator property " + property));
                String value = (String)propertyMap.get(property);
                PropertyDescriptor pd = ReflectUtils.getPropertyDescriptor(info, property);
                if (pd != null) {
                    ReflectUtils.setProperty(property, CasLoginModule.convertIfNecessary(pd, value), validator, info);
                    this.log.debug((Object)("Set " + property + "=" + value));
                    continue;
                }
                this.log.warn((Object)("Cannot find property " + property + " on " + className));
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Error getting bean info for " + validatorClass, e);
        }
        return validator;
    }

    private static Object convertIfNecessary(PropertyDescriptor pd, String value) {
        if (String.class.equals(pd.getPropertyType())) {
            return value;
        }
        if (Boolean.TYPE.equals(pd.getPropertyType())) {
            return Boolean.valueOf(value);
        }
        if (Integer.TYPE.equals(pd.getPropertyType())) {
            return new Integer(value);
        }
        if (Long.TYPE.equals(pd.getPropertyType())) {
            return new Long(value);
        }
        throw new IllegalArgumentException("No conversion strategy exists for property " + pd.getName() + " of type " + pd.getPropertyType());
    }

    private void removePrincipalsOfType(Class clazz) {
        Iterator iter = this.subject.getPrincipals(clazz).iterator();
        while (iter.hasNext()) {
            this.subject.getPrincipals().remove(iter.next());
        }
    }

    private void removeCredentialsOfType(Class clazz) {
        Iterator iter = this.subject.getPrivateCredentials(clazz).iterator();
        while (iter.hasNext()) {
            this.subject.getPrivateCredentials().remove(iter.next());
        }
    }

    private class CacheCleaner
    implements Runnable {
        private CacheCleaner() {
        }

        public void run() {
            if (CasLoginModule.this.log.isDebugEnabled()) {
                CasLoginModule.this.log.debug((Object)("Cleaning assertion cache of size " + ASSERTION_CACHE.size()));
            }
            Iterator iter = ASSERTION_CACHE.entrySet().iterator();
            Calendar cutoff = Calendar.getInstance();
            cutoff.add(12, -CasLoginModule.this.cacheTimeout);
            while (iter.hasNext()) {
                Assertion assertion = (Assertion)iter.next().getValue();
                Calendar created = Calendar.getInstance();
                created.setTime(assertion.getValidFromDate());
                if (!created.before(cutoff)) continue;
                if (CasLoginModule.this.log.isDebugEnabled()) {
                    CasLoginModule.this.log.debug((Object)("Removing expired assertion for principal " + assertion.getPrincipal()));
                }
                iter.remove();
            }
        }
    }
}

