/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.grammar;

public abstract class ParseNode {
    public static final int ARRAY = 0;
    public static final int ASSIGN = 1;
    public static final int BIND = 2;
    public static final int BINOP = 3;
    public static final int BOOLEAN_LITERAL = 4;
    public static final int COMMA = 5;
    public static final int COLON = 6;
    public static final int FIELD = 7;
    public static final int FLOAT_LITERAL = 8;
    public static final int IDENTIFIER = 9;
    public static final int INTEGER_LITERAL = 10;
    public static final int METH = 11;
    public static final int NOTHING = 12;
    public static final int PATH = 13;
    public static final int RETURN = 14;
    public static final int SEMI = 15;
    public static final int STRING_LITERAL = 16;
    public static final int TERNOP = 17;
    public static final int THROW = 18;
    public static final int UNOP = 19;
    public static final int NEW = 20;
    public static final int NULL_LITERAL = 21;
    public static final int AND = 30;
    public static final int BAND = 31;
    public static final int BOR = 32;
    public static final int BXOR = 33;
    public static final int DIV = 34;
    public static final int DOLLAR = 35;
    public static final int EQ = 36;
    public static final int GE = 37;
    public static final int GT = 38;
    public static final int LE = 39;
    public static final int LT = 40;
    public static final int MINUS = 41;
    public static final int MOD = 42;
    public static final int MUL = 43;
    public static final int NE = 44;
    public static final int NOT = 45;
    public static final int OR = 46;
    public static final int PLUS = 47;
    public static final int TWIDDLE = 48;
    public static final int UMINUS = 49;
    public static final int LSH = 50;
    public static final int RSH = 51;
    public static final int URSH = 52;
    private int tag;
    private String file;
    private int line;
    private int column;

    protected ParseNode(int tag, String file, int line, int column) {
        this.tag = tag;
        this.file = file;
        this.line = line;
        this.column = column;
    }

    public int getTag() {
        return this.tag;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public abstract int getChildCount();

    public abstract Object getChild(int var1);

    public abstract String getText();

    public String getPos() {
        return " " + this.file + " line " + this.line;
    }

    public static ParseNode node(int tag, String file, int line, int column) {
        return new NullaryNode(tag, file, line, column);
    }

    public static ParseNode node(int tag, String file, int line, int column, Object child0) {
        return new UnaryNode(tag, file, line, column, child0);
    }

    public static ParseNode node(int tag, String file, int line, int column, Object child0, Object child1) {
        return new BinaryNode(tag, file, line, column, child0, child1);
    }

    public static ParseNode node(int tag, String file, int line, int column, Object child0, Object child1, Object child2) {
        return new TernaryNode(tag, file, line, column, child0, child1, child2);
    }

    public static ParseNode node(int tag, String file, int line, int column, Object child0, Object child1, Object child2, Object child3) {
        return new QuaternaryNode(tag, file, line, column, child0, child1, child2, child3);
    }

    private static class QuaternaryNode
    extends ParseNode {
        private Object child0;
        private Object child1;
        private Object child2;
        private Object child3;

        public QuaternaryNode(int tag, String file, int line, int column, Object child0, Object child1, Object child2, Object child3) {
            super(tag, file, line, column);
            this.child0 = child0;
            this.child1 = child1;
            this.child2 = child2;
            this.child3 = child3;
        }

        @Override
        public int getChildCount() {
            return 2;
        }

        @Override
        public Object getChild(int idx) {
            switch (idx) {
                case 0: {
                    return this.child0;
                }
                case 1: {
                    return this.child1;
                }
                case 2: {
                    return this.child2;
                }
                case 3: {
                    return this.child3;
                }
            }
            return null;
        }

        @Override
        public String getText() {
            int tag = this.getTag();
            switch (tag) {
                default: 
            }
            System.out.println("QuaternaryNode.getText() : Unexpected tag " + tag);
            return "???";
        }
    }

    private static class TernaryNode
    extends ParseNode {
        private Object child0;
        private Object child1;
        private Object child2;

        public TernaryNode(int tag, String file, int line, int column, Object child0, Object child1, Object child2) {
            super(tag, file, line, column);
            this.child0 = child0;
            this.child1 = child1;
            this.child2 = child2;
        }

        @Override
        public int getChildCount() {
            return 3;
        }

        @Override
        public Object getChild(int idx) {
            switch (idx) {
                case 0: {
                    return this.child0;
                }
                case 1: {
                    return this.child1;
                }
                case 2: {
                    return this.child2;
                }
            }
            return null;
        }

        @Override
        public String getText() {
            int tag = this.getTag();
            switch (tag) {
                case 3: {
                    return ((ParseNode)this.child0).getText();
                }
                case 11: {
                    return ((ParseNode)this.child0).getText();
                }
                case 17: {
                    return "?";
                }
            }
            System.out.println("TernaryNode.getText() : Unexpected tag " + tag);
            return "???";
        }
    }

    private static class BinaryNode
    extends ParseNode {
        private Object child0;
        private Object child1;

        public BinaryNode(int tag, String file, int line, int column, Object child0, Object child1) {
            super(tag, file, line, column);
            this.child0 = child0;
            this.child1 = child1;
        }

        @Override
        public int getChildCount() {
            return 2;
        }

        @Override
        public Object getChild(int idx) {
            switch (idx) {
                case 0: {
                    return this.child0;
                }
                case 1: {
                    return this.child1;
                }
            }
            return null;
        }

        @Override
        public String getText() {
            int tag = this.getTag();
            switch (tag) {
                case 0: {
                    return ((ParseNode)this.child0).getText() + "[" + ((ParseNode)this.child1).getText() + "]";
                }
                case 1: {
                    return "=";
                }
                case 2: {
                    return "BIND";
                }
                case 6: {
                    return ((ParseNode)this.child0).getText();
                }
                case 7: {
                    return "." + ((ParseNode)this.child1).getText();
                }
                case 9: {
                    String text = (String)this.child0;
                    for (ParseNode next = (ParseNode)this.child1; next != null; next = (ParseNode)next.getChild(1)) {
                        text = next.getText() + "." + text;
                    }
                    return text;
                }
                case 13: {
                    return (String)this.child0;
                }
                case 15: {
                    return ";";
                }
                case 18: {
                    return "THROW";
                }
                case 20: {
                    return "NEW";
                }
                case 19: {
                    return ((ParseNode)this.child0).getText();
                }
            }
            System.out.println("BinaryNode.getText() : Unexpected tag " + tag);
            return "???";
        }
    }

    private static class UnaryNode
    extends ParseNode {
        private Object child0;

        public UnaryNode(int tag, String file, int line, int column, Object child0) {
            super(tag, file, line, column);
            this.child0 = child0;
        }

        @Override
        public int getChildCount() {
            return 1;
        }

        @Override
        public Object getChild(int idx) {
            if (idx == 0) {
                return this.child0;
            }
            return null;
        }

        @Override
        public String getText() {
            int tag = this.getTag();
            switch (tag) {
                case 0: {
                    return ((ParseNode)this.child0).getText() + "[]";
                }
                case 4: {
                    return this.child0.toString();
                }
                case 8: {
                    return this.child0.toString();
                }
                case 10: {
                    return this.child0.toString();
                }
                case 14: {
                    return "RETURN";
                }
                case 16: {
                    return "\"" + (String)this.child0 + "\"";
                }
                case 35: {
                    return (String)this.child0;
                }
            }
            System.out.println("UnaryNode.getText() : Unexpected tag " + tag);
            return "???";
        }
    }

    private static class NullaryNode
    extends ParseNode {
        public NullaryNode(int tag, String file, int line, int column) {
            super(tag, file, line, column);
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public Object getChild(int idx) {
            return null;
        }

        @Override
        public String getText() {
            int tag = this.getTag();
            switch (tag) {
                case 12: {
                    return "NOTHING";
                }
                case 30: {
                    return "&&";
                }
                case 50: {
                    return "<<";
                }
                case 51: {
                    return ">>";
                }
                case 52: {
                    return ">>>";
                }
                case 31: {
                    return "&";
                }
                case 32: {
                    return "|";
                }
                case 33: {
                    return "^";
                }
                case 34: {
                    return "/";
                }
                case 35: {
                    return "$";
                }
                case 36: {
                    return "==";
                }
                case 37: {
                    return ">=";
                }
                case 38: {
                    return ">";
                }
                case 39: {
                    return "<=";
                }
                case 40: {
                    return "<";
                }
                case 41: {
                    return "-";
                }
                case 42: {
                    return "%";
                }
                case 43: {
                    return "*";
                }
                case 44: {
                    return "!=";
                }
                case 45: {
                    return "!";
                }
                case 46: {
                    return "||";
                }
                case 47: {
                    return "+";
                }
                case 48: {
                    return "~";
                }
                case 49: {
                    return "-";
                }
                case 21: {
                    return "null";
                }
            }
            System.out.println("NullaryNode.getText() : Unexpected tag " + tag);
            return "???";
        }
    }
}

