/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nutz.dao.Chain;
import org.nutz.dao.Condition;
import org.nutz.dao.FieldMatcher;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.impl.sql.pojo.AbstractPItem;
import org.nutz.dao.impl.sql.pojo.ConditionPItem;
import org.nutz.dao.impl.sql.pojo.InsertByChainPItem;
import org.nutz.dao.sql.Criteria;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.PojoMaker;
import org.nutz.dao.sql.SqlType;
import org.nutz.dao.util.Pojos;
import org.nutz.dao.util.cri.Static;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;

public class EntityOperator {
    Entity<?> entity;
    NutDao dao;
    Object myObj;
    List<Pojo> pojoList = new ArrayList<Pojo>();
    private int updateCount;

    public EntityOperator exec() {
        if (null != this.entity) {
            for (Pojo pojo : this.pojoList) {
                if (null == pojo.getOperatingObject()) {
                    pojo.setOperatingObject(this.myObj);
                }
                if (!pojo.params().isEmpty()) continue;
                pojo.addParamsBy(pojo.getOperatingObject());
            }
            this.updateCount = this.dao._exec(this.pojoList.toArray(new DaoStatement[this.pojoList.size()]));
        }
        return this;
    }

    public Pojo addUpdate() {
        return this.addUpdate(this.entity, this.myObj);
    }

    public Pojo addUpdate(Chain chain, Condition cnd) {
        Pojo pojo = this.dao.pojoMaker.makePojo(SqlType.UPDATE);
        pojo.setEntity(this.entity);
        pojo.append(Pojos.Items.entityTableName());
        pojo.append(Pojos.Items.updateFieldsBy(chain));
        pojo.append(Pojos.Items.cnd(cnd));
        this.pojoList.add(pojo);
        return pojo;
    }

    public Pojo addUpdate(Entity<?> en, Object obj) {
        if (null == en) {
            return null;
        }
        Pojo pojo = this.dao.pojoMaker.makeUpdate(en, null).append(Pojos.Items.cndAuto(en, Lang.first(obj))).setOperatingObject(obj);
        this.pojoList.add(pojo);
        return pojo;
    }

    public Pojo addUpdateByPkAndCnd(Condition cnd) {
        return this.addUpdateByPkAndCnd(this.entity, this.myObj, cnd);
    }

    public Pojo addUpdateByPkAndCnd(Entity<?> en, Object obj, Condition cnd) {
        if (null == en) {
            return null;
        }
        Pojo pojo = this.dao.pojoMaker.makeUpdate(en, null).append(Pojos.Items.cndAuto(en, Lang.first(obj))).setOperatingObject(obj);
        pojo.append(new Static(" AND "));
        if (cnd instanceof Criteria) {
            pojo.append(((Criteria)cnd).where().setTop(false));
        } else {
            pojo.append(new ConditionPItem(cnd).setTop(false));
        }
        this.pojoList.add(pojo);
        return pojo;
    }

    public List<Pojo> addUpdateForIgnoreNull(final Entity<?> en, Object obj, FieldMatcher fm) {
        FieldMatcher newFM;
        if (null == en) {
            return null;
        }
        if (null == fm) {
            newFM = FieldMatcher.make(null, null, true);
        } else {
            newFM = fm;
            newFM.setIgnoreNull(true);
        }
        final ArrayList<Pojo> re = new ArrayList<Pojo>(Lang.eleSize(obj));
        Lang.each(obj, new Each<Object>(){

            @Override
            public void invoke(int i, Object ele, int length) throws ExitLoop, LoopException {
                Pojo pojo = EntityOperator.this.dao.pojoMaker.makeUpdate(en, ele).append(Pojos.Items.cndAuto(en, ele)).setOperatingObject(ele);
                pojo.getContext().setFieldMatcher(newFM);
                re.add(pojo);
            }
        });
        this.pojoList.addAll(re);
        return re;
    }

    public Pojo addUpdateAndIncrIfMatch(Entity<?> en, Object obj, String fieldName) {
        if (null == en) {
            return null;
        }
        MappingField mf = en.getField(fieldName);
        Pojo pojo = this.dao.pojoMaker.makeUpdate(en, null).append(new Static("," + mf.getColumnNameInSql() + "=" + mf.getColumnNameInSql() + "+1")).append(Pojos.Items.cndAuto(en, Lang.first(obj))).setOperatingObject(obj);
        pojo.append(new Static("AND")).append(((AbstractPItem)Pojos.Items.cndColumn(mf, null)).setTop(false));
        this.pojoList.add(pojo);
        return pojo;
    }

    public Pojo addUpdate(Condition cnd) {
        if (null == this.entity) {
            return null;
        }
        Pojo pojo = this.dao.pojoMaker.makeUpdate(this.entity, null).append(Pojos.Items.cnd(cnd));
        this.pojoList.add(pojo);
        return pojo;
    }

    public Pojo addDeleteSelfOnly(long id) {
        if (null == this.entity) {
            return null;
        }
        Pojo pojo = this.dao.pojoMaker.makeDelete(this.entity);
        pojo.append(Pojos.Items.cndAuto(this.entity, this.myObj));
        pojo.addParamsBy(this.myObj);
        this.pojoList.add(pojo);
        return pojo;
    }

    public Pojo addDeleteSelfOnly(String name) {
        if (null == this.entity) {
            return null;
        }
        Pojo pojo = this.dao.pojoMaker.makeDelete(this.entity);
        pojo.append(Pojos.Items.cndName(this.entity, name));
        pojo.addParamsBy(name);
        this.pojoList.add(pojo);
        return pojo;
    }

    public Pojo addDeleteSelfOnly() {
        if (null == this.entity) {
            return null;
        }
        Pojo pojo = this.dao.pojoMaker.makeDelete(this.entity);
        pojo.append(Pojos.Items.cndAuto(this.entity, this.myObj));
        pojo.addParamsBy(this.myObj);
        this.pojoList.add(pojo);
        return pojo;
    }

    public List<Pojo> addInsert() {
        return this.addInsert(this.entity, this.myObj);
    }

    public List<Pojo> addInsert(Entity<?> en, Object obj) {
        if (null == en) {
            return null;
        }
        int len = Map.class.isAssignableFrom(obj.getClass()) ? 1 : Lang.eleSize(obj);
        ArrayList<Pojo> re = new ArrayList<Pojo>(len);
        if (len > 0) {
            if (len == 1) {
                for (Pojo pojo : en.cloneBeforeInsertMacroes()) {
                    re.add(pojo.setOperatingObject(obj));
                }
            }
            re.add(this.dao.pojoMaker.makeInsert(en).setOperatingObject(obj));
            if (len == 1) {
                for (Pojo pojo : en.cloneAfterInsertMacroes()) {
                    re.add(pojo.setOperatingObject(obj));
                }
            }
            this.pojoList.addAll(re);
        }
        return re;
    }

    public Pojo addInsertSelfOnly() {
        return this.addInsertSelfOnly(this.entity, this.myObj);
    }

    public Pojo addInsertSelfOnly(Entity<?> en, Object obj) {
        Pojo pojo;
        if (null == en) {
            return null;
        }
        if (obj instanceof Chain) {
            pojo = this.dao.pojoMaker.makePojo(SqlType.INSERT);
            pojo.append(Pojos.Items.entityTableName());
            pojo.append(new InsertByChainPItem((Chain)obj));
            pojo.setEntity(en);
        } else {
            pojo = this.dao.pojoMaker.makeInsert(en).setOperatingObject(obj);
        }
        this.pojoList.add(pojo);
        return pojo;
    }

    public EntityOperator add(Pojo pojo) {
        this.pojoList.add(pojo);
        return this;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public PojoMaker maker() {
        return this.dao.pojoMaker;
    }

    public Entity<?> getEntityBy(Object obj) {
        return this.dao.holder.getEntityBy(obj);
    }

    public Entity<?> getEntity(Class<?> type) {
        return this.dao.holder.getEntity(type);
    }

    public Entity<?> makeEntity(String tableName, Map<String, Object> map) {
        return this.dao.holder.makeEntity(tableName, map);
    }

    public int getPojoListSize() {
        return this.pojoList.size();
    }
}

