/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class SimpleDataSource
implements DataSource {
    private static final Log log;
    protected String username;
    protected String password;
    protected String driverClassName;
    protected String jdbcUrl;

    public SimpleDataSource() {
        log.warn("SimpleDataSource is NOT a Connection Pool, So it is slow but safe for debug/study");
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = this.username != null ? DriverManager.getConnection(this.jdbcUrl, this.username, this.password) : DriverManager.getConnection(this.jdbcUrl);
        return conn;
    }

    public void close() {
    }

    public void setDriverClassName(String driverClassName) throws ClassNotFoundException {
        Lang.loadClass(driverClassName);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public Logger getParentLogger() {
        throw Lang.noImplement();
    }

    public static DataSource createDataSource(Properties props) {
        SimpleDataSource sds = new SimpleDataSource();
        sds.setJdbcUrl(props.getProperty("url", props.getProperty("jdbcUrl")));
        sds.setPassword(props.getProperty("password"));
        sds.setUsername(props.getProperty("username"));
        return sds;
    }

    static {
        String[] drivers;
        log = Logs.get();
        for (String driverClassName : drivers = new String[]{"org.h2.Driver", "com.ibm.db2.jcc.DB2Driver", "org.hsqldb.jdbcDriver", "oracle.jdbc.OracleDriver", "org.postgresql.Driver", "net.sourceforge.jtds.jdbc.Driver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "org.sqlite.JDBC", "com.mysql.jdbc.Driver", "com.beyondb.jdbc.BeyondbDriver"}) {
            try {
                Class.forName(driverClassName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

