/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.nutz.castor.Castors;
import org.nutz.json.JsonField;
import org.nutz.json.TimeStampDateFormat;

public class JsonFormat
implements Cloneable {
    private int indent;
    private String indentBy;
    private boolean compact;
    private boolean quoteName;
    private boolean ignoreNull;
    private Pattern actived;
    private Pattern locked;
    @JsonField(ignore=true)
    private Castors castors;
    private char separator;
    private boolean autoUnicode;
    private boolean unicodeLower;
    private DateFormat dateFormat;
    private NumberFormat numberFormat;
    private boolean nullAsEmtry;
    private boolean nullListAsEmpty;
    private boolean nullStringAsEmpty;
    private boolean nullBooleanAsFalse;
    private boolean nullNumberAsZero;
    private TimeZone timeZone;
    public static String DATEFORMAT_TIMESTAMP = "timestamp";

    public static JsonFormat compact() {
        return new JsonFormat(true).setIgnoreNull(true);
    }

    public static JsonFormat full() {
        return new JsonFormat(false).setIgnoreNull(false);
    }

    public static JsonFormat nice() {
        return new JsonFormat(false).setIgnoreNull(true);
    }

    public static JsonFormat forLook() {
        return new JsonFormat(false).setQuoteName(false).setIgnoreNull(true);
    }

    public static JsonFormat tidy() {
        return new JsonFormat(true).setIgnoreNull(false);
    }

    public JsonFormat() {
        this(true);
    }

    public JsonFormat(boolean compact) {
        this.compact = compact;
        this.indentBy = "   ";
        this.quoteName = true;
        this.castors = Castors.me();
        this.separator = (char)34;
    }

    public boolean ignore(String name) {
        if (null != this.actived) {
            return !this.actived.matcher(name).find();
        }
        if (null != this.locked) {
            return this.locked.matcher(name).find();
        }
        return false;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public JsonFormat setCompact(boolean compact) {
        this.compact = compact;
        return this;
    }

    public int getIndent() {
        return this.indent;
    }

    public JsonFormat setIndent(int indent) {
        this.indent = indent;
        return this;
    }

    public JsonFormat increaseIndent() {
        ++this.indent;
        return this;
    }

    public JsonFormat decreaseIndent() {
        --this.indent;
        return this;
    }

    public String getIndentBy() {
        return this.indentBy;
    }

    public JsonFormat setIndentBy(String indentBy) {
        this.indentBy = indentBy;
        return this;
    }

    public boolean isQuoteName() {
        return this.quoteName;
    }

    public JsonFormat setQuoteName(boolean quoteName) {
        this.quoteName = quoteName;
        return this;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }

    public JsonFormat setIgnoreNull(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
        return this;
    }

    public JsonFormat setActived(String regex) {
        this.actived = Pattern.compile(regex);
        return this;
    }

    public JsonFormat setLocked(String regex) {
        this.locked = Pattern.compile(regex);
        return this;
    }

    public Castors getCastors() {
        return this.castors == null ? Castors.me() : this.castors;
    }

    public JsonFormat setCastors(Castors castors) {
        this.castors = castors;
        return this;
    }

    public JsonFormat setSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    public char getSeparator() {
        return this.separator;
    }

    public JsonFormat setAutoUnicode(boolean autoUnicode) {
        this.autoUnicode = autoUnicode;
        return this;
    }

    public boolean isAutoUnicode() {
        return this.autoUnicode;
    }

    public boolean isUnicodeLower() {
        return this.unicodeLower;
    }

    public JsonFormat setUnicodeLower(boolean unicodeLower) {
        this.unicodeLower = unicodeLower;
        return this;
    }

    public JsonFormat setDateFormat(String df) {
        this.dateFormat = df == null ? null : (DATEFORMAT_TIMESTAMP.equals(df) ? new TimeStampDateFormat() : new SimpleDateFormat(df));
        return this;
    }

    public JsonFormat setDateFormat(DateFormat df) {
        this.dateFormat = df;
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat == null ? null : (DateFormat)this.dateFormat.clone();
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat == null ? null : (NumberFormat)this.numberFormat.clone();
    }

    public JsonFormat setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        return this;
    }

    public JsonFormat clone() {
        JsonFormat jf = new JsonFormat();
        jf.indent = this.indent;
        jf.indentBy = this.indentBy;
        jf.compact = this.compact;
        jf.quoteName = this.quoteName;
        jf.ignoreNull = this.ignoreNull;
        jf.actived = this.actived;
        jf.locked = this.locked;
        jf.castors = this.castors;
        jf.separator = this.separator;
        jf.autoUnicode = this.autoUnicode;
        jf.unicodeLower = this.unicodeLower;
        jf.dateFormat = this.dateFormat;
        jf.numberFormat = this.numberFormat;
        jf.nullAsEmtry = this.nullAsEmtry;
        jf.nullListAsEmpty = this.nullListAsEmpty;
        jf.nullNumberAsZero = this.nullNumberAsZero;
        jf.nullStringAsEmpty = this.nullStringAsEmpty;
        jf.nullBooleanAsFalse = this.nullBooleanAsFalse;
        jf.timeZone = this.timeZone;
        return jf;
    }

    public Pattern getActived() {
        return this.actived;
    }

    public JsonFormat setActived(Pattern actived) {
        this.actived = actived;
        return this;
    }

    public Pattern getLocked() {
        return this.locked;
    }

    public JsonFormat setLocked(Pattern locked) {
        this.locked = locked;
        return this;
    }

    public boolean isNullAsEmtry() {
        return this.nullAsEmtry;
    }

    public JsonFormat setNullAsEmtry(boolean nullAsEmtry) {
        this.nullAsEmtry = nullAsEmtry;
        return this;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public JsonFormat setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public boolean isNullListAsEmpty() {
        return this.nullListAsEmpty;
    }

    public JsonFormat setNullListAsEmpty(boolean nullListAsEmpty) {
        this.nullListAsEmpty = nullListAsEmpty;
        return this;
    }

    public boolean isNullStringAsEmpty() {
        return this.nullStringAsEmpty;
    }

    public JsonFormat setNullStringAsEmpty(boolean nullStringAsEmpty) {
        this.nullStringAsEmpty = nullStringAsEmpty;
        return this;
    }

    public boolean isNullBooleanAsFalse() {
        return this.nullBooleanAsFalse;
    }

    public JsonFormat setNullBooleanAsFalse(boolean nullBooleanAsFalse) {
        this.nullBooleanAsFalse = nullBooleanAsFalse;
        return this;
    }

    public boolean isNullNumberAsZero() {
        return this.nullNumberAsZero;
    }

    public JsonFormat setNullNumberAsZero(boolean nullNumberAsZero) {
        this.nullNumberAsZero = nullNumberAsZero;
        return this;
    }
}

