/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.tmpl;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.tmpl.TmplBooleanEle;
import org.nutz.lang.tmpl.TmplDateEle;
import org.nutz.lang.tmpl.TmplDoubleEle;
import org.nutz.lang.tmpl.TmplEle;
import org.nutz.lang.tmpl.TmplEscapeStr;
import org.nutz.lang.tmpl.TmplFloatEle;
import org.nutz.lang.tmpl.TmplIntEle;
import org.nutz.lang.tmpl.TmplJsonEle;
import org.nutz.lang.tmpl.TmplLongEle;
import org.nutz.lang.tmpl.TmplStaticEle;
import org.nutz.lang.tmpl.TmplStringEle;
import org.nutz.lang.util.NutBean;
import org.nutz.lang.util.NutMap;

public class Tmpl {
    private static final Pattern _P2 = Pattern.compile("([^<>()?]+)([<(](int|long|boolean|float|double|date|string|json)?( *: *([^>]*))?[>)])?([?] *(.*) *)?");
    private Pattern _P;
    int groupIndex;
    int escapeIndex;
    private TmplEscapeStr getEscapeStr;
    private List<TmplEle> list = new LinkedList<TmplEle>();
    private List<String> keys = new LinkedList<String>();

    public static Tmpl parse(String tmpl) {
        return new Tmpl(tmpl, null, -1, -1, null);
    }

    public static Tmpl parsef(String fmt, Object ... args) {
        return new Tmpl(String.format(fmt, args), null, -1, -1, null);
    }

    public static Tmpl parse(String tmpl, Pattern ptn, int groupIndex, int escapeIndex, TmplEscapeStr getEscapeStr) {
        return new Tmpl(tmpl, ptn, groupIndex, escapeIndex, getEscapeStr);
    }

    public static Tmpl parse(String tmpl, final String startChar, String leftBrace, String rightBrace) {
        String regex = "((?<![" + startChar + "])[" + startChar + "][" + ("[".equals(leftBrace) ? "\\[" : leftBrace) + "]([^" + ("]".equals(rightBrace) ? "\\]" : rightBrace) + "]+)[" + rightBrace + "])|([" + startChar + "][" + startChar + "])";
        Pattern ptn = Pattern.compile(regex);
        return new Tmpl(tmpl, ptn, 2, 3, new TmplEscapeStr(){

            @Override
            public String get(Matcher m) {
                return startChar;
            }
        });
    }

    public static Tmpl parse(String tmpl, String startChar) {
        return Tmpl.parse(tmpl, startChar, "{", "}");
    }

    public static String exec(String tmpl, NutBean context) {
        return Tmpl.exec(tmpl, null, -1, -1, null, context, true);
    }

    public static String exec(String tmpl, NutBean context, boolean showKey) {
        return Tmpl.exec(tmpl, null, -1, -1, null, context, showKey);
    }

    public static String exec(String tmpl, Pattern ptn, int groupIndex, int escapeIndex, TmplEscapeStr getEscapeStr, NutBean context, boolean showKey) {
        return Tmpl.parse(tmpl, ptn, groupIndex, escapeIndex, getEscapeStr).render(context, showKey);
    }

    public static String exec(String tmpl, String startChar, String leftBrace, String rightBrace, NutBean context, boolean showKey) {
        return Tmpl.parse(tmpl, startChar, leftBrace, rightBrace).render(context, showKey);
    }

    public static String exec(String tmpl, String startChar, NutBean context, boolean showKey) {
        return Tmpl.parse(tmpl, startChar).render(context, showKey);
    }

    private Tmpl() {
    }

    private Tmpl(Pattern ptn, int grpIdx, int escIdx, TmplEscapeStr getEscapeStr) {
        this();
        if (null == ptn) {
            this._P = Pattern.compile("((?<![$])[$][{]([^}]+)[}])|([$][$])");
            this.groupIndex = 2;
            this.escapeIndex = 3;
            this.getEscapeStr = new TmplEscapeStr(){

                @Override
                public String get(Matcher m) {
                    return "$";
                }
            };
        } else {
            this._P = ptn;
            this.groupIndex = grpIdx;
            this.escapeIndex = escIdx;
            this.getEscapeStr = getEscapeStr;
            if (null == this.getEscapeStr) {
                this.getEscapeStr = new TmplEscapeStr(){

                    @Override
                    public String get(Matcher m) {
                        return m.group(Tmpl.this.escapeIndex).substring(0, 1);
                    }
                };
            }
        }
    }

    private Tmpl(String tmpl, Pattern ptn, int groupIndex, int escapeIndex, TmplEscapeStr getEscapeStr) {
        this(ptn, groupIndex, escapeIndex, getEscapeStr);
        Matcher m = this._P.matcher(tmpl);
        int lastIndex = 0;
        while (m.find()) {
            int pos = m.start();
            if (pos > lastIndex) {
                this.list.add(new TmplStaticEle(tmpl.substring(lastIndex, pos)));
            }
            String s_escape = this.escapeIndex > 0 ? m.group(this.escapeIndex) : null;
            String s_match = m.group(this.groupIndex);
            if (!Strings.isBlank(s_escape)) {
                String esc_str = this.getEscapeStr.get(m);
                this.list.add(new TmplStaticEle(esc_str));
            } else {
                Matcher m2 = _P2.matcher(s_match);
                if (!m2.find()) {
                    throw Lang.makeThrow("Fail to parse tmpl key '%s'", m.group(1));
                }
                String key = m2.group(1);
                String type = Strings.sNull(m2.group(3), "string");
                String fmt = m2.group(5);
                String dft = m2.group(7);
                this.keys.add(key);
                if ("string".equals(type)) {
                    this.list.add(new TmplStringEle(key, fmt, dft));
                } else if ("int".equals(type)) {
                    this.list.add(new TmplIntEle(key, fmt, dft));
                } else if ("long".equals(type)) {
                    this.list.add(new TmplLongEle(key, fmt, dft));
                } else if ("boolean".equals(type)) {
                    this.list.add(new TmplBooleanEle(key, fmt, dft));
                } else if ("float".equals(type)) {
                    this.list.add(new TmplFloatEle(key, fmt, dft));
                } else if ("double".equals(type)) {
                    this.list.add(new TmplDoubleEle(key, fmt, dft));
                } else if ("date".equals(type)) {
                    this.list.add(new TmplDateEle(key, fmt, dft));
                } else if ("json".equals(type)) {
                    this.list.add(new TmplJsonEle(key, fmt, dft));
                } else {
                    throw Lang.impossible();
                }
            }
            lastIndex = m.end();
        }
        if (lastIndex < tmpl.length()) {
            this.list.add(new TmplStaticEle(tmpl.substring(lastIndex)));
        }
    }

    public String render(NutBean context) {
        return this.render(context, true);
    }

    public String render(NutBean context, boolean showKey) {
        StringBuilder sb = new StringBuilder();
        if (null == context) {
            context = new NutMap();
        }
        for (TmplEle ele : this.list) {
            ele.join(sb, context, showKey);
        }
        return sb.toString();
    }

    public List<String> keys() {
        return this.keys;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TmplEle ele : this.list) {
            sb.append(ele);
        }
        return sb.toString();
    }
}

