/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.nutz.castor.Castors;
import org.nutz.lang.Each;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.born.Borning;
import org.nutz.lang.util.NutBean;
import org.nutz.lang.util.Region;

public class NutMap
extends LinkedHashMap<String, Object>
implements NutBean {
    private NutMap _map;

    public static NutMap WRAP(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        if (map instanceof NutMap) {
            return (NutMap)map;
        }
        return new NutMap(map);
    }

    public NutMap() {
    }

    public NutMap(Map<String, Object> map) {
        this.putAll(map);
    }

    public NutMap(String json) {
        this.putAll(Lang.map(json));
    }

    public NutMap(String key, Object value) {
        this.put(key, value);
    }

    @Override
    public void setOrRemove(String key, Object v) {
        if (null == v) {
            this.remove(key);
        } else {
            this.put(key, v);
        }
    }

    public static NutMap NEW() {
        return new NutMap();
    }

    public static NutMap WRAP(String json) {
        return new NutMap(json);
    }

    @Override
    public boolean has(String key) {
        return null != this.get(key);
    }

    @Override
    public boolean is(String key, Object val) {
        Object obj = this.get(key);
        if (null == obj && null == val) {
            return true;
        }
        if (null == obj || null == val) {
            return false;
        }
        return obj.equals(val);
    }

    public NutMap duplicate() {
        NutMap map = new NutMap();
        map.putAll(this);
        return map;
    }

    @Override
    public NutMap pick(String ... keys) {
        if (keys.length == 0) {
            return new NutMap();
        }
        NutMap re = new NutMap();
        for (Map.Entry<String, Object> en : this.entrySet()) {
            String key = en.getKey();
            if (!Lang.contains(keys, key)) continue;
            re.put(key, en.getValue());
        }
        return re;
    }

    @Override
    public NutMap pickAndRemove(String ... keys) {
        if (keys.length == 0) {
            return new NutMap();
        }
        NutMap re = new NutMap();
        for (String key : keys) {
            Object val = this.remove(key);
            re.put(key, val);
        }
        return re;
    }

    @Override
    public NutMap pickBy(String regex) {
        if (Strings.isBlank(regex)) {
            return this.duplicate();
        }
        boolean isNot = regex.startsWith("!");
        Pattern p = Pattern.compile(isNot ? regex.substring(1) : regex);
        return this.pickBy(p, isNot);
    }

    @Override
    public NutMap pickBy(Pattern p, boolean isNot) {
        if (null == p) {
            return isNot ? this.duplicate() : new NutMap();
        }
        NutMap re = new NutMap();
        for (Map.Entry<String, Object> en : this.entrySet()) {
            String key = en.getKey();
            boolean matched = p.matcher(key).find();
            if (matched) {
                if (isNot) continue;
                re.put(key, en.getValue());
                continue;
            }
            if (!isNot) continue;
            re.put(key, en.getValue());
        }
        return re;
    }

    public NutMap pickAndRemoveBy(String regex) {
        if (Strings.isBlank(regex)) {
            return new NutMap();
        }
        boolean isNot = regex.startsWith("!");
        Pattern p = Pattern.compile(isNot ? regex.substring(1) : regex);
        return this.pickAndRemoveBy(p, isNot);
    }

    @Override
    public NutMap pickAndRemoveBy(Pattern p, boolean isNot) {
        if (null == p) {
            if (isNot) {
                NutMap re = this.duplicate();
                this.clear();
                return re;
            }
            return new NutMap();
        }
        NutMap re = new NutMap();
        ArrayList<String> delKeys = new ArrayList<String>(this.size());
        for (Map.Entry<String, Object> en : this.entrySet()) {
            String key = en.getKey();
            boolean matched = p.matcher(key).find();
            if (matched) {
                if (isNot) continue;
                delKeys.add(key);
                re.put(key, en.getValue());
                continue;
            }
            if (!isNot) continue;
            delKeys.add(key);
            re.put(key, en.getValue());
        }
        for (String key : delKeys) {
            this.remove(key);
        }
        return re;
    }

    @Override
    public NutMap omit(String ... keys) {
        NutMap re = new NutMap();
        for (Map.Entry<String, Object> en : this.entrySet()) {
            String key = en.getKey();
            if (Lang.contains(keys, key)) continue;
            re.put(key, en.getValue());
        }
        return re;
    }

    @Override
    public NutMap putDefault(String key, Object dft) {
        if (!this.has(key)) {
            this.put(key, dft);
        }
        return this;
    }

    @Override
    public boolean containsValue(Object value) {
        if (null == this._map) {
            return super.containsValue(value);
        }
        return super.containsValue(value) || this._map.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (null == this._map) {
            return super.containsKey(key);
        }
        return super.containsKey(key) || this._map.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        if (null == this._map) {
            return super.keySet();
        }
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(super.keySet());
        keys.addAll(this._map.keySet());
        return keys;
    }

    @Override
    public Collection<Object> values() {
        if (null == this._map) {
            return super.values();
        }
        LinkedList<Object> vals = new LinkedList<Object>();
        for (String key : this.keySet()) {
            vals.add(this.get(key));
        }
        return vals;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (null == this._map) {
            return super.entrySet();
        }
        HashSet<Map.Entry<String, Object>> vals = new HashSet<Map.Entry<String, Object>>();
        vals.addAll(this._map.entrySet());
        vals.addAll(super.entrySet());
        return vals;
    }

    @Override
    public void clear() {
        super.clear();
        if (null != this._map) {
            this._map.clear();
        }
    }

    public NutMap attach(NutMap map) {
        this._map = map;
        return this;
    }

    public NutMap detach() {
        NutMap re = this._map;
        this._map = null;
        return re;
    }

    @Override
    public Object get(Object key) {
        if (this._map == null) {
            return super.get(key);
        }
        if (super.containsKey(key)) {
            return super.get(key);
        }
        return this._map.get(key);
    }

    @Override
    public Object get(String key, Object dft) {
        Object v = this.get(key);
        return null == v ? dft : v;
    }

    @Override
    public int getInt(String key) {
        return this.getInt(key, -1);
    }

    @Override
    public int getInt(String key, int dft) {
        Object v = this.get(key);
        return null == v ? dft : Castors.me().castTo(v, Integer.TYPE);
    }

    @Override
    public float getFloat(String key) {
        return this.getFloat(key, Float.NaN);
    }

    @Override
    public float getFloat(String key, float dft) {
        Object v = this.get(key);
        return null == v ? dft : Castors.me().castTo(v, Float.TYPE).floatValue();
    }

    @Override
    public long getLong(String key) {
        return this.getLong(key, -1L);
    }

    @Override
    public long getLong(String key, long dft) {
        Object v = this.get(key);
        return null == v ? dft : Castors.me().castTo(v, Long.TYPE);
    }

    @Override
    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    @Override
    public double getDouble(String key, double dft) {
        Object v = this.get(key);
        return null == v ? dft : Castors.me().castTo(v, Double.TYPE);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    @Override
    public boolean getBoolean(String key, boolean dft) {
        Object v = this.get(key);
        return null == v ? dft : Castors.me().castTo(v, Boolean.TYPE);
    }

    @Override
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(String key, String dft) {
        Object v = this.get(key);
        if (v == null) {
            return dft;
        }
        if (v instanceof CharSequence) {
            return v.toString();
        }
        if (v instanceof List) {
            v = ((List)v).iterator().next();
        }
        return Castors.me().castTo(v, String.class);
    }

    @Override
    public Date getTime(String key) {
        return this.getTime(key, null);
    }

    @Override
    public Date getTime(String key, Date dft) {
        Object v = this.get(key);
        return null == v ? dft : Castors.me().castTo(v, Date.class);
    }

    @Override
    public <T extends Enum<T>> T getEnum(String key, Class<T> classOfEnum) {
        String s = this.getString(key);
        if (Strings.isBlank(s)) {
            return null;
        }
        return Enum.valueOf(classOfEnum, s);
    }

    @Override
    public boolean isEnum(String key, Enum<?> ... eus) {
        if (null == eus || eus.length == 0) {
            return false;
        }
        try {
            Object v = this.getEnum(key, eus[0].getClass());
            for (Enum<?> eu : eus) {
                if (((Enum)v).equals(eu)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public <T> T getAs(String key, Class<T> classOfT) {
        return this.getAs(key, classOfT, null);
    }

    @Override
    public <T> T getAs(String key, Class<T> classOfT, T dft) {
        Object v = this.get(key);
        return null == v ? dft : Castors.me().castTo(v, classOfT);
    }

    @Override
    public <T> List<T> getList(String key, Class<T> eleType) {
        return this.getList(key, eleType, new ArrayList());
    }

    @Override
    public <T> List<T> getList(String key, final Class<T> eleType, List<T> dft) {
        Object v = this.get(key);
        if (null == v) {
            return dft;
        }
        if (v instanceof CharSequence) {
            return Lang.list(Castors.me().castTo(v, eleType));
        }
        int len = Lang.eleSize(v);
        final ArrayList list = new ArrayList(len);
        Lang.each(v, new Each<Object>(){

            @Override
            public void invoke(int index, Object ele, int length) {
                list.add(Castors.me().castTo(ele, eleType));
            }
        });
        return list;
    }

    @Override
    public <T> T[] getArray(String key, Class<T> eleType) {
        return this.getArray(key, eleType, (Object[])Array.newInstance(eleType, 0));
    }

    @Override
    public <T> T[] getArray(String key, final Class<T> eleType, T[] dft) {
        Object v = this.get(key);
        if (null == v) {
            return dft;
        }
        if (v instanceof CharSequence) {
            return Lang.array(Castors.me().castTo(v, eleType));
        }
        int len = Lang.eleSize(v);
        final Object arr = Array.newInstance(eleType, len);
        final int[] i = new int[]{0};
        Lang.each(v, new Each<Object>(){

            @Override
            public void invoke(int index, Object ele, int length) {
                int n = i[0];
                i[0] = n + 1;
                Array.set(arr, n, Castors.me().castTo(ele, eleType));
            }
        });
        return (Object[])arr;
    }

    @Override
    public NutMap addv(String key, Object value) {
        Object obj = this.get(key);
        if (null == obj) {
            this.put(key, value);
        } else if (obj instanceof List) {
            ((List)obj).add(value);
        } else {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(obj);
            list.add(value);
            this.put(key, list);
        }
        return this;
    }

    public <T> NutMap pushTo(String key, T ... values) {
        if (null != values && values.length > 0) {
            Object v = this.get(key);
            if (null == v) {
                LinkedList<T> list = new LinkedList<T>();
                for (T val : values) {
                    list.add(val);
                }
                this.put(key, list);
            } else if (v instanceof Collection) {
                for (T val : values) {
                    ((Collection)v).add(val);
                }
            } else {
                LinkedList<Object> list = new LinkedList<Object>();
                list.add(v);
                for (T val : values) {
                    list.add(val);
                }
                this.put(key, list);
            }
        }
        return this;
    }

    public NutMap pushTo(String key, Collection<?> values) {
        if (null != values && values.size() > 0) {
            Object v = this.get(key);
            if (null == v) {
                LinkedList list = new LinkedList();
                list.addAll(values);
                this.put(key, list);
            } else if (v instanceof Collection) {
                ((Collection)v).addAll(values);
            } else {
                LinkedList<Object> list = new LinkedList<Object>();
                list.add(v);
                list.addAll(values);
                this.put(key, list);
            }
        }
        return this;
    }

    public NutMap putv(String key, Object value) {
        return this.addv(key, value);
    }

    @Override
    public NutMap setv(String key, Object value) {
        this.put(key, value);
        return this;
    }

    @Override
    public void unset(String key) {
        this.remove(key);
    }

    @Override
    public NutBean setAll(Map<String, Object> map) {
        this.putAll(map);
        return this;
    }

    @Override
    public NutMap setMap(Map<?, ?> map, boolean ignoreNullValue) {
        for (Map.Entry<?, ?> en : map.entrySet()) {
            Object key = en.getKey();
            Object val = en.getValue();
            if (null == key || null == val && ignoreNullValue) continue;
            this.put(key.toString(), val);
        }
        return this;
    }

    @Override
    public NutMap mergeWith(Map<String, Object> map) {
        return this.mergeWith((Map)map, false);
    }

    @Override
    public NutMap mergeWith(Map<String, Object> map, boolean onlyAbsent) {
        for (Map.Entry<String, Object> en : map.entrySet()) {
            String key = en.getKey();
            Object val = en.getValue();
            if (null == key || null == val) continue;
            Object myVal = this.get(key);
            if (null != myVal && myVal instanceof Map && val instanceof Map) {
                Map m0 = (Map)myVal;
                Map m1 = (Map)val;
                NutBean m2 = NutMap.WRAP(m0).mergeWith(m1, onlyAbsent);
                if (m2 == m0) continue;
                this.put(key, m2);
                continue;
            }
            if (onlyAbsent) {
                this.setnx(key, val);
                continue;
            }
            this.put(key, val);
        }
        return this;
    }

    @Override
    public NutMap setnx(String key, Object val) {
        if (!this.containsKey(key)) {
            this.setv(key, val);
        }
        return this;
    }

    @Override
    public NutMap setnxAll(Map<String, Object> map) {
        if (null != map && map.size() > 0) {
            for (Map.Entry<String, Object> en : map.entrySet()) {
                this.setnx(en.getKey(), en.getValue());
            }
        }
        return this;
    }

    @Override
    public <T> T getOrBorn(String key, Borning<T> factory) {
        Object t = this.get(key);
        if (t == null) {
            t = factory.born(key);
            this.put(key, t);
        }
        return (T)t;
    }

    @Override
    public boolean match(Map<String, Object> map) {
        if (null == map) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        for (Map.Entry<String, Object> en : this.entrySet()) {
            Object val;
            String key = en.getKey();
            Object mtc = en.getValue();
            if (!(null == mtc ? map.containsKey(key) : !this.__match_val(mtc, val = map.get(key)))) continue;
            return false;
        }
        return true;
    }

    private boolean __match_val(final Object mtc, Object val) {
        boolean[] re;
        Pattern regex;
        Mirror<Object> mi = Mirror.me(mtc);
        if (null == val) {
            return mi.isStringLike() && Strings.isEmpty(mtc.toString());
        }
        Pattern pattern = regex = mi.is(Pattern.class) ? (Pattern)mtc : null;
        if (mi.isStringLike()) {
            final String s = mtc.toString();
            if (s.startsWith("^")) {
                regex = Pattern.compile(s);
            } else {
                final boolean[] re2 = new boolean[1];
                Lang.each(val, new Each<Object>(){

                    @Override
                    public void invoke(int index, Object ele, int length) {
                        if (null != ele && ele.equals(s)) {
                            re2[0] = true;
                            Lang.Break();
                        }
                    }
                });
                return re2[0];
            }
        }
        if (null != regex) {
            re = new boolean[1];
            final Pattern REG = regex;
            Lang.each(val, new Each<Object>(){

                @Override
                public void invoke(int index, Object ele, int length) {
                    if (null != ele && REG.matcher(ele.toString()).matches()) {
                        re[0] = true;
                        Lang.Break();
                    }
                }
            });
            return re[0];
        }
        if (mi.isSimple()) {
            re = new boolean[1];
            Lang.each(val, new Each<Object>(){

                @Override
                public void invoke(int index, Object ele, int length) {
                    if (null != ele && ele.equals(mtc)) {
                        re[0] = true;
                        Lang.Break();
                    }
                }
            });
            return re[0];
        }
        if (mi.is(Region.class)) {
            throw Lang.noImplement();
        }
        return false;
    }
}

