/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.resource;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import org.nutz.castor.Castors;
import org.nutz.lang.Lang;
import org.nutz.lang.Stopwatch;
import org.nutz.lang.Streams;
import org.nutz.lang.util.ClassTools;
import org.nutz.lang.util.Disks;
import org.nutz.lang.util.FileVisitor;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.JarEntryInfo;
import org.nutz.resource.NutResource;
import org.nutz.resource.impl.ErrorResourceLocation;
import org.nutz.resource.impl.FileResource;
import org.nutz.resource.impl.FileSystemResourceLocation;
import org.nutz.resource.impl.JarResource;
import org.nutz.resource.impl.JarResourceLocation;
import org.nutz.resource.impl.ResourceLocation;
import org.nutz.resource.impl.SimpleResource;
import org.nutz.resource.impl.WebClassesResourceLocation;

public class Scans {
    private static final String FLT_CLASS = "^.+[.]class$";
    private static final Log log = Logs.get();
    private static Scans me = new Scans();
    private Map<String, ResourceLocation> locations = new LinkedHashMap<String, ResourceLocation>();
    protected String[] referPaths = new String[]{"META-INF/MANIFEST.MF", "log4j.properties", ".nutz.resource.mark"};

    public Scans init(ServletContext sc) {
        Stopwatch sw = Stopwatch.begin();
        String classesPath = sc.getRealPath("/WEB-INF/classes");
        if (classesPath == null) {
            this.addResourceLocation(new WebClassesResourceLocation(sc));
        } else {
            ResourceLocation rc = ResourceLocation.file(new File(classesPath));
            if (rc instanceof FileSystemResourceLocation) {
                ((FileSystemResourceLocation)rc).priority = 125;
            }
            this.addResourceLocation(rc);
        }
        Set jars = sc.getResourcePaths("/WEB-INF/lib/");
        if (jars != null) {
            for (String path : jars) {
                if (!path.endsWith(".jar")) continue;
                try {
                    this.addResourceLocation(new JarResourceLocation(sc.getResource(path)));
                }
                catch (Exception e) {
                    log.debug("parse jar fail >> " + e.getMessage());
                }
            }
        }
        sw.stop();
        this.printLocations(sw);
        return this;
    }

    public List<NutResource> loadResource(String regex, String ... paths) {
        LinkedList<NutResource> list = new LinkedList<NutResource>();
        for (String path : paths) {
            list.addAll(this.scan(path, regex));
        }
        if (list.size() < 1 && paths.length > 0) {
            throw Lang.makeThrow(RuntimeException.class, "folder or file like '%s' no found in %s", regex, Castors.me().castToString(paths));
        }
        return list;
    }

    public void registerLocation(Class<?> klass) {
        block7: {
            if (klass == null) {
                return;
            }
            try {
                this.registerLocation(klass.getProtectionDomain().getCodeSource().getLocation());
            }
            catch (Throwable e) {
                String classFile = klass.getName().replace('.', '/') + ".class";
                URL url = ClassTools.getClassLoader().getResource(classFile);
                if (url == null) break block7;
                String str = url.toString();
                try {
                    str = URLDecoder.decode(str, "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    throw Lang.impossible();
                }
                str = str.substring(0, str.length() - classFile.length());
                try {
                    this.registerLocation(new URL(str));
                }
                catch (Throwable e2) {
                    if (!log.isInfoEnabled()) break block7;
                    log.info("Fail to registerLocation --> " + str, e);
                }
            }
        }
    }

    public void registerLocation(URL url) {
        if (url == null) {
            return;
        }
        this.addResourceLocation(this.makeResourceLocation(url));
    }

    protected ResourceLocation makeResourceLocation(URL url) {
        block8: {
            try {
                String str = url.toString();
                if (str.endsWith(".jar")) {
                    return new JarResourceLocation(url);
                }
                if (str.contains("jar!")) {
                    if (str.startsWith("jar:file:")) {
                        str = str.substring("jar:file:".length());
                    }
                    return ResourceLocation.jar(str.substring(0, str.lastIndexOf("jar!") + 3));
                }
                if (str.startsWith("file:")) {
                    return ResourceLocation.file(new File(url.getFile()));
                }
                if (str.startsWith("jar:file:")) {
                    return ResourceLocation.jar(str.substring(str.indexOf(33)));
                }
                if (log.isDebugEnabled()) {
                    log.debug("Unkown URL " + url);
                }
            }
            catch (Throwable e) {
                if (!log.isInfoEnabled()) break block8;
                log.info("Fail to registerLocation --> " + url, e);
            }
        }
        return ErrorResourceLocation.make(url);
    }

    public List<NutResource> scan(String src) {
        return this.scan(src, null);
    }

    public List<NutResource> scan(String src, String regex) {
        File srcFile;
        Pattern pattern;
        if (src.isEmpty()) {
            throw new RuntimeException("emtry src is NOT allow");
        }
        if ("/".equals(src)) {
            throw new RuntimeException("root path is NOT allow");
        }
        ArrayList<NutResource> list = new ArrayList<NutResource>();
        Pattern pattern2 = pattern = regex == null ? null : Pattern.compile(regex);
        if (src.startsWith("~/")) {
            src = Disks.normalize(src);
        }
        if ((srcFile = new File(src)).exists()) {
            if (srcFile.isDirectory()) {
                Disks.visitFile(srcFile, new ResourceFileVisitor(list, src, 250), new ResourceFileFilter(pattern));
            } else {
                list.add(new FileResource(src, srcFile).setPriority(250));
            }
        }
        for (ResourceLocation location : this.locations.values()) {
            location.scan(src, pattern, list);
        }
        if (list.isEmpty()) {
            block22: {
                try {
                    Enumeration<URL> enu = ClassTools.getClassLoader().getResources(src);
                    if (enu != null && enu.hasMoreElements()) {
                        while (enu.hasMoreElements()) {
                            try {
                                URL url = enu.nextElement();
                                ResourceLocation loc = this.makeResourceLocation(url);
                                if (url.toString().contains("jar!")) {
                                    loc.scan(src, pattern, list);
                                    continue;
                                }
                                loc.scan("", pattern, list);
                            }
                            catch (Throwable e) {
                                if (!log.isTraceEnabled()) continue;
                                log.trace("", e);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    if (!log.isDebugEnabled()) break block22;
                    log.debug("Fail to run deep scan!", e);
                }
            }
            if (list.isEmpty()) {
                try {
                    InputStream ins = this.getClass().getClassLoader().getResourceAsStream(src);
                    if (ins != null) {
                        list.add(new SimpleResource(src, src, ins));
                    }
                }
                catch (Exception ins) {
                    // empty catch block
                }
            }
        }
        ArrayList<NutResource> _list = new ArrayList<NutResource>();
        block8: for (NutResource nr : list) {
            Iterator it = _list.iterator();
            while (it.hasNext()) {
                NutResource nr2 = (NutResource)it.next();
                if (!nr.equals(nr2)) continue;
                if (nr.priority <= nr2.priority) continue block8;
                it.remove();
            }
            _list.add(nr);
        }
        list = _list;
        Collections.sort(list);
        if (log.isDebugEnabled()) {
            log.debugf("Found %s resource by src( %s ) , regex( %s )", list.size(), src, regex);
        }
        return list;
    }

    public List<Class<?>> scanPackage(Class<?> classZ) {
        return this.scanPackage(classZ.getPackage().getName(), FLT_CLASS);
    }

    public List<Class<?>> scanPackage(Class<?> classZ, String regex) {
        return this.scanPackage(classZ.getPackage().getName(), regex);
    }

    public List<Class<?>> scanPackage(String pkg) {
        return this.scanPackage(pkg, FLT_CLASS);
    }

    public List<Class<?>> scanPackage(String pkg, String regex) {
        String packagePath = pkg.replace('.', '/').replace('\\', '/');
        if (!packagePath.endsWith("/")) {
            packagePath = packagePath + "/";
        }
        return Scans.rs2class(pkg, this.scan(packagePath, regex));
    }

    public static boolean isInJar(File file) {
        return Scans.isInJar(file.getAbsolutePath());
    }

    public static boolean isInJar(String filePath) {
        return filePath.contains(".jar!");
    }

    public static NutResource makeJarNutResource(File file) {
        return Scans.makeJarNutResource(file.getAbsolutePath());
    }

    public static NutResource makeJarNutResource(String filePath) {
        JarEntryInfo jeInfo = new JarEntryInfo(filePath);
        try {
            ZipInputStream zis = Scans.makeZipInputStream(jeInfo.getJarPath());
            ZipEntry ens = null;
            while (null != (ens = zis.getNextEntry())) {
                if (ens.isDirectory() || !jeInfo.getEntryName().equals(ens.getName())) continue;
                return Scans.makeJarNutResource(jeInfo.getJarPath(), ens.getName(), "");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static NutResource makeJarNutResource(String jarPath, String entryName, String base) throws IOException {
        JarResource nutResource = new JarResource(jarPath, entryName);
        if (entryName.equals(base)) {
            nutResource.setName(entryName);
        } else {
            nutResource.setName(entryName.substring(base.length()));
        }
        nutResource.setSource(jarPath + ":" + entryName);
        return nutResource;
    }

    public static ZipInputStream makeZipInputStream(String jarPath) throws MalformedURLException, IOException {
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new FileInputStream(jarPath));
        }
        catch (IOException e) {
            zis = new ZipInputStream(new URL(jarPath).openStream());
        }
        return zis;
    }

    public static final Scans me() {
        return me;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Class<?>> rs2class(String pkg, List<NutResource> list) {
        LinkedHashSet re = new LinkedHashSet(list.size());
        if (!list.isEmpty()) {
            for (NutResource nr : list) {
                if (!nr.getName().endsWith(".class") || nr.getName().endsWith("package-info.class")) continue;
                String className = pkg + "." + nr.getName().substring(0, nr.getName().length() - 6).replaceAll("[/\\\\]", ".");
                try {
                    Class<?> klass = Lang.loadClass(className);
                    re.add(klass);
                }
                catch (Throwable klass) {
                    InputStream in = null;
                    try {
                        in = nr.getInputStream();
                        className = ClassTools.getClassName(in);
                        if (className == null) {
                            if (!log.isInfoEnabled()) continue;
                            log.infof("Resource can't map to Class, Resource %s", nr);
                            continue;
                        }
                        Class<?> klass2 = Lang.loadClass(className);
                        re.add(klass2);
                    }
                    catch (Throwable e) {
                        if (!log.isInfoEnabled()) continue;
                        log.info("Resource can't map to Class, Resource " + nr.getName());
                    }
                    finally {
                        Streams.safeClose(in);
                    }
                }
            }
        }
        return new ArrayList(re);
    }

    protected Scans() {
        if (Lang.isAndroid) {
            if (log.isInfoEnabled()) {
                log.info("Running in Android , so nothing I can scan , just disable myself");
            }
            return;
        }
        Stopwatch sw = Stopwatch.begin();
        try {
            FileSystemResourceLocation rc = new FileSystemResourceLocation(new File(".").getAbsoluteFile().getCanonicalFile());
            rc.priority = 200;
            this.addResourceLocation(rc);
        }
        catch (Throwable rc) {
            // empty catch block
        }
        ClassLoader cloader = ClassTools.getClassLoader();
        for (String referPath : this.referPaths) {
            try {
                Enumeration<URL> urls = cloader.getResources(referPath);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    String url_str = url.toString();
                    if (url_str.contains("jar!")) {
                        String tmp = url_str.substring(0, url_str.lastIndexOf("jar!") + 3);
                        if (tmp.startsWith("jar:")) {
                            tmp = tmp.substring("jar:".length());
                        }
                        if (tmp.startsWith("file:/")) {
                            tmp = tmp.substring("file:/".length());
                        }
                        if (tmp.contains("tomcat") || !tmp.contains("Java")) continue;
                        continue;
                    }
                    this.registerLocation(new URL(url_str.substring(0, url_str.length() - referPath.length())));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            String[] paths;
            String classpath = System.getProperties().getProperty("java.class.path");
            for (String pathZ : paths = classpath.split(System.getProperties().getProperty("path.separator"))) {
                if (pathZ.endsWith(".jar")) {
                    this.addResourceLocation(ResourceLocation.jar(pathZ));
                    continue;
                }
                this.addResourceLocation(ResourceLocation.file(new File(pathZ)));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        sw.stop();
        this.printLocations(sw);
    }

    public void addResourceLocation(ResourceLocation loc) {
        this.locations.put(loc.id(), loc);
    }

    protected void printLocations(Stopwatch sw) {
        if (log.isDebugEnabled()) {
            log.debugf("Locations count=%d time use %sms", this.locations.size(), sw.du());
        }
        if (log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (ResourceLocation rc : this.locations.values()) {
                sb.append('\t').append(rc.toString()).append("\r\n");
            }
            log.trace("Locations for Scans:\n" + sb);
        }
    }

    public static class ResourceFileVisitor
    implements FileVisitor {
        String base;
        List<NutResource> list;
        int priority;

        @Override
        public void visit(File f) {
            this.list.add(new FileResource(this.base, f).setPriority(this.priority));
        }

        public ResourceFileVisitor(List<NutResource> list, String base, int priority) {
            this.list = list;
            this.base = base;
            this.priority = priority;
        }
    }

    public static class ResourceFileFilter
    implements FileFilter {
        private Pattern pattern;

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                String fnm = f.getName().toLowerCase();
                return !".svn".equals(fnm) && !".cvs".equals(fnm) && !".git".equals(fnm);
            }
            if (f.isHidden()) {
                return false;
            }
            return this.pattern == null || this.pattern.matcher(f.getName()).find();
        }

        public ResourceFileFilter(Pattern pattern) {
            this.pattern = pattern;
        }
    }
}

