/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.api.GeoEntry;
import org.redisson.api.GeoOrder;
import org.redisson.api.GeoPosition;
import org.redisson.api.GeoUnit;
import org.redisson.api.RFuture;
import org.redisson.api.RGeo;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.GeoEntryCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.ScoredCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.FlatNestedMultiDecoder;
import org.redisson.client.protocol.decoder.GeoDistanceDecoder;
import org.redisson.client.protocol.decoder.GeoMapReplayDecoder;
import org.redisson.client.protocol.decoder.GeoPositionDecoder;
import org.redisson.client.protocol.decoder.GeoPositionMapDecoder;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.NestedMultiDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.MapGetAllDecoder;

public class RedissonGeo<V>
extends RedissonScoredSortedSet<V>
implements RGeo<V> {
    MultiDecoder<Map<Object, Object>> postitionDecoder;
    MultiDecoder<Map<Object, Object>> distanceDecoder;

    public RedissonGeo(CommandAsyncExecutor connectionManager, String name, RedissonClient redisson) {
        super(connectionManager, name, redisson);
        this.postitionDecoder = new NestedMultiDecoder(new GeoPositionDecoder(), new GeoDistanceDecoder(this.codec), new GeoMapReplayDecoder(), true);
        this.distanceDecoder = new FlatNestedMultiDecoder((MultiDecoder)new GeoDistanceDecoder(this.codec), (MultiDecoder)new GeoMapReplayDecoder(), true);
    }

    public RedissonGeo(Codec codec, CommandAsyncExecutor connectionManager, String name, RedissonClient redisson) {
        super(codec, connectionManager, name, redisson);
        this.postitionDecoder = new NestedMultiDecoder(new GeoPositionDecoder(), new GeoDistanceDecoder(codec), new GeoMapReplayDecoder(), true);
        this.distanceDecoder = new FlatNestedMultiDecoder((MultiDecoder)new GeoDistanceDecoder(codec), (MultiDecoder)new GeoMapReplayDecoder(), true);
    }

    @Override
    public RFuture<Long> addAsync(double longitude, double latitude, V member) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.GEOADD, this.getName(), this.convert(longitude), this.convert(latitude), this.encode(member));
    }

    private String convert(double longitude) {
        return BigDecimal.valueOf(longitude).toPlainString();
    }

    @Override
    public long add(double longitude, double latitude, V member) {
        return this.get(this.addAsync(longitude, latitude, member));
    }

    @Override
    public long add(GeoEntry ... entries) {
        return this.get(this.addAsync(entries));
    }

    @Override
    public RFuture<Long> addAsync(GeoEntry ... entries) {
        ArrayList<Object> params = new ArrayList<Object>(entries.length + 1);
        params.add(this.getName());
        for (GeoEntry entry : entries) {
            params.add(entry.getLongitude());
            params.add(entry.getLatitude());
            params.add(this.encode(entry.getMember()));
        }
        return this.commandExecutor.writeAsync(this.getName(), (Codec)new GeoEntryCodec(this.codec), RedisCommands.GEOADD_ENTRIES, params.toArray());
    }

    @Override
    public Double dist(V firstMember, V secondMember, GeoUnit geoUnit) {
        return this.get(this.distAsync(firstMember, secondMember, geoUnit));
    }

    @Override
    public RFuture<Double> distAsync(V firstMember, V secondMember, GeoUnit geoUnit) {
        return this.commandExecutor.readAsync(this.getName(), (Codec)new ScoredCodec(this.codec), RedisCommands.GEODIST, new Object[]{this.getName(), this.encode(firstMember), this.encode(secondMember), geoUnit});
    }

    @Override
    public Map<V, String> hash(V ... members) {
        return this.get(this.hashAsync(members));
    }

    @Override
    public RFuture<Map<V, String>> hashAsync(V ... members) {
        ArrayList<String> params = new ArrayList<String>(members.length + 1);
        params.add(this.getName());
        for (V member : members) {
            params.add((String)this.encode(member));
        }
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEOHASH", new MapGetAllDecoder(Arrays.asList(members), 0));
        return this.commandExecutor.readAsync(this.getName(), (Codec)new ScoredCodec(this.codec), command, params.toArray());
    }

    @Override
    public Map<V, GeoPosition> pos(V ... members) {
        return this.get(this.posAsync(members));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> posAsync(V ... members) {
        ArrayList<String> params = new ArrayList<String>(members.length + 1);
        params.add(this.getName());
        for (V member : members) {
            params.add((String)this.encode(member));
        }
        NestedMultiDecoder decoder = new NestedMultiDecoder((MultiDecoder<Object>)new GeoPositionDecoder(), (MultiDecoder<Object>)new GeoPositionMapDecoder(Arrays.asList(members)), true);
        RedisCommand<Object> command = new RedisCommand<Object>("GEOPOS", decoder);
        return this.commandExecutor.readAsync(this.getName(), (Codec)new ScoredCodec(this.codec), command, params.toArray());
    }

    @Override
    public List<V> radius(double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusAsync(longitude, latitude, radius, geoUnit));
    }

    @Override
    public RFuture<List<V>> radiusAsync(double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.GEORADIUS, new Object[]{this.getName(), this.convert(longitude), this.convert(latitude), radius, geoUnit});
    }

    @Override
    public List<V> radius(double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusAsync(longitude, latitude, radius, geoUnit, count));
    }

    @Override
    public RFuture<List<V>> radiusAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.GEORADIUS, new Object[]{this.getName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "COUNT", count});
    }

    @Override
    public List<V> radius(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.get(this.radiusAsync(longitude, latitude, radius, geoUnit, geoOrder));
    }

    @Override
    public RFuture<List<V>> radiusAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.GEORADIUS, new Object[]{this.getName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, geoOrder});
    }

    @Override
    public List<V> radius(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusAsync(longitude, latitude, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<List<V>> radiusAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.GEORADIUS, new Object[]{this.getName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "COUNT", count, geoOrder});
    }

    @Override
    public Map<V, Double> radiusWithDistance(double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusWithDistanceAsync(longitude, latitude, radius, geoUnit));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(double longitude, double latitude, double radius, GeoUnit geoUnit) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUS", this.distanceDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHDIST"});
    }

    @Override
    public Map<V, Double> radiusWithDistance(double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusWithDistanceAsync(longitude, latitude, radius, geoUnit, count));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUS", this.distanceDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHDIST", "COUNT", count});
    }

    @Override
    public Map<V, Double> radiusWithDistance(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.get(this.radiusWithDistanceAsync(longitude, latitude, radius, geoUnit, geoOrder));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUS", this.distanceDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHDIST", geoOrder});
    }

    @Override
    public Map<V, Double> radiusWithDistance(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusWithDistanceAsync(longitude, latitude, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUS", this.distanceDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHDIST", "COUNT", count, geoOrder});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusWithPositionAsync(longitude, latitude, radius, geoUnit));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(double longitude, double latitude, double radius, GeoUnit geoUnit) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUS", this.postitionDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHCOORD"});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusWithPositionAsync(longitude, latitude, radius, geoUnit, count));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUS", this.postitionDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHCOORD", "COUNT", count});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.get(this.radiusWithPositionAsync(longitude, latitude, radius, geoUnit, geoOrder));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUS", this.postitionDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHCOORD", geoOrder});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusWithPositionAsync(longitude, latitude, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUS", this.postitionDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "WITHCOORD", "COUNT", count, geoOrder});
    }

    @Override
    public List<V> radius(V member, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusAsync(member, radius, geoUnit));
    }

    @Override
    public RFuture<List<V>> radiusAsync(V member, double radius, GeoUnit geoUnit) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.GEORADIUSBYMEMBER, new Object[]{this.getName(), this.encode(member), radius, geoUnit});
    }

    @Override
    public List<V> radius(V member, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusAsync(member, radius, geoUnit, count));
    }

    @Override
    public RFuture<List<V>> radiusAsync(V member, double radius, GeoUnit geoUnit, int count) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.GEORADIUSBYMEMBER, new Object[]{this.getName(), this.encode(member), radius, geoUnit, "COUNT", count});
    }

    @Override
    public List<V> radius(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.get(this.radiusAsync(member, radius, geoUnit, geoOrder));
    }

    @Override
    public RFuture<List<V>> radiusAsync(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.GEORADIUSBYMEMBER, new Object[]{this.getName(), this.encode(member), radius, geoUnit, geoOrder});
    }

    @Override
    public List<V> radius(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusAsync(member, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<List<V>> radiusAsync(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.GEORADIUSBYMEMBER, new Object[]{this.getName(), this.encode(member), radius, geoUnit, "COUNT", count, geoOrder});
    }

    @Override
    public Map<V, Double> radiusWithDistance(V member, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusWithDistanceAsync(member, radius, geoUnit));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(V member, double radius, GeoUnit geoUnit) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUSBYMEMBER", this.distanceDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.encode(member), radius, geoUnit, "WITHDIST"});
    }

    @Override
    public Map<V, Double> radiusWithDistance(V member, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusWithDistanceAsync(member, radius, geoUnit, count));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(V member, double radius, GeoUnit geoUnit, int count) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUSBYMEMBER", this.distanceDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.encode(member), radius, geoUnit, "WITHDIST", "COUNT", count});
    }

    @Override
    public Map<V, Double> radiusWithDistance(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.get(this.radiusWithDistanceAsync(member, radius, geoUnit, geoOrder));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUSBYMEMBER", this.distanceDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.encode(member), radius, geoUnit, "WITHDIST", geoOrder});
    }

    @Override
    public Map<V, Double> radiusWithDistance(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusWithDistanceAsync(member, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<Map<V, Double>> radiusWithDistanceAsync(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUSBYMEMBER", this.distanceDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.encode(member), radius, geoUnit, "WITHDIST", "COUNT", count, geoOrder});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(V member, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusWithPositionAsync(member, radius, geoUnit));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(V member, double radius, GeoUnit geoUnit) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUSBYMEMBER", this.postitionDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.encode(member), radius, geoUnit, "WITHCOORD"});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(V member, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusWithPositionAsync(member, radius, geoUnit, count));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(V member, double radius, GeoUnit geoUnit, int count) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUSBYMEMBER", this.postitionDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.encode(member), radius, geoUnit, "WITHCOORD", "COUNT", count});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        return this.get(this.radiusWithPositionAsync(member, radius, geoUnit, geoOrder));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUSBYMEMBER", this.postitionDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.encode(member), radius, geoUnit, "WITHCOORD", geoOrder});
    }

    @Override
    public Map<V, GeoPosition> radiusWithPosition(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusWithPositionAsync(member, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<Map<V, GeoPosition>> radiusWithPositionAsync(V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEORADIUSBYMEMBER", this.postitionDecoder);
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, new Object[]{this.getName(), this.encode(member), radius, geoUnit, "WITHCOORD", "COUNT", count, geoOrder});
    }

    @Override
    public long radiusStoreTo(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusStoreToAsync(destName, longitude, latitude, radius, geoUnit));
    }

    @Override
    public RFuture<Long> radiusStoreToAsync(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.GEORADIUS_STORE, new Object[]{this.getName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "STORE", destName});
    }

    @Override
    public long radiusStoreTo(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusStoreToAsync(destName, longitude, latitude, radius, geoUnit, count));
    }

    @Override
    public RFuture<Long> radiusStoreToAsync(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit, int count) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.GEORADIUS_STORE, new Object[]{this.getName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, "COUNT", count, "STORE", destName});
    }

    @Override
    public long radiusStoreTo(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusStoreToAsync(destName, longitude, latitude, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<Long> radiusStoreToAsync(String destName, double longitude, double latitude, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.GEORADIUS_STORE, new Object[]{this.getName(), this.convert(longitude), this.convert(latitude), radius, geoUnit, geoOrder, "COUNT", count, "STORE", destName});
    }

    @Override
    public long radiusStoreTo(String destName, V member, double radius, GeoUnit geoUnit) {
        return this.get(this.radiusStoreToAsync(destName, member, radius, geoUnit));
    }

    @Override
    public RFuture<Long> radiusStoreToAsync(String destName, V member, double radius, GeoUnit geoUnit) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.GEORADIUSBYMEMBER_STORE, new Object[]{this.getName(), this.encode(member), radius, geoUnit, "STORE", destName});
    }

    @Override
    public long radiusStoreTo(String destName, V member, double radius, GeoUnit geoUnit, int count) {
        return this.get(this.radiusStoreToAsync(destName, member, radius, geoUnit, count));
    }

    @Override
    public RFuture<Long> radiusStoreToAsync(String destName, V member, double radius, GeoUnit geoUnit, int count) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.GEORADIUSBYMEMBER_STORE, new Object[]{this.getName(), this.encode(member), radius, geoUnit, "COUNT", count, "STORE", destName});
    }

    @Override
    public long radiusStoreTo(String destName, V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.get(this.radiusStoreToAsync(destName, member, radius, geoUnit, geoOrder, count));
    }

    @Override
    public RFuture<Long> radiusStoreToAsync(String destName, V member, double radius, GeoUnit geoUnit, GeoOrder geoOrder, int count) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.GEORADIUSBYMEMBER_STORE, new Object[]{this.getName(), this.encode(member), radius, geoUnit, geoOrder, "COUNT", count, "STORE", destName});
    }
}

