/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.RedissonBaseIterator;
import org.redisson.SlotCallback;
import org.redisson.api.RFuture;
import org.redisson.api.RKeys;
import org.redisson.api.RObject;
import org.redisson.api.RType;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.ScanCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.CompositeIterable;
import org.redisson.misc.RPromise;

public class RedissonKeys
implements RKeys {
    private final CommandAsyncExecutor commandExecutor;

    public RedissonKeys(CommandAsyncExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public RType getType(String key) {
        return this.commandExecutor.get(this.getTypeAsync(key));
    }

    @Override
    public RFuture<RType> getTypeAsync(String key) {
        return this.commandExecutor.readAsync(key, RedisCommands.TYPE, key);
    }

    @Override
    public int getSlot(String key) {
        return this.commandExecutor.get(this.getSlotAsync(key));
    }

    @Override
    public RFuture<Integer> getSlotAsync(String key) {
        return this.commandExecutor.readAsync(null, RedisCommands.KEYSLOT, key);
    }

    @Override
    public Iterable<String> getKeysByPattern(String pattern) {
        return this.getKeysByPattern(pattern, 10);
    }

    @Override
    public Iterable<String> getKeysByPattern(final String pattern, final int count) {
        ArrayList iterables = new ArrayList();
        for (final MasterSlaveEntry entry : this.commandExecutor.getConnectionManager().getEntrySet()) {
            Iterable<String> iterable = new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return RedissonKeys.this.createKeysIterator(entry, pattern, count);
                }
            };
            iterables.add(iterable);
        }
        return new CompositeIterable<String>(iterables);
    }

    @Override
    public Iterable<String> getKeys() {
        return this.getKeysByPattern(null);
    }

    private ListScanResult<ScanObjectEntry> scanIterator(InetSocketAddress client, MasterSlaveEntry entry, long startPos, String pattern, int count) {
        if (pattern == null) {
            RFuture f = this.commandExecutor.readAsync(client, entry, (Codec)new ScanCodec(StringCodec.INSTANCE), RedisCommands.SCAN, startPos, "COUNT", count);
            return (ListScanResult)this.commandExecutor.get(f);
        }
        RFuture f = this.commandExecutor.readAsync(client, entry, (Codec)new ScanCodec(StringCodec.INSTANCE), RedisCommands.SCAN, startPos, "MATCH", pattern, "COUNT", count);
        return (ListScanResult)this.commandExecutor.get(f);
    }

    private Iterator<String> createKeysIterator(final MasterSlaveEntry entry, final String pattern, final int count) {
        return new RedissonBaseIterator<String>(){

            @Override
            ListScanResult<ScanObjectEntry> iterator(InetSocketAddress client, long nextIterPos) {
                return RedissonKeys.this.scanIterator(client, entry, nextIterPos, pattern, count);
            }

            @Override
            void remove(String value) {
                RedissonKeys.this.delete(value);
            }
        };
    }

    @Override
    public long touch(String ... names) {
        return this.commandExecutor.get(this.touchAsync(names));
    }

    @Override
    public RFuture<Long> touchAsync(String ... names) {
        return this.commandExecutor.writeAllAsync(RedisCommands.TOUCH_LONG, new SlotCallback<Long, Long>(){
            AtomicLong results = new AtomicLong();

            @Override
            public void onSlotResult(Long result) {
                this.results.addAndGet(result);
            }

            @Override
            public Long onFinish() {
                return this.results.get();
            }
        }, (Object[])names);
    }

    @Override
    public long countExists(String ... names) {
        return this.commandExecutor.get(this.countExistsAsync(names));
    }

    @Override
    public RFuture<Long> countExistsAsync(String ... names) {
        return this.commandExecutor.readAllAsync(RedisCommands.EXISTS_LONG, new SlotCallback<Long, Long>(){
            AtomicLong results = new AtomicLong();

            @Override
            public void onSlotResult(Long result) {
                this.results.addAndGet(result);
            }

            @Override
            public Long onFinish() {
                return this.results.get();
            }
        }, (Object[])names);
    }

    @Override
    public String randomKey() {
        return this.commandExecutor.get(this.randomKeyAsync());
    }

    @Override
    public RFuture<String> randomKeyAsync() {
        return this.commandExecutor.readRandomAsync(RedisCommands.RANDOM_KEY, new Object[0]);
    }

    @Override
    public Collection<String> findKeysByPattern(String pattern) {
        return this.commandExecutor.get(this.findKeysByPatternAsync(pattern));
    }

    @Override
    public RFuture<Collection<String>> findKeysByPatternAsync(String pattern) {
        return this.commandExecutor.readAllAsync(RedisCommands.KEYS, pattern);
    }

    @Override
    public long deleteByPattern(String pattern) {
        return this.commandExecutor.get(this.deleteByPatternAsync(pattern));
    }

    @Override
    public RFuture<Long> deleteByPatternAsync(final String pattern) {
        int batchSize = 100;
        final RPromise<Long> result = this.commandExecutor.getConnectionManager().newPromise();
        final AtomicReference failed = new AtomicReference();
        final AtomicLong count = new AtomicLong();
        Collection<MasterSlaveEntry> entries = this.commandExecutor.getConnectionManager().getEntrySet();
        final AtomicLong executed = new AtomicLong(entries.size());
        FutureListener<Long> listener = new FutureListener<Long>(){

            public void operationComplete(Future<Long> future) throws Exception {
                if (future.isSuccess()) {
                    count.addAndGet((Long)future.getNow());
                } else {
                    failed.set(future.cause());
                }
                RedissonKeys.this.checkExecution(result, failed, count, executed);
            }
        };
        for (final MasterSlaveEntry entry : entries) {
            this.commandExecutor.getConnectionManager().getExecutor().execute(new Runnable((FutureListener)listener){
                final /* synthetic */ FutureListener val$listener;
                {
                    this.val$listener = futureListener;
                }

                @Override
                public void run() {
                    long count = 0L;
                    try {
                        Iterator keysIterator = RedissonKeys.this.createKeysIterator(entry, pattern, 100);
                        ArrayList<String> keys = new ArrayList<String>();
                        while (keysIterator.hasNext()) {
                            String key = (String)keysIterator.next();
                            keys.add(key);
                            if (keys.size() % 100 != 0) continue;
                            count += RedissonKeys.this.delete(keys.toArray(new String[keys.size()]));
                            keys.clear();
                        }
                        if (!keys.isEmpty()) {
                            count += RedissonKeys.this.delete(keys.toArray(new String[keys.size()]));
                            keys.clear();
                        }
                        Future future = ImmediateEventExecutor.INSTANCE.newSucceededFuture((Object)count);
                        future.addListener((GenericFutureListener)this.val$listener);
                    }
                    catch (Exception e) {
                        Future future = ImmediateEventExecutor.INSTANCE.newFailedFuture((Throwable)e);
                        future.addListener((GenericFutureListener)this.val$listener);
                    }
                }
            });
        }
        return result;
    }

    @Override
    public long delete(String ... keys) {
        return this.commandExecutor.get(this.deleteAsync(keys));
    }

    @Override
    public long delete(RObject ... objects) {
        return this.commandExecutor.get(this.deleteAsync(objects));
    }

    @Override
    public RFuture<Long> deleteAsync(RObject ... objects) {
        ArrayList<String> keys = new ArrayList<String>();
        for (RObject obj : objects) {
            keys.add(obj.getName());
        }
        return this.deleteAsync(keys.toArray(new String[keys.size()]));
    }

    @Override
    public long unlink(String ... keys) {
        return this.commandExecutor.get(this.deleteAsync(keys));
    }

    @Override
    public RFuture<Long> unlinkAsync(String ... keys) {
        return this.executeAsync(RedisCommands.UNLINK, keys);
    }

    @Override
    public RFuture<Long> deleteAsync(String ... keys) {
        return this.executeAsync(RedisCommands.DEL, keys);
    }

    private RFuture<Long> executeAsync(RedisStrictCommand<Long> command, String ... keys) {
        if (!this.commandExecutor.getConnectionManager().isClusterMode()) {
            return this.commandExecutor.writeAsync(null, command, keys);
        }
        HashMap<MasterSlaveEntry, ArrayList<String>> range2key = new HashMap<MasterSlaveEntry, ArrayList<String>>();
        for (String key : keys) {
            int slot = this.commandExecutor.getConnectionManager().calcSlot(key);
            MasterSlaveEntry entry = this.commandExecutor.getConnectionManager().getEntry(slot);
            ArrayList<String> list = (ArrayList<String>)range2key.get(entry);
            if (list == null) {
                list = new ArrayList<String>();
                range2key.put(entry, list);
            }
            list.add(key);
        }
        final RPromise<Long> result = this.commandExecutor.getConnectionManager().newPromise();
        final AtomicReference failed = new AtomicReference();
        final AtomicLong count = new AtomicLong();
        final AtomicLong executed = new AtomicLong(range2key.size());
        FutureListener listener = new FutureListener<List<?>>(){

            public void operationComplete(Future<List<?>> future) throws Exception {
                if (future.isSuccess()) {
                    List result2 = (List)future.get();
                    for (Long res : result2) {
                        if (res == null) continue;
                        count.addAndGet(res);
                    }
                } else {
                    failed.set(future.cause());
                }
                RedissonKeys.this.checkExecution(result, failed, count, executed);
            }
        };
        for (Map.Entry entry : range2key.entrySet()) {
            CommandBatchService executorService = new CommandBatchService(this.commandExecutor.getConnectionManager());
            for (String key : (List)entry.getValue()) {
                executorService.writeAsync((MasterSlaveEntry)entry.getKey(), null, command, key);
            }
            RFuture<List<?>> future = executorService.executeAsync();
            future.addListener(listener);
        }
        return result;
    }

    @Override
    public long count() {
        return this.commandExecutor.get(this.countAsync());
    }

    @Override
    public RFuture<Long> countAsync() {
        return this.commandExecutor.readAllAsync(RedisCommands.DBSIZE, new SlotCallback<Long, Long>(){
            AtomicLong results = new AtomicLong();

            @Override
            public void onSlotResult(Long result) {
                this.results.addAndGet(result);
            }

            @Override
            public Long onFinish() {
                return this.results.get();
            }
        }, new Object[0]);
    }

    @Override
    public void flushdbParallel() {
        this.commandExecutor.get(this.flushdbParallelAsync());
    }

    @Override
    public RFuture<Void> flushdbParallelAsync() {
        return this.commandExecutor.writeAllAsync(RedisCommands.FLUSHDB_ASYNC, new Object[0]);
    }

    @Override
    public void flushallParallel() {
        this.commandExecutor.get(this.flushallParallelAsync());
    }

    @Override
    public RFuture<Void> flushallParallelAsync() {
        return this.commandExecutor.writeAllAsync(RedisCommands.FLUSHALL_ASYNC, new Object[0]);
    }

    @Override
    public void flushdb() {
        this.commandExecutor.get(this.flushdbAsync());
    }

    @Override
    public RFuture<Void> flushdbAsync() {
        return this.commandExecutor.writeAllAsync(RedisCommands.FLUSHDB, new Object[0]);
    }

    @Override
    public void flushall() {
        this.commandExecutor.get(this.flushallAsync());
    }

    @Override
    public RFuture<Void> flushallAsync() {
        return this.commandExecutor.writeAllAsync(RedisCommands.FLUSHALL, new Object[0]);
    }

    private void checkExecution(RPromise<Long> result, AtomicReference<Throwable> failed, AtomicLong count, AtomicLong executed) {
        if (executed.decrementAndGet() == 0L) {
            if (failed.get() != null) {
                if (count.get() > 0L) {
                    RedisException ex = new RedisException("" + count.get() + " keys has been deleted. But one or more nodes has an error", failed.get());
                    result.tryFailure(ex);
                } else {
                    result.tryFailure(failed.get());
                }
            } else {
                result.trySuccess(count.get());
            }
        }
    }

    @Override
    public long remainTimeToLive(String name) {
        return this.commandExecutor.get(this.remainTimeToLiveAsync(name));
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync(String name) {
        return this.commandExecutor.readAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.PTTL, name);
    }

    @Override
    public void rename(String currentName, String newName) {
        this.commandExecutor.get(this.renameAsync(currentName, newName));
    }

    @Override
    public RFuture<Void> renameAsync(String currentName, String newName) {
        return this.commandExecutor.writeAsync(currentName, RedisCommands.RENAME, currentName, newName);
    }

    @Override
    public boolean renamenx(String oldName, String newName) {
        return this.commandExecutor.get(this.renamenxAsync(oldName, newName));
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String oldName, String newName) {
        return this.commandExecutor.writeAsync(oldName, RedisCommands.RENAMENX, oldName, newName);
    }

    @Override
    public boolean clearExpire(String name) {
        return this.commandExecutor.get(this.clearExpireAsync(name));
    }

    @Override
    public RFuture<Boolean> clearExpireAsync(String name) {
        return this.commandExecutor.writeAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.PERSIST, name);
    }

    @Override
    public boolean expireAt(String name, long timestamp) {
        return this.commandExecutor.get(this.expireAtAsync(name, timestamp));
    }

    @Override
    public RFuture<Boolean> expireAtAsync(String name, long timestamp) {
        return this.commandExecutor.writeAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.PEXPIREAT, name, timestamp);
    }

    @Override
    public boolean expire(String name, long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.get(this.expireAsync(name, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Boolean> expireAsync(String name, long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.writeAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.PEXPIRE, name, timeUnit.toMillis(timeToLive));
    }

    @Override
    public void migrate(String name, String host, int port, int database) {
        this.commandExecutor.get(this.migrateAsync(name, host, port, database));
    }

    @Override
    public RFuture<Void> migrateAsync(String name, String host, int port, int database) {
        return this.commandExecutor.writeAsync(name, RedisCommands.MIGRATE, host, port, name, database);
    }

    @Override
    public boolean move(String name, int database) {
        return this.commandExecutor.get(this.moveAsync(name, database));
    }

    @Override
    public RFuture<Boolean> moveAsync(String name, int database) {
        return this.commandExecutor.writeAsync(name, RedisCommands.MOVE, name, database);
    }
}

