/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.redisson.RedissonLock;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.pubsub.LockPubSub;

public class RedissonReadLock
extends RedissonLock
implements RLock {
    public RedissonReadLock(CommandAsyncExecutor commandExecutor, String name, UUID id) {
        super(commandExecutor, name, id);
    }

    @Override
    String getChannelName() {
        return this.prefixName("redisson_rwlock", this.getName());
    }

    String getWriteLockName(long threadId) {
        return super.getLockName(threadId) + ":write";
    }

    String getReadWriteTimeoutNamePrefix(long threadId) {
        return this.suffixName(this.getName(), this.getLockName(threadId)) + ":rwlock_timeout";
    }

    @Override
    <T> RFuture<T> tryLockInnerAsync(long leaseTime, TimeUnit unit, long threadId, RedisStrictCommand<T> command) {
        this.internalLockLeaseTime = unit.toMillis(leaseTime);
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, command, "local mode = redis.call('hget', KEYS[1], 'mode'); if (mode == false) then redis.call('hset', KEYS[1], 'mode', 'read'); redis.call('hset', KEYS[1], ARGV[2], 1); redis.call('set', KEYS[2] .. ':1', 1); redis.call('pexpire', KEYS[2] .. ':1', ARGV[1]); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; if (mode == 'read') or (mode == 'write' and redis.call('hexists', KEYS[1], ARGV[3]) == 1) then local ind = redis.call('hincrby', KEYS[1], ARGV[2], 1); local key = KEYS[2] .. ':' .. ind;redis.call('set', key, 1); redis.call('pexpire', key, ARGV[1]); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end;return redis.call('pttl', KEYS[1]);", Arrays.asList(this.getName(), this.getReadWriteTimeoutNamePrefix(threadId)), this.internalLockLeaseTime, this.getLockName(threadId), this.getWriteLockName(threadId));
    }

    @Override
    protected RFuture<Boolean> unlockInnerAsync(long threadId) {
        String timeoutPrefix = this.getReadWriteTimeoutNamePrefix(threadId);
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local mode = redis.call('hget', KEYS[1], 'mode'); if (mode == false) then redis.call('publish', KEYS[2], ARGV[1]); return 1; end; local lockExists = redis.call('hexists', KEYS[1], ARGV[2]); if (lockExists == 0) then return nil;end; local counter = redis.call('hincrby', KEYS[1], ARGV[2], -1); if (counter == 0) then redis.call('hdel', KEYS[1], ARGV[2]); end;redis.call('del', KEYS[3] .. ':' .. (counter+1)); if (redis.call('hlen', KEYS[1]) > 1) then local maxRemainTime = -3; local keys = redis.call('hkeys', KEYS[1]); for n, key in ipairs(keys) do counter = tonumber(redis.call('hget', KEYS[1], key)); if type(counter) == 'number' then for i=counter, 1, -1 do local remainTime = redis.call('pttl', KEYS[4] .. ':' .. key .. ':rwlock_timeout:' .. i); maxRemainTime = math.max(remainTime, maxRemainTime);end; end; end; if maxRemainTime > 0 then redis.call('pexpire', KEYS[1], maxRemainTime); return 0; end;if mode == 'write' then return 0;end; end; redis.call('del', KEYS[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1; ", Arrays.asList(this.getName(), this.getChannelName(), timeoutPrefix, timeoutPrefix.split(":")[0]), LockPubSub.unlockMessage, this.getLockName(threadId));
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> forceUnlockAsync() {
        RFuture<Boolean> result = this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('hget', KEYS[1], 'mode') == 'read') then redis.call('del', KEYS[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1; end; return 0; ", Arrays.asList(this.getName(), this.getChannelName()), LockPubSub.unlockMessage);
        result.addListener(new FutureListener<Boolean>(){

            public void operationComplete(Future<Boolean> future) throws Exception {
                if (future.isSuccess() && ((Boolean)future.getNow()).booleanValue()) {
                    RedissonReadLock.this.cancelExpirationRenewal();
                }
            }
        });
        return result;
    }

    @Override
    public boolean isLocked() {
        RFuture future = this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.HGET, this.getName(), "mode");
        String res = (String)this.get(future);
        return "read".equals(res);
    }
}

