/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.CharsetUtil;
import java.util.HashMap;
import java.util.Map;
import org.redisson.client.protocol.CommandData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class CommandEncoder
extends MessageToByteEncoder<CommandData<?, ?>> {
    public static final CommandEncoder INSTANCE = new CommandEncoder();
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final char ARGS_PREFIX = '*';
    private static final char BYTES_PREFIX = '$';
    private static final byte[] CRLF = "\r\n".getBytes();
    private static final Map<Long, byte[]> longCache = new HashMap<Long, byte[]>();
    static final char[] DIGITTENS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DIGITONES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final int[] SIZETABLE = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.acceptOutboundMessage(msg) && !promise.setUncancellable()) {
            return;
        }
        try {
            super.write(ctx, msg, promise);
        }
        catch (Exception e) {
            promise.tryFailure((Throwable)e);
            throw e;
        }
    }

    protected void encode(ChannelHandlerContext ctx, CommandData<?, ?> msg, ByteBuf out) throws Exception {
        try {
            out.writeByte(42);
            int len = 1 + msg.getParams().length;
            if (msg.getCommand().getSubName() != null) {
                ++len;
            }
            out.writeBytes(CommandEncoder.convert(len));
            out.writeBytes(CRLF);
            this.writeArgument(out, msg.getCommand().getName().getBytes(CharsetUtil.UTF_8));
            if (msg.getCommand().getSubName() != null) {
                this.writeArgument(out, msg.getCommand().getSubName().getBytes(CharsetUtil.UTF_8));
            }
            for (Object param : msg.getParams()) {
                ByteBuf buf = this.encode(param);
                this.writeArgument(out, buf);
                if (param instanceof ByteBuf) continue;
                buf.release();
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("channel: {} message: {}", (Object)ctx.channel(), (Object)out.toString(CharsetUtil.UTF_8));
            }
        }
        catch (Exception e) {
            msg.getPromise().tryFailure(e);
            throw e;
        }
    }

    private ByteBuf encode(Object in) {
        if (in instanceof byte[]) {
            byte[] payload = (byte[])in;
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer(payload.length);
            out.writeBytes(payload);
            return out;
        }
        if (in instanceof ByteBuf) {
            return (ByteBuf)in;
        }
        String payload = in.toString();
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(ByteBufUtil.utf8MaxBytes((CharSequence)payload));
        ByteBufUtil.writeUtf8((ByteBuf)buf, (CharSequence)payload);
        return buf;
    }

    private void writeArgument(ByteBuf out, byte[] arg) {
        out.writeByte(36);
        out.writeBytes(CommandEncoder.convert(arg.length));
        out.writeBytes(CRLF);
        out.writeBytes(arg);
        out.writeBytes(CRLF);
    }

    private void writeArgument(ByteBuf out, ByteBuf arg) {
        out.writeByte(36);
        out.writeBytes(CommandEncoder.convert(arg.readableBytes()));
        out.writeBytes(CRLF);
        out.writeBytes(arg, arg.readerIndex(), arg.readableBytes());
        out.writeBytes(CRLF);
    }

    static int stringSize(long x) {
        int i = 0;
        while (x > (long)SIZETABLE[i]) {
            ++i;
        }
        return i + 1;
    }

    static void getChars(long i, int index, byte[] buf) {
        long r;
        long q;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536L) {
            q = i / 100L;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = (byte)DIGITONES[(int)r];
            buf[--charPos] = (byte)DIGITTENS[(int)r];
        }
        do {
            q = i * 52429L >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = (byte)DIGITS[(int)r];
        } while ((i = q) != 0L);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static byte[] convert(long i) {
        if (i >= 0L && i <= 255L) {
            return longCache.get(i);
        }
        return CommandEncoder.toChars(i);
    }

    public static byte[] toChars(long i) {
        int size = i < 0L ? CommandEncoder.stringSize(-i) + 1 : CommandEncoder.stringSize(i);
        byte[] buf = new byte[size];
        CommandEncoder.getChars(i, size, buf);
        return buf;
    }

    static {
        for (long i = 0L; i < 256L; ++i) {
            byte[] value = CommandEncoder.toChars(i);
            longCache.put(i, value);
        }
    }
}

