/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.command.CommandReactiveService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.NodeSource;
import org.redisson.misc.RPromise;
import reactor.core.publisher.Flux;

public class CommandReactiveBatchService
extends CommandReactiveService {
    private final CommandBatchService batchService;
    private final Queue<Publisher<?>> publishers = new ConcurrentLinkedQueue();

    public CommandReactiveBatchService(ConnectionManager connectionManager) {
        super(connectionManager);
        this.batchService = new CommandBatchService(connectionManager);
    }

    @Override
    public <R> Publisher<R> reactive(Supplier<RFuture<R>> supplier) {
        Publisher<R> publisher = super.reactive(supplier);
        this.publishers.add(publisher);
        return publisher;
    }

    @Override
    protected <V, R> void async(boolean readOnlyMode, NodeSource nodeSource, Codec codec, RedisCommand<V> command, Object[] params, RPromise<R> mainPromise, int attempt) {
        this.batchService.async(readOnlyMode, nodeSource, codec, command, params, mainPromise, attempt);
    }

    public RFuture<BatchResult<?>> executeAsync(int syncSlaves, long syncTimeout, boolean skipResult, long responseTimeout, int retryAttempts, long retryInterval) {
        for (Publisher publisher : this.publishers) {
            Flux.from((Publisher)publisher).subscribe();
        }
        return this.batchService.executeAsync(syncSlaves, syncTimeout, skipResult, responseTimeout, retryAttempts, retryInterval);
    }

    @Override
    public CommandAsyncExecutor enableRedissonReferenceSupport(RedissonReactiveClient redissonReactive) {
        this.batchService.enableRedissonReferenceSupport(redissonReactive);
        return super.enableRedissonReferenceSupport(redissonReactive);
    }
}

