/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.RFuture;
import org.redisson.misc.RPromise;

public class RedissonPromise<T>
extends CompletableFuture<T>
implements RPromise<T> {
    private volatile boolean uncancellable;
    private final int SUCCESS = 1;
    private final int FAILED = 2;
    private final int CANCELED = 3;
    private final Promise<T> promise = ImmediateEventExecutor.INSTANCE.newPromise();
    private final AtomicInteger status = new AtomicInteger();

    public static <V> RFuture<V> newFailedFuture(Throwable cause) {
        RedissonPromise future = new RedissonPromise();
        future.tryFailure(cause);
        return future;
    }

    public static <V> RFuture<V> newSucceededFuture(V result) {
        RedissonPromise<V> future = new RedissonPromise<V>();
        future.trySuccess(result);
        return future;
    }

    @Override
    public boolean isSuccess() {
        return this.isDone() && !this.isCompletedExceptionally();
    }

    @Override
    public synchronized boolean trySuccess(T result) {
        if (this.status.compareAndSet(0, 1)) {
            this.complete(result);
            this.promise.trySuccess(result);
            return true;
        }
        return false;
    }

    @Override
    public Throwable cause() {
        try {
            this.getNow(null);
        }
        catch (CompletionException e) {
            return e.getCause();
        }
        return null;
    }

    @Override
    public synchronized boolean tryFailure(Throwable cause) {
        if (this.status.compareAndSet(0, 2)) {
            this.completeExceptionally(cause);
            this.promise.tryFailure(cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean setUncancellable() {
        if (!this.isDone()) {
            this.uncancellable = true;
        }
        return this.uncancellable;
    }

    @Override
    public RPromise<T> addListener(FutureListener<? super T> listener) {
        this.promise.addListener(listener);
        return this;
    }

    @Override
    public RPromise<T> addListeners(FutureListener<? super T> ... listeners) {
        this.promise.addListeners(listeners);
        return this;
    }

    @Override
    public RPromise<T> removeListener(FutureListener<? super T> listener) {
        this.promise.removeListener(listener);
        return this;
    }

    @Override
    public RPromise<T> removeListeners(FutureListener<? super T> ... listeners) {
        this.promise.removeListeners(listeners);
        return this;
    }

    @Override
    public RPromise<T> await() throws InterruptedException {
        try {
            this.get();
        }
        catch (CancellationException | ExecutionException exception) {
            // empty catch block
        }
        return this;
    }

    @Override
    public RPromise<T> awaitUninterruptibly() {
        try {
            return this.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return this;
        }
    }

    @Override
    public RPromise<T> sync() throws InterruptedException {
        try {
            this.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            PlatformDependent.throwException((Throwable)e.getCause());
        }
        return this;
    }

    @Override
    public RPromise<T> syncUninterruptibly() {
        try {
            this.join();
        }
        catch (CompletionException e) {
            PlatformDependent.throwException((Throwable)e.getCause());
        }
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            this.get(timeout, unit);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            throw new CompletionException(e.getCause());
        }
        catch (TimeoutException e) {
            return false;
        }
        return this.isDone();
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            return this.await(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        return this.awaitUninterruptibly(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public T getNow() {
        if (this.isCompletedExceptionally()) {
            return null;
        }
        return this.getNow(null);
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.uncancellable) {
            return false;
        }
        if (this.status.compareAndSet(0, 3)) {
            this.promise.cancel(mayInterruptIfRunning);
            return super.cancel(mayInterruptIfRunning);
        }
        return false;
    }
}

