/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.redisson.RedissonMapCache;
import org.redisson.api.MapOptions;
import org.redisson.api.RFuture;
import org.redisson.api.RMapCacheAsync;
import org.redisson.api.RMapCacheReactive;
import org.redisson.api.RMapReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.reactive.MapReactive;
import org.redisson.reactive.RedissonExpirableReactive;
import org.redisson.reactive.RedissonMapReactiveIterator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonMapCacheReactive<K, V>
extends RedissonExpirableReactive
implements RMapCacheReactive<K, V>,
MapReactive<K, V> {
    private final RMapCacheAsync<K, V> mapCache;

    public RedissonMapCacheReactive(EvictionScheduler evictionScheduler, CommandReactiveExecutor commandExecutor, String name, MapOptions<K, V> options) {
        super(commandExecutor, name);
        this.mapCache = new RedissonMapCache<K, V>(evictionScheduler, (CommandAsyncExecutor)commandExecutor, name, null, options);
    }

    public RedissonMapCacheReactive(EvictionScheduler evictionScheduler, Codec codec, CommandReactiveExecutor commandExecutor, String name, MapOptions<K, V> options) {
        super(codec, commandExecutor, name);
        this.mapCache = new RedissonMapCache<K, V>(codec, evictionScheduler, commandExecutor, name, null, options);
    }

    @Override
    public Publisher<Boolean> containsKey(final Object key) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.containsKeyAsync(key);
            }
        });
    }

    @Override
    public Publisher<Boolean> containsValue(final Object value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.containsValueAsync(value);
            }
        });
    }

    @Override
    public Publisher<Map<K, V>> getAll(final Set<K> keys) {
        return this.reactive(new Supplier<RFuture<Map<K, V>>>(){

            @Override
            public RFuture<Map<K, V>> get() {
                return RedissonMapCacheReactive.this.mapCache.getAllAsync(keys);
            }
        });
    }

    @Override
    public Publisher<V> putIfAbsent(final K key, final V value, final long ttl, final TimeUnit unit) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.putIfAbsentAsync(key, value, ttl, unit);
            }
        });
    }

    @Override
    public Publisher<Boolean> remove(final Object key, final Object value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.removeAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<V> get(final K key) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.getAsync(key);
            }
        });
    }

    @Override
    public Publisher<V> put(final K key, final V value, final long ttl, final TimeUnit unit) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.putAsync(key, value, ttl, unit);
            }
        });
    }

    @Override
    public Publisher<V> remove(final K key) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.removeAsync(key);
            }
        });
    }

    @Override
    public Publisher<Long> fastRemove(final K ... keys) {
        return this.reactive(new Supplier<RFuture<Long>>(){

            @Override
            public RFuture<Long> get() {
                return RedissonMapCacheReactive.this.mapCache.fastRemoveAsync(keys);
            }
        });
    }

    @Override
    public Publisher<MapScanResult<ScanObjectEntry, ScanObjectEntry>> scanIteratorReactive(final InetSocketAddress client, final long startPos) {
        return this.reactive(new Supplier<RFuture<MapScanResult<ScanObjectEntry, ScanObjectEntry>>>(){

            @Override
            public RFuture<MapScanResult<ScanObjectEntry, ScanObjectEntry>> get() {
                return ((RedissonMapCache)RedissonMapCacheReactive.this.mapCache).scanIteratorAsync(RedissonMapCacheReactive.this.getName(), client, startPos, null);
            }
        });
    }

    @Override
    public Publisher<Boolean> delete() {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.deleteAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> expire(final long timeToLive, final TimeUnit timeUnit) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.expireAsync(timeToLive, timeUnit);
            }
        });
    }

    @Override
    public Publisher<Boolean> expireAt(final long timestamp) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.expireAtAsync(timestamp);
            }
        });
    }

    @Override
    public Publisher<Boolean> clearExpire() {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.clearExpireAsync();
            }
        });
    }

    @Override
    public Publisher<Void> putAll(final Map<? extends K, ? extends V> map) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonMapCacheReactive.this.mapCache.putAllAsync(map);
            }
        });
    }

    @Override
    public Publisher<V> addAndGet(final K key, final Number delta) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.addAndGetAsync(key, delta);
            }
        });
    }

    @Override
    public Publisher<Boolean> fastPut(final K key, final V value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.fastPutAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<V> put(final K key, final V value) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.putAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<V> replace(final K key, final V value) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.replaceAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Boolean> replace(final K key, final V oldValue, final V newValue) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.replaceAsync(key, oldValue, newValue);
            }
        });
    }

    @Override
    public Publisher<V> putIfAbsent(final K key, final V value) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.putIfAbsentAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Map.Entry<K, V>> entryIterator() {
        return Flux.create(new RedissonMapReactiveIterator(this));
    }

    @Override
    public Publisher<V> valueIterator() {
        return Flux.create((Consumer)new RedissonMapReactiveIterator<K, V, V>(this){

            @Override
            V getValue(Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
                return entry.getValue().getObj();
            }
        });
    }

    @Override
    public Publisher<K> keyIterator() {
        return Flux.create((Consumer)new RedissonMapReactiveIterator<K, V, K>(this){

            @Override
            K getValue(Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
                return entry.getKey().getObj();
            }
        });
    }

    @Override
    public Publisher<Integer> size() {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonMapCacheReactive.this.mapCache.sizeAsync();
            }
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            if (m.size() != ((Integer)Mono.from(this.size()).block()).intValue()) {
                return false;
            }
            return (Boolean)Flux.from(this.entryIterator()).map(this.mapFunction(m)).reduce((Object)true, this.booleanAnd()).block();
        }
        if (o instanceof RMapReactive) {
            RMapReactive m = (RMapReactive)o;
            if (Mono.from(m.size()).block() != Mono.from(this.size()).block()) {
                return false;
            }
            return (Boolean)Flux.from(this.entryIterator()).map(this.mapFunction(m)).reduce((Object)true, this.booleanAnd()).block();
        }
        return true;
    }

    private BiFunction<Boolean, Boolean, Boolean> booleanAnd() {
        return new BiFunction<Boolean, Boolean, Boolean>(){

            @Override
            public Boolean apply(Boolean t, Boolean u) {
                return t & u;
            }
        };
    }

    private Function<Map.Entry<K, V>, Boolean> mapFunction(final Map<?, ?> m) {
        return new Function<Map.Entry<K, V>, Boolean>(){

            @Override
            public Boolean apply(Map.Entry<K, V> e) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key))) {
                    return false;
                }
                return true;
            }
        };
    }

    private Function<Map.Entry<K, V>, Boolean> mapFunction(final RMapReactive<Object, Object> m) {
        return new Function<Map.Entry<K, V>, Boolean>(){

            @Override
            public Boolean apply(Map.Entry<K, V> e) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (value == null ? Mono.from(m.get(key)).block() != null || (Boolean)Mono.from(m.containsKey(key)).block() == false : !value.equals(Mono.from(m.get(key)).block())) {
                    return false;
                }
                return true;
            }
        };
    }

    public int hashCode() {
        return (Integer)Flux.from(this.entryIterator()).map(new Function<Map.Entry<K, V>, Integer>(){

            @Override
            public Integer apply(Map.Entry<K, V> t) {
                return t.hashCode();
            }
        }).reduce((Object)0, (BiFunction)new BiFunction<Integer, Integer, Integer>(){

            @Override
            public Integer apply(Integer t, Integer u) {
                return t + u;
            }
        }).block();
    }

    @Override
    public Publisher<Void> loadAll(final boolean replaceExistingValues, final int parallelism) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonMapCacheReactive.this.mapCache.loadAllAsync(replaceExistingValues, parallelism);
            }
        });
    }

    @Override
    public Publisher<Void> loadAll(final Set<? extends K> keys, final boolean replaceExistingValues, final int parallelism) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonMapCacheReactive.this.mapCache.loadAllAsync(keys, replaceExistingValues, parallelism);
            }
        });
    }

    @Override
    public Publisher<Integer> valueSize(final K key) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonMapCacheReactive.this.mapCache.valueSizeAsync(key);
            }
        });
    }

    @Override
    public Publisher<Boolean> fastPutIfAbsent(final K key, final V value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.fastPutIfAbsentAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Set<K>> readAllKeySet() {
        return this.reactive(new Supplier<RFuture<Set<K>>>(){

            @Override
            public RFuture<Set<K>> get() {
                return RedissonMapCacheReactive.this.mapCache.readAllKeySetAsync();
            }
        });
    }

    @Override
    public Publisher<Collection<V>> readAllValues() {
        return this.reactive(new Supplier<RFuture<Collection<V>>>(){

            @Override
            public RFuture<Collection<V>> get() {
                return RedissonMapCacheReactive.this.mapCache.readAllValuesAsync();
            }
        });
    }

    @Override
    public Publisher<Set<Map.Entry<K, V>>> readAllEntrySet() {
        return this.reactive(new Supplier<RFuture<Set<Map.Entry<K, V>>>>(){

            @Override
            public RFuture<Set<Map.Entry<K, V>>> get() {
                return RedissonMapCacheReactive.this.mapCache.readAllEntrySetAsync();
            }
        });
    }

    @Override
    public Publisher<Map<K, V>> readAllMap() {
        return this.reactive(new Supplier<RFuture<Map<K, V>>>(){

            @Override
            public RFuture<Map<K, V>> get() {
                return RedissonMapCacheReactive.this.mapCache.readAllMapAsync();
            }
        });
    }

    @Override
    public Publisher<V> putIfAbsent(final K key, final V value, final long ttl, final TimeUnit ttlUnit, final long maxIdleTime, final TimeUnit maxIdleUnit) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.putIfAbsentAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit);
            }
        });
    }

    @Override
    public Publisher<V> put(final K key, final V value, final long ttl, final TimeUnit ttlUnit, final long maxIdleTime, final TimeUnit maxIdleUnit) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonMapCacheReactive.this.mapCache.putAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit);
            }
        });
    }

    @Override
    public Publisher<Boolean> fastPut(final K key, final V value, final long ttl, final TimeUnit unit) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.fastPutAsync(key, value, ttl, unit);
            }
        });
    }

    @Override
    public Publisher<Boolean> fastPut(final K key, final V value, final long ttl, final TimeUnit ttlUnit, final long maxIdleTime, final TimeUnit maxIdleUnit) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.fastPutAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit);
            }
        });
    }

    @Override
    public Publisher<Boolean> fastPutIfAbsent(final K key, final V value, final long ttl, final TimeUnit ttlUnit, final long maxIdleTime, final TimeUnit maxIdleUnit) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonMapCacheReactive.this.mapCache.fastPutIfAbsentAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit);
            }
        });
    }
}

