/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.maven.model;

import com.google.common.base.Preconditions;
import javax.xml.stream.Location;

public class XmlLocation {
    private final int line;
    private final int column;
    private final int offset;

    public XmlLocation(int line, int column, int offset) {
        Preconditions.checkArgument((line >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0);
        this.line = line;
        this.column = column;
        this.offset = offset;
    }

    public XmlLocation(int line, int offset) {
        Preconditions.checkArgument((line >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0);
        this.line = line;
        this.column = -1;
        this.offset = offset;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public int offset() {
        return this.offset;
    }

    public String toString() {
        String columnAsText = Integer.toString(this.column);
        if (this.column == -1) {
            columnAsText = "?";
        }
        return "(" + this.line + "," + columnAsText + ")[" + this.offset + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof XmlLocation) {
            XmlLocation loc = (XmlLocation)obj;
            return this.line == loc.line && this.column == loc.column;
        }
        return false;
    }

    public int hashCode() {
        return this.offset;
    }

    public static XmlLocation getLocation(Location loc) {
        return new XmlLocation(loc.getLineNumber(), loc.getColumnNumber(), loc.getCharacterOffset());
    }

    public static XmlLocation getStartLocation(String text, Location endLocation) {
        int length = text.length();
        int offset = endLocation.getCharacterOffset() - length;
        int numberLines = text.split("\\r?\\n").length - 1;
        if (numberLines > 0) {
            return new XmlLocation(endLocation.getLineNumber() - numberLines, offset);
        }
        return new XmlLocation(endLocation.getLineNumber(), endLocation.getColumnNumber() - length, offset);
    }
}

