/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.util.Objects;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.base.Preconditions;

public class DefaultIssueLocation
implements NewIssueLocation,
IssueLocation {
    private InputComponent component;
    private TextRange textRange;
    private String message;

    @Override
    public DefaultIssueLocation on(InputComponent component) {
        Preconditions.checkArgument(component != null, "Component can't be null");
        Preconditions.checkState(this.component == null, "on() already called");
        this.component = component;
        return this;
    }

    @Override
    public DefaultIssueLocation at(TextRange location) {
        Preconditions.checkState(this.component != null, "at() should be called after on()");
        Preconditions.checkState(this.component.isFile(), "at() should be called only for an InputFile.");
        DefaultInputFile file = (DefaultInputFile)this.component;
        file.validate(location);
        this.textRange = location;
        return this;
    }

    @Override
    public DefaultIssueLocation message(String message) {
        Objects.requireNonNull(message, "Message can't be null");
        this.message = StringUtils.abbreviate(StringUtils.trim(message), 4000);
        return this;
    }

    @Override
    public InputComponent inputComponent() {
        return this.component;
    }

    @Override
    public TextRange textRange() {
        return this.textRange;
    }

    @Override
    public String message() {
        return this.message;
    }
}

