/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.annotation;

import java.util.concurrent.atomic.AtomicReference;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.AbstractLazyCreationTargetSource;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.annotation.AbstractBatchConfiguration;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.configuration.support.MapJobRegistry;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class SimpleBatchConfiguration
extends AbstractBatchConfiguration {
    @Autowired
    private ApplicationContext context;
    private boolean initialized = false;
    private AtomicReference<JobRepository> jobRepository = new AtomicReference();
    private AtomicReference<JobLauncher> jobLauncher = new AtomicReference();
    private AtomicReference<JobRegistry> jobRegistry = new AtomicReference();
    private AtomicReference<PlatformTransactionManager> transactionManager = new AtomicReference();

    @Override
    @Bean
    public JobRepository jobRepository() throws Exception {
        return this.createLazyProxy(this.jobRepository, JobRepository.class);
    }

    @Override
    @Bean
    public JobLauncher jobLauncher() throws Exception {
        return this.createLazyProxy(this.jobLauncher, JobLauncher.class);
    }

    @Override
    @Bean
    public JobRegistry jobRegistry() throws Exception {
        return this.createLazyProxy(this.jobRegistry, JobRegistry.class);
    }

    @Override
    @Bean
    public PlatformTransactionManager transactionManager() throws Exception {
        return this.createLazyProxy(this.transactionManager, PlatformTransactionManager.class);
    }

    private <T> T createLazyProxy(AtomicReference<T> reference, Class<T> type) {
        ProxyFactory factory = new ProxyFactory();
        factory.setTargetSource(new ReferenceTargetSource<T>(reference));
        factory.addAdvice((Advice)new PassthruAdvice());
        factory.setInterfaces(new Class[]{type});
        Object proxy = factory.getProxy();
        return (T)proxy;
    }

    protected void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        BatchConfigurer configurer = this.getConfigurer(this.context.getBeansOfType(BatchConfigurer.class).values());
        this.jobRepository.set(configurer.getJobRepository());
        this.jobLauncher.set(configurer.getJobLauncher());
        this.transactionManager.set(configurer.getTransactionManager());
        this.jobRegistry.set(new MapJobRegistry());
        this.initialized = true;
    }

    private class ReferenceTargetSource<T>
    extends AbstractLazyCreationTargetSource {
        private AtomicReference<T> reference;

        public ReferenceTargetSource(AtomicReference<T> reference) {
            this.reference = reference;
        }

        protected Object createObject() throws Exception {
            SimpleBatchConfiguration.this.initialize();
            return this.reference.get();
        }
    }

    private class PassthruAdvice
    implements MethodInterceptor {
        private PassthruAdvice() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            return invocation.proceed();
        }
    }
}

