/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.listener.CompositeStepExecutionListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.RepeatException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractStep
implements Step,
InitializingBean,
BeanNameAware {
    private static final Log logger = LogFactory.getLog(AbstractStep.class);
    private String name;
    private int startLimit = Integer.MAX_VALUE;
    private boolean allowStartIfComplete = false;
    private CompositeStepExecutionListener stepExecutionListener = new CompositeStepExecutionListener();
    private JobRepository jobRepository;

    public AbstractStep() {
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.name != null ? 1 : 0) != 0, (String)"A Step must have a name");
        Assert.state((this.jobRepository != null ? 1 : 0) != 0, (String)"JobRepository is mandatory");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBeanName(String name) {
        if (this.name == null) {
            this.name = name;
        }
    }

    @Override
    public int getStartLimit() {
        return this.startLimit;
    }

    public void setStartLimit(int startLimit) {
        this.startLimit = startLimit;
    }

    @Override
    public boolean isAllowStartIfComplete() {
        return this.allowStartIfComplete;
    }

    public void setAllowStartIfComplete(boolean allowStartIfComplete) {
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public AbstractStep(String name) {
        this.name = name;
    }

    protected abstract void doExecute(StepExecution var1) throws Exception;

    protected void open(ExecutionContext ctx) throws Exception {
    }

    protected void close(ExecutionContext ctx) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute(StepExecution stepExecution) throws JobInterruptedException, UnexpectedJobExecutionException {
        logger.debug((Object)("Executing: id=" + stepExecution.getId()));
        stepExecution.setStartTime(new Date());
        stepExecution.setStatus(BatchStatus.STARTED);
        this.getJobRepository().update(stepExecution);
        ExitStatus exitStatus = ExitStatus.EXECUTING;
        StepSynchronizationManager.register(stepExecution);
        try {
            this.getCompositeListener().beforeStep(stepExecution);
            this.open(stepExecution.getExecutionContext());
            try {
                this.doExecute(stepExecution);
            }
            catch (RepeatException e) {
                throw e.getCause();
            }
            exitStatus = ExitStatus.COMPLETED.and(stepExecution.getExitStatus());
            if (stepExecution.isTerminateOnly()) {
                throw new JobInterruptedException("JobExecution interrupted.");
            }
            stepExecution.upgradeStatus(BatchStatus.COMPLETED);
            logger.debug((Object)("Step execution success: id=" + stepExecution.getId()));
        }
        catch (Throwable e) {
            stepExecution.upgradeStatus(AbstractStep.determineBatchStatus(e));
            exitStatus = exitStatus.and(this.getDefaultExitStatusForFailure(e));
            stepExecution.addFailureException(e);
            if (stepExecution.getStatus() == BatchStatus.STOPPED) {
                logger.info((Object)("Encountered interruption executing step: " + e.getMessage()));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Full exception", e);
                }
            } else {
                logger.error((Object)"Encountered an error executing the step", e);
            }
        }
        finally {
            try {
                exitStatus = exitStatus.and(stepExecution.getExitStatus());
                stepExecution.setExitStatus(exitStatus);
                exitStatus = exitStatus.and(this.getCompositeListener().afterStep(stepExecution));
            }
            catch (Exception e) {
                logger.error((Object)"Exception in afterStep callback", (Throwable)e);
            }
            try {
                this.getJobRepository().updateExecutionContext(stepExecution);
            }
            catch (Exception e) {
                stepExecution.setStatus(BatchStatus.UNKNOWN);
                exitStatus = exitStatus.and(ExitStatus.UNKNOWN);
                stepExecution.addFailureException(e);
                logger.error((Object)"Encountered an error saving batch meta data. This job is now in an unknown state and should not be restarted.", (Throwable)e);
            }
            stepExecution.setEndTime(new Date());
            stepExecution.setExitStatus(exitStatus);
            try {
                this.getJobRepository().update(stepExecution);
            }
            catch (Exception e) {
                stepExecution.setStatus(BatchStatus.UNKNOWN);
                stepExecution.setExitStatus(exitStatus.and(ExitStatus.UNKNOWN));
                stepExecution.addFailureException(e);
                logger.error((Object)"Encountered an error saving batch meta data. This job is now in an unknown state and should not be restarted.", (Throwable)e);
            }
            try {
                this.close(stepExecution.getExecutionContext());
            }
            catch (Exception e) {
                logger.error((Object)"Exception while closing step execution resources", (Throwable)e);
                stepExecution.addFailureException(e);
            }
            StepSynchronizationManager.release();
            logger.debug((Object)("Step execution complete: " + stepExecution.getSummary()));
        }
    }

    private static BatchStatus determineBatchStatus(Throwable e) {
        if (e instanceof JobInterruptedException || e.getCause() instanceof JobInterruptedException) {
            return BatchStatus.STOPPED;
        }
        return BatchStatus.FAILED;
    }

    public void registerStepExecutionListener(StepExecutionListener listener) {
        this.stepExecutionListener.register(listener);
    }

    public void setStepExecutionListeners(StepExecutionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.registerStepExecutionListener(listeners[i]);
        }
    }

    protected StepExecutionListener getCompositeListener() {
        return this.stepExecutionListener;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    protected JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public String toString() {
        return ClassUtils.getShortName(this.getClass()) + ": [name=" + this.name + "]";
    }

    private ExitStatus getDefaultExitStatusForFailure(Throwable ex) {
        ExitStatus exitStatus = ex instanceof JobInterruptedException || ex.getCause() instanceof JobInterruptedException ? ExitStatus.STOPPED.addExitDescription(JobInterruptedException.class.getName()) : (ex instanceof NoSuchJobException || ex.getCause() instanceof NoSuchJobException ? new ExitStatus("NO_SUCH_JOB", ex.getClass().getName()) : ExitStatus.FAILED.addExitDescription(ex));
        return exitStatus;
    }
}

