/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.listener.OrderedComposite;

public class CompositeSkipListener<T, S>
implements SkipListener<T, S> {
    private OrderedComposite<SkipListener<? super T, ? super S>> listeners = new OrderedComposite();

    public void setListeners(List<? extends SkipListener<? super T, ? super S>> listeners) {
        this.listeners.setItems(listeners);
    }

    public void register(SkipListener<? super T, ? super S> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void onSkipInRead(Throwable t) {
        Iterator<SkipListener<T, S>> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            SkipListener<T, S> listener = iterator.next();
            listener.onSkipInRead(t);
        }
    }

    @Override
    public void onSkipInWrite(S item, Throwable t) {
        Iterator<SkipListener<T, S>> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            SkipListener<T, S> listener = iterator.next();
            listener.onSkipInWrite(item, t);
        }
    }

    @Override
    public void onSkipInProcess(T item, Throwable t) {
        Iterator<SkipListener<T, S>> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            SkipListener<T, S> listener = iterator.next();
            listener.onSkipInProcess(item, t);
        }
    }
}

