/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import java.util.List;
import javax.batch.api.chunk.listener.RetryWriteListener;
import org.springframework.batch.core.listener.OrderedComposite;

public class CompositeRetryWriteListener
implements RetryWriteListener {
    private OrderedComposite<RetryWriteListener> listeners = new OrderedComposite();

    public void setListeners(List<? extends RetryWriteListener> listeners) {
        this.listeners.setItems(listeners);
    }

    public void register(RetryWriteListener listener) {
        this.listeners.add(listener);
    }

    public void onRetryWriteException(List<Object> items, Exception ex) throws Exception {
        Iterator<RetryWriteListener> iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            RetryWriteListener listener = iterator.next();
            listener.onRetryWriteException(items, ex);
        }
    }
}

