/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aggregator;

import java.util.Collection;
import org.springframework.integration.IntegrationMessageHeaderAccessor;
import org.springframework.integration.aggregator.AbstractCorrelatingMessageHandler;
import org.springframework.integration.aggregator.CorrelationStrategy;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.aggregator.ReleaseStrategy;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.messaging.Message;

public class ResequencingMessageHandler
extends AbstractCorrelatingMessageHandler {
    public ResequencingMessageHandler(MessageGroupProcessor processor, MessageGroupStore store, CorrelationStrategy correlationStrategy, ReleaseStrategy releaseStrategy) {
        super(processor, store, correlationStrategy, releaseStrategy);
    }

    public ResequencingMessageHandler(MessageGroupProcessor processor, MessageGroupStore store) {
        super(processor, store);
    }

    public ResequencingMessageHandler(MessageGroupProcessor processor) {
        super(processor);
    }

    @Override
    protected void afterRelease(MessageGroup messageGroup, Collection<Message<?>> completedMessages) {
        int size = messageGroup.getMessages().size();
        int sequenceSize = 0;
        Message<?> message = messageGroup.getOne();
        if (message != null) {
            sequenceSize = new IntegrationMessageHeaderAccessor(message).getSequenceSize();
        }
        if (sequenceSize > 0 && sequenceSize == size) {
            this.remove(messageGroup);
        } else if (completedMessages != null) {
            int lastReleasedSequenceNumber = this.findLastReleasedSequenceNumber(messageGroup.getGroupId(), completedMessages);
            this.messageStore.setLastReleasedSequenceNumberForGroup(messageGroup.getGroupId(), lastReleasedSequenceNumber);
            for (Message<?> msg : completedMessages) {
                this.messageStore.removeMessageFromGroup(messageGroup.getGroupId(), msg);
            }
        }
    }
}

